% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/marker.R
\name{marker}
\alias{marker}
\title{Marker objects}
\usage{
marker(x, ..., allelematrix = NULL, alleles = NULL, afreq = NULL,
  chrom = NA, posMb = NA, posCm = NA, name = NA, mutmod = NULL,
  rate = NULL, validate = TRUE)
}
\arguments{
\item{x}{a \code{\link{ped}} object}

\item{...}{one or more expressions of the form \code{id = genotype}, where \code{id} is
the ID label of a member of \code{x}, and \code{genotype} is a numeric or character
vector of length 1 or 2 (see Examples).}

\item{allelematrix}{a matrix with 2 columns and \code{pedsize(x)} rows. If this is
non-NULL, then \code{...} must be empty.}

\item{alleles}{a character (or coercible to character) containing allele
names. If not given, and \code{afreq} is named, \code{names(afreq)} is used. The
default action is to take the sorted vector of distinct alleles occurring in
\code{allelematrix} or \code{...}.}

\item{afreq}{a numeric of the same length as \code{alleles}, indicating the
population frequency of each allele. A warning is issued if the frequencies
don't sum to 1 after rounding to 3 decimals. If the vector is named, and
\code{alleles} is not NULL, an error is raised if \code{setequal(names(afreq), alleles)} is not TRUE. If \code{afreq} is not specified, all alleles are given
equal frequencies.}

\item{chrom}{a single integer: the chromosome number. Default: NA.}

\item{posMb}{a nonnegative real number: the physical position of the marker,
in megabases. Default: NA.}

\item{posCm}{a nonnegative real number: the centiMorgan position of the
marker. Default: NA.}

\item{name}{a character string: the name of the marker. Default: NA.}

\item{mutmod, rate}{mutation model parameters. These are passed directly to
\code{\link[pedmut:mutationModel]{pedmut::mutationModel()}}; see there for details. Note: \code{mutmod}
corresponds to the \code{model} parameter. Default: NULL (no mutation model).}

\item{validate}{if TRUE, the validity of the created \code{marker} object is
checked.}
}
\value{
An object of class \code{marker}. This is an integer matrix with 2 columns
and one row per individual, and the following attributes:
\itemize{
\item \code{alleles} (a character vector with allele labels)
\item \code{afreq} (allele frequencies; default \code{rep.int(1/length(alleles),   length(alleles))})
\item \code{chrom} (chromosome number; default = NA)
\item \code{posMb} (physical location in megabases; default = NA)
\item \code{posCm} (position in centiMorgan; default = NA)
\item \code{name} (marker identifier; default = NA)
\item \code{mutmod} (a list of two (male and female) mutation matrices; default =
NULL)
}
}
\description{
Creating a marker object associated with a pedigree
}
\examples{
x = nuclearPed(father = "fa", mother = "mo", children = "child")

# A rare SNP marker for which the child is heterozygous
m = marker(x, child = 1:2, alleles = 1:2, afreq = c(0.01, 0.99))

# Sometimes it is useful to attach the marker to the pedigree
x = setMarkers(x, m)

# A marker with a "proportional" mutation model,
# with different rates for males and females
mutrates = list(female = 0.1, male = 0.2)
marker(x, alleles = 1:2, mutmod = "prop", rate = mutrates)

}
\seealso{
\link{marker_attach}
}
