% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cdfTable.R
\name{cdfTable}
\alias{cdfTable}
\title{Table with descriptive statistics of an estimated cumulative distribution
function}
\usage{
cdfTable(x, type = "xy", rounding = 0, tex = FALSE, data.frame = FALSE)
}
\arguments{
\item{x}{Object with the estimated cumulative distribution function of the
set of continuous variables. The resulting object of \code{cont.analysis()}
of \pkg{spsurvey}-package.}

\item{type}{Type of data under analysis. Defaults to \code{type = "xy"}. See
\sQuote{Details}.}

\item{rounding}{Rounding level of the data in the output table. Defaults to
\code{rounding = 0}.}

\item{tex}{Logical for creating TeX code. Defaults to \code{tex = FALSE}.}

\item{data.frame}{Logical for returning a data.frame object. Defaults to
\code{data.frame = FALSE}.}
}
\value{
Returned value depends on how arguments \code{type} and \code{tex}
are set. \item{list("type")}{ If \code{type = "xy"}, then the function
returns a table with estimated population mean and standard deviation of
error statistics for \sQuote{x} and \sQuote{y} coordinates. These error
statistics include the mean error, mean absolute error, and mean square
error. It also returns the estimated mean and mean square error vector
(module), and the estimated mean azimuth. The number of ground control
points used to make the estimates is printed by default.

If \code{type = "z"}, then the function returns a table with estimated
population mean and standard deviation of error statistics for \sQuote{z},
the attribute under analysis. These error statistics include the mean error,
mean absolute error, and mean square error. The number of ground control
points used to make the estimates is printed by default. }
\item{list("tex")}{ If \code{tex = TRUE}, them the function prints the TeX
code for the table defined by the argument \code{type}. Otherwise the TeX
code is not generated. }
}
\description{
This function returns a table containing the descriptive statistics of the
cumulative distribution function of a set of continuous variables. TeX code
is printed to copy and paste in a document.
}
\details{
Summary statistics included in the table (estimated population mean and
standard deviation) are obtained from the resulting object of
\code{cont.analysis()} by internally using the function \code{cdfStats()}.

There are two types of data that can be submitted to function
\code{cdfTable()}.  The first (\code{type = "xy"}) is composed by two
instances (\sQuote{x} and \sQuote{y}) and is produced during horizontal
(positional) validation exercises (validation in the geographic space).
Thus, \sQuote{x} and \sQuote{y} represent, respectively, the horizontal
displacement (error) in \sQuote{x} and \sQuote{y} coordinates.

The second type of data (\code{type = "z"}) is composed by only one instance
(\sQuote{z}) and is generated by vertical validation exercises (validation
in the attribute space). Thus, \sQuote{z} represents the vertical
displacement (error) of the attribute \sQuote{z} being measured.
}
\examples{

\dontrun{
## Estimate the CDF
my.cdf <- cont.analysis(spsurvey.obj = my.spsurvey)

## Print table and TeX code
cdfTable(my.cdf)
}

}
\author{
Alessandro Samuel-Rosa <\email{alessandrosamuelrosa@gmail.com}>
}
\references{
Kincaid, T. M. and Olsen, A. R. (2013).  spsurvey: Spatial
Survey Design and Analysis.  R package version 2.6. URL:
<\url{http://www.epa.gov/nheerl/arm/}>.
}
\seealso{
\code{\link[pedometrics]{cdfStats}},
\code{\link[spsurvey]{cont.analysis}}.
}
\keyword{methods}
\keyword{print}

