% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pedalfast_factor.R
\name{fss_as_factor}
\alias{fss_as_factor}
\title{Functional Status Scale Categories}
\usage{
fss_as_factor(x, long_label = FALSE, ...)
}
\arguments{
\item{x}{an integer vector}

\item{long_label}{logical if the score range should be prepended to the
label.}

\item{...}{not currently used.}
}
\value{
A factor of equal length to the input \code{x} with labels for the
categorical ranges of FSS.
}
\description{
Mapping FSS Total scores (integer values) to categorical values.
}
\details{
FSS scores are integer values from 6 to 30.  

The a mapping of ranges of integer values to categories is
\itemize{
  \item FSS 6, 7: Good
  \item FSS 8, 9: Mildly abnormal
  \item FSS 10, 11, 12, 13, 14, 15: Moderately abnormal
  \item FSS 16, 17, 18, 19, 20, 21: Severe abnormal
  \item FSS 22, 23, 24, 25, 26, 27, 28, 29, 30: Very severely abnormal
}
}
\examples{
x <- seq(5, 32)
data.frame(x           = x,
           short_label = fss_as_factor(x),
           long_label  = fss_as_factor(x, long_label = TRUE))

}
