% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulatePed.R
\name{simulatePed}
\alias{simulatePed}
\title{Simulate pedigree, genetic merits and phenotypes}
\usage{
simulatePed(
  F0size,
  f.rate = 1,
  m.rate = 1,
  mort.rate = 0,
  littersize = 1,
  ngen,
  overlap.s = 0,
  overlap.d = 0,
  fullsib = TRUE,
  parentprogeny = TRUE,
  Va0,
  Ve,
  fsel = "R",
  msel = "R"
)
}
\arguments{
\item{F0size}{: Even number of founder animals. No mortality and selection in this generation.}

\item{f.rate}{: Proportion of females selected as dams, default = 1.}

\item{m.rate}{: Proportion of males (\code{<= f.rate}) selected as sires, default = 1.}

\item{mort.rate}{: Mortality rate per generation, after the availability of phenotype (e.g., birth weight, weaning weight) and before the age of maturity (i.e., before mating), default = 0. Maximum \code{mort.rate} = 0.5.}

\item{littersize}{: Litter size, default = 1.}

\item{ngen}{: Number of generations to simulate.}

\item{overlap.s}{: Number of generation overlaps for sires, default = 0 for no generation overlap.}

\item{overlap.d}{: Number of generation overlaps for dams, default = 0 for no generation overlap.}

\item{fullsib}{: If \code{FALSE}, avoid fullsib matings, default = \code{TRUE}. Further information provided in \strong{Details}.}

\item{parentprogeny}{: If \code{FALSE}, avoid parent-progeny matings, default = \code{TRUE}. Further information provided in \strong{Details}.}

\item{Va0}{: Additive genetic variance in the base generation (i.e., F0).}

\item{Ve}{: Environment (plus residual) variance, set constant across generations.}

\item{fsel}{: If \code{"R"} (default), random selection on females; if \code{"P"}, selection on phenotypes, or true breeding values if \code{Ve} = 0; if \code{"PA"}, selection on true parent averages; redundant if \code{f.rate = 1}.}

\item{msel}{: If \code{"R"} (default), random selection on males; if \code{"P"}, selection on phenotypes, or true breeding values if \code{Ve} = 0; if \code{"PA"}, selection on true parent averages; redundant if \code{m.rate = 1}.}
}
\value{
ped : The output pedigree \code{data.frame}. Further information provided in \strong{Details}.
}
\description{
Simulate Pedigree, genetic merits and phenotypes with random mating followed by (non)random selection differntly for males and females.
}
\details{
\code{fullsib = FALSE} : Avoid fullsib matings in each generation by replacing the male mate (SIRE) with a random SIRE among the selected sires, until no fullsib mating is left.
If due to a small population bottleneck there is any fullsib mating remained, it would be reported.

\code{parentprogeny = FALSE} : Avoid parent-progeny matings in each generation by replacing the male mate (SIRE) with a random SIRE among the selected sires, until no parent-progeny mating is left.
If due to a small population bottleneck there is any parent-progeny mating remained, it would be reported.

The output pedigree \code{data.frame} (\code{ped}) has 9 columns: ID, SIRE, DAM, SEX, GEN (generation number starting with 0 for the base generation), PA (parent average), MS (Mendelian Sampling), E (environment and residuals), and P (phenotype).
}
\examples{
ped = simulatePed(
  F0size = 100,
  f.rate = 0.8,
  m.rate = 0.5,
  mort.rate = 0.05,
  littersize = 2,
  ngen = 4,
  overlap.s = 1,
  overlap.d = 0,
  fullsib = FALSE,
  parentprogeny = FALSE,
  Va0 = 9,
  Ve = 36,
  fsel = "P",
  msel = "PA"
)

}
