% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simDilution.r
\name{simDilution}
\alias{simDilution}
\title{Serial Dilution Simulator}
\usage{
simDilution(data = NULL, stock.conc = 10, stock.vol = 1000,
  stock.aliq = 5, amount = c(1, 0.1), steps = 3, dilution.factor = 0.5,
  dilution.aliq = 100, pcr.aliq = 17.5, cell.dna = 0.006,
  truncate.top = TRUE, debug = FALSE)
}
\arguments{
\item{data}{data.frame with simulated data.}

\item{stock.conc}{numeric for the stock concentration (ng/ul).}

\item{stock.vol}{numeric for the stock volume (ul).}

\item{stock.aliq}{numeric for the aliquot volume pipetted from the stock solution (ul).}

\item{amount}{numeric for the highest target amount in the PCR reaction (ng) or
a vector of length two giving the target range c(high, low).}

\item{steps}{numeric for the number of dilution steps.}

\item{dilution.factor}{numeric between 0 and 1 for the dilution factor (i.e. 0.5 for a two-fold dilution).}

\item{dilution.aliq}{numeric for the aliquot pipetted in each serial dilution step (excluding from stock solution).}

\item{pcr.aliq}{numeric for the aliquot forwarded to PCR (ul).}

\item{cell.dna}{numeric to indicate the DNA content of a diploid cell in nanograms (ng).}

\item{truncate.top}{logic if TRUE the high concentrations will be discarded
if there are too few simulated samples in 'data'.
If FALSE the low concentrations will be discarded.}

\item{debug}{logical flagging for debug mode.}
}
\value{
data.frame with simulation results in columns 'Dil.DNA.Pre', 'Dil.Prob',
'Dil.Vol.Ser', 'Dil.DNA.Ser', 'Dil.Vol', 'Dil.DNA', and 'Dil.Conc'.
Columns 'Volume' and 'DNA' are added or updated to be used subsequently.
}
\description{
Simulates the serial dilution process of a DNA extract.
}
\details{
Simulates the dilution process by binomial selection of molecules
from a stock of extracted DNA. Result include columns with number of
molecules prior to the binomial selection (Dil.DNA.Pre) the probability
used (Dil.Prob), the total volume of each serial dilution prior to removal
of aliquot for the subsequent dilution (Dil.Vol.Ser), the number of
molecules in each serial dilution prior to removal of aliquot for the
subsequent dilution (Dil.DNA.Ser), final volume after serial dilution is
complete (Dil.Vol), final number of molecules after serial dilution is
complete (Dil.DNA), and target concentration used in calculations (Dil.Conc).
}
\examples{
# Create a data frame with a DNA profile.
markers = rep(c("D3S1358","TH01","FGA"), each=2)
alleles = c(15,18,6,10,25,25)
res <- data.frame(Marker=markers, Allele=alleles)

# Simulate profile.
res <- simProfile(data=res, sim=3, name="Test")

# Simulate diploid sample.
res <- simSample(data=res, cells=10000, sd.cells=200)

# Simulate extraction.
res <- simExtraction(data=res, vol.ex=200, sd.vol=10, prob.ex=0.3, sd.prob=0.1)

# Simulate dilution.
res <- simDilution(data=res, amount=1, dilution.factor=0.5)
}
