% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AuxDelaunay.R
\name{rel.vert.tetraCC}
\alias{rel.vert.tetraCC}
\title{The index of the \eqn{CC}-vertex region in a tetrahedron
that contains a point}
\usage{
rel.vert.tetraCC(p, th)
}
\arguments{
\item{p}{A 3D point for which \eqn{CC}-vertex region it resides in is
to be determined in the
tetrahedron \code{th}.}

\item{th}{A \eqn{4 \times 3} matrix with each row
representing a vertex of the tetrahedron.}
}
\value{
A \code{list} with two elements
\item{rv}{Index of the \eqn{CC}-vertex region
that contains point, \code{p} in the tetrahedron \code{th}}
\item{tri}{The vertices of the tetrahedron,
where row number corresponds to the vertex index in \code{rv}.}
}
\description{
Returns the index of the vertex
whose region contains point \code{p} in
a tetrahedron \eqn{th=T(A,B,C,D)}
and vertex regions are based on the circumcenter \eqn{CC} of \code{th}.
(see the plots in the example for illustrations).

The vertices of the tetrahedron \code{th} are labeled as
\eqn{1=A}, \eqn{2=B}, \eqn{3=C}, and \eqn{4=C} also
according to the row number the vertex is recorded in \code{th}.

If the point, \code{p}, is not inside \code{th},
then the function yields \code{NA} as output.
The corresponding vertex region is the polygon
whose interior points are closest to that vertex.
If \code{th} is regular tetrahedron,
then \eqn{CC} and \eqn{CM} (center of mass) coincide.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010;textual}{pcds}).
}
\examples{
\dontrun{
set.seed(123)
A<-c(0,0,0)+runif(3,-.2,.2);
B<-c(1,0,0)+runif(3,-.2,.2);
C<-c(1/2,sqrt(3)/2,0)+runif(3,-.2,.2);
D<-c(1/2,sqrt(3)/6,sqrt(6)/3)+runif(3,-.2,.2);
tetra<-rbind(A,B,C,D)

n<-20  #try also n<-40

Xp<-runif.tetra(n,tetra)$g

rel.vert.tetraCC(Xp[1,],tetra)

Rv<-vector()
for (i in 1:n)
 Rv<-c(Rv,rel.vert.tetraCC(Xp[i,],tetra)$rv)
Rv

CC<-circumcenter.tetra(tetra)
CC

Xlim<-range(tetra[,1],Xp[,1],CC[1])
Ylim<-range(tetra[,2],Xp[,2],CC[2])
Zlim<-range(tetra[,3],Xp[,3],CC[3])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]
zd<-Zlim[2]-Zlim[1]

plot3D::scatter3D(tetra[,1],tetra[,2],tetra[,3],
phi =0,theta=40, bty = "g",
main="Scatterplot of data points \n and CC-vertex regions",
xlim=Xlim+xd*c(-.05,.05), ylim=Ylim+yd*c(-.05,.05),
zlim=Zlim+zd*c(-.05,.05),
          pch = 20, cex = 1, ticktype = "detailed")
L<-rbind(A,A,A,B,B,C); R<-rbind(B,C,D,C,D,D)
plot3D::segments3D(L[,1], L[,2], L[,3], R[,1], R[,2],R[,3],
add=TRUE,lwd=2)
#add the data points
plot3D::points3D(Xp[,1],Xp[,2],Xp[,3],pch=".",cex=3, add=TRUE)

plot3D::text3D(tetra[,1],tetra[,2],tetra[,3],
labels=c("A","B","C","D"), add=TRUE)
plot3D::text3D(CC[1],CC[2],CC[3], labels=c("CC"), add=TRUE)

D1<-(A+B)/2; D2<-(A+C)/2; D3<-(A+D)/2; D4<-(B+C)/2;
D5<-(B+D)/2; D6<-(C+D)/2;
L<-rbind(D1,D2,D3,D4,D5,D6); R<-matrix(rep(CC,6),ncol=3,byrow=TRUE)
plot3D::segments3D(L[,1], L[,2], L[,3], R[,1], R[,2],R[,3],
add=TRUE,lty = 2)

F1<-intersect.line.plane(A,CC,B,C,D)
L<-matrix(rep(F1,4),ncol=3,byrow=TRUE); R<-rbind(D4,D5,D6,CC)
plot3D::segments3D(L[,1], L[,2], L[,3], R[,1], R[,2],R[,3],col=2,
add=TRUE,lty = 2)

F2<-intersect.line.plane(B,CC,A,C,D)
L<-matrix(rep(F2,4),ncol=3,byrow=TRUE); R<-rbind(D2,D3,D6,CC)
plot3D::segments3D(L[,1], L[,2], L[,3], R[,1], R[,2],R[,3],col=3,
add=TRUE,lty = 2)

F3<-intersect.line.plane(C,CC,A,B,D)
L<-matrix(rep(F3,4),ncol=3,byrow=TRUE); R<-rbind(D3,D5,D6,CC)
plot3D::segments3D(L[,1], L[,2], L[,3], R[,1], R[,2],R[,3],col=4,
add=TRUE,lty = 2)

F4<-intersect.line.plane(D,CC,A,B,C)
L<-matrix(rep(F4,4),ncol=3,byrow=TRUE); R<-rbind(D1,D2,D4,CC)
plot3D::segments3D(L[,1], L[,2], L[,3], R[,1], R[,2],R[,3],col=5,
add=TRUE,lty = 2)

plot3D::text3D(Xp[,1],Xp[,2],Xp[,3], labels=factor(Rv), add=TRUE)
}

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rel.vert.tetraCM}} and \code{\link{rel.vert.triCC}}
}
\author{
Elvan Ceyhan
}
