% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{rvTe.cent}
\alias{rvTe.cent}
\title{The index of the vertex region in the standard equilateral triangle that contains a given point}
\usage{
rvTe.cent(pt, M)
}
\arguments{
\item{pt}{A 2D point for which \code{M}-vertex region it resides in is to be determined in the
standard equilateral triangle \eqn{T_e}.}

\item{M}{A 2D point in Cartesian coordinates or a 3D point in barycentric coordinates
which serves as a center in the interior of the standard equilateral triangle \eqn{T_e}.}
}
\value{
A \code{list} with two elements
\item{rv}{Index of the vertex whose region contains point, \code{pt}.}
\item{tri}{The vertices of the triangle, \eqn{T_e}, where row number corresponds to the vertex index in \code{rv}
with row \eqn{1=(0,0)}, row \eqn{2=(1,0)}, and row \eqn{3=(1/2,\sqrt{3}/2)}.}
}
\description{
Returns the index of the vertex whose region contains point \code{pt} in standard equilateral triangle
\eqn{T_e=T((0,0),(1,0),(1/2,\sqrt{3}/2))} with vertex regions are constructed with center \eqn{M=(m_1,m_2)}
in Cartesian coordinates or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the interior of \eqn{T_e}.
(see the plots in the example for illustrations).

The vertices of triangle, \eqn{T_e}, are labeled as \eqn{1,2,3}
according to the row number the vertex is recorded in \eqn{T_e}. If the point, \code{pt}, is not inside \eqn{T_e}, then the
function yields \code{NA} as output. The corresponding vertex region is the polygon with the vertex, \code{M}, and
projections from \code{M} to the edges on the lines joining vertices and \code{M}.

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}).
}
\examples{
A<-c(0,0); B<-c(1,0); C<-c(1/2,sqrt(3)/2);
Te<-rbind(A,B,C)
n<-10  #try also n<-20

set.seed(1)
dat<-runifTe(n)$gen.points

M<-as.numeric(runifTe(1)$g)  #try also M<-c(.6,.2)

rvTe.cent(dat[1,],M)
rvTe.cent(c(.7,.2),M)
rvTe.cent(c(0,1),M)

Rv<-vector()
for (i in 1:n)
  Rv<-c(Rv,rvTe.cent(dat[i,],M)$rv)
Rv

Ds<-cp2e.tri(Te,M)

Xlim<-range(Te[,1],dat[,1])
Ylim<-range(Te[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

if (dimension(M)==3) {M<-bary2cart(M,Te)}
#need to run this when M is given in barycentric coordinates

plot(Te,asp=1,pch=".",xlab="",ylab="",axes=TRUE,
xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Te)
points(dat,pch=".",col=1)
L<-rbind(M,M,M); R<-Ds
segments(L[,1], L[,2], R[,1], R[,2], lty=2)

txt<-rbind(Te,M)
xc<-txt[,1]+c(-.02,.03,.02,0)
yc<-txt[,2]+c(.02,.02,.03,.05)
txt.str<-c("A","B","C","M")
text(xc,yc,txt.str)

text(dat,labels=factor(Rv))

rvTe.cent(c(.7,.2),M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{rvTeCM}}, \code{\link{rv.tri.cent}}, \code{\link{rv.triCC}},
\code{\link{rv.bastriCC}}, \code{\link{rv.triCM}}, and \code{\link{rv.bastri.cent}}
}
\author{
Elvan Ceyhan
}
