% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{NumArcsASMT}
\alias{NumArcsASMT}
\title{Number of arcs of Arc Slice Proximity Catch Digraphs (AS-PCDs) - multiple triangle case}
\usage{
NumArcsASMT(Xp, Yp, M = "CC")
}
\arguments{
\item{Xp}{A set of 2D points which constitute the vertices of the AS-PCD.}

\item{Yp}{A set of 2D points which constitute the vertices of the Delaunay triangles.}

\item{M}{The center of the triangle. \code{"CC"} stands for circumcenter of each Delaunay triangle \code{tri} or 3D point in barycentric
coordinates which serves as a center in the interior of each Delaunay triangle;
default is \code{M="CC"} i.e., the circumcenter of each triangle.}
}
\value{
A \code{list} with the elements
\item{num.pts.in.CH}{Number of \code{Xp} points in the convex hull of \code{Yp} points}
\item{num.arcs}{Number of arcs in the AS-PCD for the \code{Xp} points inside the convex hull of \code{Yp} points}
\item{weight.vec}{The \code{vector} of areas of the Delaunay triangles that have at least on \code{Xp} points in them}
}
\description{
Returns the number of arcs of Arc Slice Proximity Catch Digraph (AS-PCD) whose vertices are
the data points in \code{Xp} in the multiple triangle case.

AS proximity regions are defined with respect to the
Delaunay triangles based on \code{Yp} points and vertex regions in each triangle are based on the center \code{M="CC"}
for circumcenter of each Delaunay triangle or \eqn{M=(\alpha,\beta,\gamma)} in barycentric coordinates in the
interior of each Delaunay triangle; default is \code{M="CC"} i.e., circumcenter of each triangle.

Convex hull of \code{Yp} is partitioned by the Delaunay triangles based on \code{Yp} points
(i.e., multiple triangles are the set of these Delaunay triangles whose union constitutes
the convex hull of \code{Yp} points).

See (\insertCite{ceyhan:Phd-thesis,ceyhan:comp-geo-2010,ceyhan:mcap2012;textual}{pcds}) for more on AS-PCDs.
Also see (\insertCite{okabe:2000,ceyhan:comp-geo-2010,sinclair:2016;textual}{pcds}) for more on Delaunay triangulation
and the corresponding algorithm.
}
\examples{
nx<-20; ny<-4;  #try also nx<-40; ny<-10 or nx<-1000; ny<-10;

set.seed(1)
Xp<-cbind(runif(nx),runif(nx))
Yp<-cbind(runif(ny),runif(ny))

oldpar <- par(no.readonly = TRUE)
plotDeltri(Xp,Yp,xlab="",ylab="")
par(oldpar)

M<-"CC"  #try also M<-c(1,1,1)

NumArcsASMT(Xp,Yp,M)
NumArcsASMT(Xp,Yp[1:3,],M)

NumArcsASMT(c(.4,.2),Yp,M)

NumArcsASMT(Xp,rbind(Yp,Yp),M)

dat.fr<-data.frame(a=Xp)
NumArcsASMT(dat.fr,Yp,M)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{NumArcsAStri}}, \code{\link{NumArcsPEMT}}, and \code{\link{NumArcsCSMT}}
}
\author{
Elvan Ceyhan
}
