% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PCDFunctions.r
\name{cl2edgesTe}
\alias{cl2edgesTe}
\title{The closest points in a data set to edges in the standard equilateral triangle}
\usage{
cl2edgesTe(Dt, ch.all.intri = FALSE)
}
\arguments{
\item{Dt}{A set of 2D points representing the set of data points.}

\item{ch.all.intri}{A logical argument (default=\code{FALSE}) to check whether all data points are inside
the standard equilateral triangle \eqn{T_e}. So, if it is \code{TRUE},
the function checks if all data points are inside the closure of the triangle (i.e., interior and boundary
combined) else it does not.}
}
\value{
A \code{list} with the elements
\item{txt1}{Edge labels as \eqn{AB=3}, \eqn{BC=1}, and \eqn{AC=2} for \eqn{T_e} (corresponds to row number in Extremum Points).}
\item{txt2}{A short description of the distances as \code{"Distances to Edges ..."}.}
\item{type}{Type of the extrema points}
\item{desc}{A short description of the extrema points}
\item{mtitle}{The \code{"main"} title for the plot of the extrema}
\item{ext}{The extrema points, i.e., closest points to edges}
\item{X}{The input data, \code{Dt}, which can be a \code{matrix} or \code{data frame}}
\item{num.points}{The number of data points, i.e., size of \code{Dt}}
\item{supp}{Support of the data points, i.e., the standard equilateral triangle \eqn{T_e}}
\item{cent}{The center point used for construction of edge regions, not required for this extrema,
hence it is \code{NULL} for this function}
\item{ncent}{Name of the center, \code{cent}, not required for this extrema, hence it is \code{NULL} for this function}
\item{regions}{Edge regions inside the triangle, \eqn{T_e}, not required for this extrema, hence it is \code{NULL}
for this function}
\item{region.names}{Names of the edge regions, not required for this extrema, hence it is \code{NULL}
for this function}
\item{region.centers}{Centers of mass of the edge regions inside \eqn{T_e}, not required for this extrema,
hence it is \code{NULL} for this function}
\item{dist2ref}{Distances from closest points in each edge region to the corresponding edge}
}
\description{
An object of class \code{"Extrema"}.
Returns the closest points from the 2D data set, \code{Dt}, to the edges in the
standard equilateral triangle \eqn{T_e=T(A=(0,0),B=(1,0),C=(1/2,\sqrt{3}/2))}.

\code{ch.all.intri} is for checking whether all data points are inside \eqn{T_e} (default is \code{FALSE}).

If some of the data points are not inside \eqn{T_e} and \code{ch.all.intri=TRUE}, then the function yields
an error message.
If some of the data points are not inside \eqn{T_e} and \code{ch.all.intri=FALSE}, then the function yields
the closest points to edges among the data points inside \eqn{T_e} (yields \code{NA} if there are no data points
inside \eqn{T_e}).

See also (\insertCite{ceyhan:Phd-thesis,ceyhan:arc-density-PE,ceyhan:masa-2007;textual}{pcds}).
}
\examples{
n<-10  #try also n<-20
dat<-runifTe(n)$gen.points

Ext<-cl2edgesTe(dat)
Ext
summary(Ext)
plot(Ext,asp=1)

cl2edgesTe(dat[1,])
cl2edgesTe(c(10,10))

ed.clo<-cl2edgesTe(dat)

dat2<-rbind(dat,c(.8,.8))
cl2edgesTe(dat2)

A<-c(0,0); B<-c(1,0); C<-c(0.5,sqrt(3)/2);
Te<-rbind(A,B,C)
CM<-(A+B+C)/3
p1<-(A+B)/2
p2<-(B+C)/2
p3<-(A+C)/2

Xlim<-range(Te[,1],dat[,1])
Ylim<-range(Te[,2],dat[,2])
xd<-Xlim[2]-Xlim[1]
yd<-Ylim[2]-Ylim[1]

plot(A,pch=".",xlab="",ylab="",axes=TRUE,xlim=Xlim+xd*c(-.05,.05),ylim=Ylim+yd*c(-.05,.05))
polygon(Te)
points(dat,xlab="",ylab="")
points(ed.clo$ext,pty=2,pch=4,col="red")

txt<-rbind(Te,p1,p2,p3)
xc<-txt[,1]+c(-.03,.03,.03,0,0,0)
yc<-txt[,2]+c(.02,.02,.02,0,0,0)
txt.str<-c("A","B","C","re=1","re=2","re=3")
text(xc,yc,txt.str)

dat.fr<-data.frame(a=dat)
cl2edgesTe(dat.fr)

}
\references{
\insertAllCited{}
}
\seealso{
\code{\link{cl2eTbVRcent}}, \code{\link{cl2eVRcent}}, \code{\link{cl2eVRCM}} and \code{\link{fr2eTeER}}
}
\author{
Elvan Ceyhan
}
