\name{simMPRM}
\alias{simMPRM}

\title{
simulate data according to MPRM
}

\description{
With this function data sets according to the multidimensional polytomous Rasch model (MPRM) are simulated
}

\usage{
simMPRM(itempar, persons = 500, seed = NULL)
}

\arguments{
  \item{itempar}{
a matrix with item category parameters; each row represents a category and each column an item (see details)
}
  \item{persons}{
an integer representing the number of persons (observations) of the data set (see details)
}
  \item{seed}{
a seed for the random number generated can optionally be set
}
}
\details{
Data are generated with category values starting with 0. Thus the first row of the matrix containing the item parameters is matched to the category value 0 and so on. The last category is the reference category. Please note, that the item category parameters of the last category have to be 0 (due to parameter normalization)! 

Person parameters are generated by a standard normal distribution.
}
\value{
\item{datmat}{simulated data set}
\item{true_itempar}{the fixed item parameters according to the input}
\item{true_perspar}{the fixed person parameters}
}

\references{
Fischer, G. H. (1974). Einfuehrung in die Theorie psychologischer Tests [Introduction to test
theory]. Bern: Huber.


Rasch, G. (1961). On general laws and the meaning of measurement in psychology, Proceedings Fourth Berekely Symposium on Mathematical Statistiscs and Probability 5, 321-333.
}

\author{
Christine Hohensinn
}


\seealso{
\code{\link{simCRSM}}
}
\examples{
#set item parameters
item_p <- rbind(matrix(c(-1.5,0.5,0.5,1,0.8,-0.3, 0.2,-1.2), ncol=4),0)

#number of persons
pn <- 500

#simulate data set
simdatM <- simMPRM(item_p, pn)
}
\keyword{multidimensional polytomous Rasch model}
\keyword{simulation}
