% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit.R
\name{responseCurve}
\alias{responseCurve}
\title{Produce data suitable for plotting item response curves}
\usage{
responseCurve(
  dl,
  fit,
  responseNames,
  item = dl$nameInfo$item,
  samples = 100,
  from = qnorm(0.1),
  to = -from,
  by = 0.02
)
}
\arguments{
\item{dl}{a data list prepared by \code{\link{prepData}}}

\item{fit}{a \code{\link[rstan:stanfit-class]{stanfit}} object}

\item{responseNames}{a vector of labels for the possible responses}

\item{item}{a vector of item names}

\item{samples}{number of posterior samples}

\item{from}{the starting latent difference value}

\item{to}{the ending latent difference value}

\item{by}{the grid increment}
}
\value{
A data.frame with the following columns:
\describe{
\item{response}{Which response}
\item{worthDiff}{Difference in worth}
\item{item}{Which item}
\item{sample}{Which sample}
\item{prob}{Associated probability}
\item{responseSample}{A grouping index for independent item response samples}
}
}
\description{
Selects \code{samples} random draws from the posterior and evaluates the item
response curve on the grid given by \code{seq(from,to,by)}.
All items use the same \code{responseNames}. If you have some items
with a different number of thresholds or different response names
then you can call \code{responseCurve} for each item separately
and \code{rbind} the results together.
}
\section{Response model}{


See \link{cmp_probs} for details.
}

\examples{
\donttest{ vignette('manual', 'pcFactorStan') }
}
\seealso{
Other data extractor: 
\code{\link{parDistributionCustom}()},
\code{\link{parInterval}()}
}
\concept{data extractor}
