% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspacedata_operations.R
\name{finspacedata_create_data_view}
\alias{finspacedata_create_data_view}
\title{Creates a Dataview for a Dataset}
\usage{
finspacedata_create_data_view(
  clientToken = NULL,
  datasetId,
  autoUpdate = NULL,
  sortColumns = NULL,
  partitionColumns = NULL,
  asOfTimestamp = NULL,
  destinationTypeParams
)
}
\arguments{
\item{clientToken}{A token that ensures idempotency. This token expires in 10 minutes.}

\item{datasetId}{[required] The unique Dataset identifier that is used to create a Dataview.}

\item{autoUpdate}{Flag to indicate Dataview should be updated automatically.}

\item{sortColumns}{Columns to be used for sorting the data.}

\item{partitionColumns}{Ordered set of column names used to partition data.}

\item{asOfTimestamp}{Beginning time to use for the Dataview. The value is determined as epoch
time in milliseconds. For example, the value for Monday, November 1,
2021 12:00:00 PM UTC is specified as 1635768000000.}

\item{destinationTypeParams}{[required] Options that define the destination type for the Dataview.}
}
\description{
Creates a Dataview for a Dataset.

See \url{https://www.paws-r-sdk.com/docs/finspacedata_create_data_view/} for full documentation.
}
\keyword{internal}
