# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include ebs_service.R
NULL

#' Seals and completes the snapshot after all of the required blocks of
#' data have been written to it
#'
#' @description
#' Seals and completes the snapshot after all of the required blocks of data have been written to it. Completing the snapshot changes the status to `completed`. You cannot write new blocks to a snapshot after it has been completed.
#'
#' See [https://www.paws-r-sdk.com/docs/ebs_complete_snapshot/](https://www.paws-r-sdk.com/docs/ebs_complete_snapshot/) for full documentation.
#'
#' @param SnapshotId &#91;required&#93; The ID of the snapshot.
#' @param ChangedBlocksCount &#91;required&#93; The number of blocks that were written to the snapshot.
#' @param Checksum An aggregated Base-64 SHA256 checksum based on the checksums of each
#' written block.
#' 
#' To generate the aggregated checksum using the linear aggregation method,
#' arrange the checksums for each written block in ascending order of their
#' block index, concatenate them to form a single string, and then generate
#' the checksum on the entire string using the SHA256 algorithm.
#' @param ChecksumAlgorithm The algorithm used to generate the checksum. Currently, the only
#' supported algorithm is `SHA256`.
#' @param ChecksumAggregationMethod The aggregation method used to generate the checksum. Currently, the
#' only supported aggregation method is `LINEAR`.
#'
#' @keywords internal
#'
#' @rdname ebs_complete_snapshot
ebs_complete_snapshot <- function(SnapshotId, ChangedBlocksCount, Checksum = NULL, ChecksumAlgorithm = NULL, ChecksumAggregationMethod = NULL) {
  op <- new_operation(
    name = "CompleteSnapshot",
    http_method = "POST",
    http_path = "/snapshots/completion/{snapshotId}",
    host_prefix = "",
    paginator = list()
  )
  input <- .ebs$complete_snapshot_input(SnapshotId = SnapshotId, ChangedBlocksCount = ChangedBlocksCount, Checksum = Checksum, ChecksumAlgorithm = ChecksumAlgorithm, ChecksumAggregationMethod = ChecksumAggregationMethod)
  output <- .ebs$complete_snapshot_output()
  config <- get_config()
  svc <- .ebs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ebs$operations$complete_snapshot <- ebs_complete_snapshot

#' Returns the data in a block in an Amazon Elastic Block Store snapshot
#'
#' @description
#' Returns the data in a block in an Amazon Elastic Block Store snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/ebs_get_snapshot_block/](https://www.paws-r-sdk.com/docs/ebs_get_snapshot_block/) for full documentation.
#'
#' @param SnapshotId &#91;required&#93; The ID of the snapshot containing the block from which to get data.
#' 
#' If the specified snapshot is encrypted, you must have permission to use
#' the KMS key that was used to encrypt the snapshot. For more information,
#' see [Using
#' encryption](https://docs.aws.amazon.com/ebs/latest/userguide/ebsapis-using-encryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param BlockIndex &#91;required&#93; The block index of the block in which to read the data. A block index is
#' a logical index in units of `512` KiB blocks. To identify the block
#' index, divide the logical offset of the data in the logical volume by
#' the block size (logical offset of data/`524288`). The logical offset of
#' the data must be `512` KiB aligned.
#' @param BlockToken &#91;required&#93; The block token of the block from which to get data. You can obtain the
#' `BlockToken` by running the
#' [`list_changed_blocks`][ebs_list_changed_blocks] or
#' [`list_snapshot_blocks`][ebs_list_snapshot_blocks] operations.
#'
#' @keywords internal
#'
#' @rdname ebs_get_snapshot_block
ebs_get_snapshot_block <- function(SnapshotId, BlockIndex, BlockToken) {
  op <- new_operation(
    name = "GetSnapshotBlock",
    http_method = "GET",
    http_path = "/snapshots/{snapshotId}/blocks/{blockIndex}",
    host_prefix = "",
    paginator = list()
  )
  input <- .ebs$get_snapshot_block_input(SnapshotId = SnapshotId, BlockIndex = BlockIndex, BlockToken = BlockToken)
  output <- .ebs$get_snapshot_block_output()
  config <- get_config()
  svc <- .ebs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ebs$operations$get_snapshot_block <- ebs_get_snapshot_block

#' Returns information about the blocks that are different between two
#' Amazon Elastic Block Store snapshots of the same volume/snapshot lineage
#'
#' @description
#' Returns information about the blocks that are different between two Amazon Elastic Block Store snapshots of the same volume/snapshot lineage.
#'
#' See [https://www.paws-r-sdk.com/docs/ebs_list_changed_blocks/](https://www.paws-r-sdk.com/docs/ebs_list_changed_blocks/) for full documentation.
#'
#' @param FirstSnapshotId The ID of the first snapshot to use for the comparison.
#' 
#' The `FirstSnapshotID` parameter must be specified with a
#' `SecondSnapshotId` parameter; otherwise, an error occurs.
#' @param SecondSnapshotId &#91;required&#93; The ID of the second snapshot to use for the comparison.
#' 
#' The `SecondSnapshotId` parameter must be specified with a
#' `FirstSnapshotID` parameter; otherwise, an error occurs.
#' @param NextToken The token to request the next page of results.
#' 
#' If you specify **NextToken**, then **StartingBlockIndex** is ignored.
#' @param MaxResults The maximum number of blocks to be returned by the request.
#' 
#' Even if additional blocks can be retrieved from the snapshot, the
#' request can return less blocks than **MaxResults** or an empty array of
#' blocks.
#' 
#' To retrieve the next set of blocks from the snapshot, make another
#' request with the returned **NextToken** value. The value of
#' **NextToken** is `null` when there are no more blocks to return.
#' @param StartingBlockIndex The block index from which the comparison should start.
#' 
#' The list in the response will start from this block index or the next
#' valid block index in the snapshots.
#' 
#' If you specify **NextToken**, then **StartingBlockIndex** is ignored.
#'
#' @keywords internal
#'
#' @rdname ebs_list_changed_blocks
ebs_list_changed_blocks <- function(FirstSnapshotId = NULL, SecondSnapshotId, NextToken = NULL, MaxResults = NULL, StartingBlockIndex = NULL) {
  op <- new_operation(
    name = "ListChangedBlocks",
    http_method = "GET",
    http_path = "/snapshots/{secondSnapshotId}/changedblocks",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .ebs$list_changed_blocks_input(FirstSnapshotId = FirstSnapshotId, SecondSnapshotId = SecondSnapshotId, NextToken = NextToken, MaxResults = MaxResults, StartingBlockIndex = StartingBlockIndex)
  output <- .ebs$list_changed_blocks_output()
  config <- get_config()
  svc <- .ebs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ebs$operations$list_changed_blocks <- ebs_list_changed_blocks

#' Returns information about the blocks in an Amazon Elastic Block Store
#' snapshot
#'
#' @description
#' Returns information about the blocks in an Amazon Elastic Block Store snapshot.
#'
#' See [https://www.paws-r-sdk.com/docs/ebs_list_snapshot_blocks/](https://www.paws-r-sdk.com/docs/ebs_list_snapshot_blocks/) for full documentation.
#'
#' @param SnapshotId &#91;required&#93; The ID of the snapshot from which to get block indexes and block tokens.
#' @param NextToken The token to request the next page of results.
#' 
#' If you specify **NextToken**, then **StartingBlockIndex** is ignored.
#' @param MaxResults The maximum number of blocks to be returned by the request.
#' 
#' Even if additional blocks can be retrieved from the snapshot, the
#' request can return less blocks than **MaxResults** or an empty array of
#' blocks.
#' 
#' To retrieve the next set of blocks from the snapshot, make another
#' request with the returned **NextToken** value. The value of
#' **NextToken** is `null` when there are no more blocks to return.
#' @param StartingBlockIndex The block index from which the list should start. The list in the
#' response will start from this block index or the next valid block index
#' in the snapshot.
#' 
#' If you specify **NextToken**, then **StartingBlockIndex** is ignored.
#'
#' @keywords internal
#'
#' @rdname ebs_list_snapshot_blocks
ebs_list_snapshot_blocks <- function(SnapshotId, NextToken = NULL, MaxResults = NULL, StartingBlockIndex = NULL) {
  op <- new_operation(
    name = "ListSnapshotBlocks",
    http_method = "GET",
    http_path = "/snapshots/{snapshotId}/blocks",
    host_prefix = "",
    paginator = list(input_token = "NextToken", output_token = "NextToken", limit_key = "MaxResults")
  )
  input <- .ebs$list_snapshot_blocks_input(SnapshotId = SnapshotId, NextToken = NextToken, MaxResults = MaxResults, StartingBlockIndex = StartingBlockIndex)
  output <- .ebs$list_snapshot_blocks_output()
  config <- get_config()
  svc <- .ebs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ebs$operations$list_snapshot_blocks <- ebs_list_snapshot_blocks

#' Writes a block of data to a snapshot
#'
#' @description
#' Writes a block of data to a snapshot. If the specified block contains data, the existing data is overwritten. The target snapshot must be in the `pending` state.
#'
#' See [https://www.paws-r-sdk.com/docs/ebs_put_snapshot_block/](https://www.paws-r-sdk.com/docs/ebs_put_snapshot_block/) for full documentation.
#'
#' @param SnapshotId &#91;required&#93; The ID of the snapshot.
#' 
#' If the specified snapshot is encrypted, you must have permission to use
#' the KMS key that was used to encrypt the snapshot. For more information,
#' see [Using
#' encryption](https://docs.aws.amazon.com/ebs/latest/userguide/ebsapis-using-encryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*..
#' @param BlockIndex &#91;required&#93; The block index of the block in which to write the data. A block index
#' is a logical index in units of `512` KiB blocks. To identify the block
#' index, divide the logical offset of the data in the logical volume by
#' the block size (logical offset of data/`524288`). The logical offset of
#' the data must be `512` KiB aligned.
#' @param BlockData &#91;required&#93; The data to write to the block.
#' 
#' The block data is not signed as part of the Signature Version 4 signing
#' process. As a result, you must generate and provide a Base64-encoded
#' SHA256 checksum for the block data using the **x-amz-Checksum** header.
#' Also, you must specify the checksum algorithm using the
#' **x-amz-Checksum-Algorithm** header. The checksum that you provide is
#' part of the Signature Version 4 signing process. It is validated against
#' a checksum generated by Amazon EBS to ensure the validity and
#' authenticity of the data. If the checksums do not correspond, the
#' request fails. For more information, see [Using checksums with the EBS
#' direct
#' APIs](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-accessing-snapshot.html#ebsapis-using-checksums)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param DataLength &#91;required&#93; The size of the data to write to the block, in bytes. Currently, the
#' only supported size is `524288` bytes.
#' 
#' Valid values: `524288`
#' @param Progress The progress of the write process, as a percentage.
#' @param Checksum &#91;required&#93; A Base64-encoded SHA256 checksum of the data. Only SHA256 checksums are
#' supported.
#' @param ChecksumAlgorithm &#91;required&#93; The algorithm used to generate the checksum. Currently, the only
#' supported algorithm is `SHA256`.
#'
#' @keywords internal
#'
#' @rdname ebs_put_snapshot_block
ebs_put_snapshot_block <- function(SnapshotId, BlockIndex, BlockData, DataLength, Progress = NULL, Checksum, ChecksumAlgorithm) {
  op <- new_operation(
    name = "PutSnapshotBlock",
    http_method = "PUT",
    http_path = "/snapshots/{snapshotId}/blocks/{blockIndex}",
    host_prefix = "",
    paginator = list()
  )
  input <- .ebs$put_snapshot_block_input(SnapshotId = SnapshotId, BlockIndex = BlockIndex, BlockData = BlockData, DataLength = DataLength, Progress = Progress, Checksum = Checksum, ChecksumAlgorithm = ChecksumAlgorithm)
  output <- .ebs$put_snapshot_block_output()
  config <- get_config()
  svc <- .ebs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ebs$operations$put_snapshot_block <- ebs_put_snapshot_block

#' Creates a new Amazon EBS snapshot
#'
#' @description
#' Creates a new Amazon EBS snapshot. The new snapshot enters the `pending` state after the request completes.
#'
#' See [https://www.paws-r-sdk.com/docs/ebs_start_snapshot/](https://www.paws-r-sdk.com/docs/ebs_start_snapshot/) for full documentation.
#'
#' @param VolumeSize &#91;required&#93; The size of the volume, in GiB. The maximum size is `65536` GiB (64
#' TiB).
#' @param ParentSnapshotId The ID of the parent snapshot. If there is no parent snapshot, or if you
#' are creating the first snapshot for an on-premises volume, omit this
#' parameter.
#' 
#' You can't specify **ParentSnapshotId** and **Encrypted** in the same
#' request. If you specify both parameters, the request fails with
#' `ValidationException`.
#' 
#' The encryption status of the snapshot depends on the values that you
#' specify for **Encrypted**, **KmsKeyArn**, and **ParentSnapshotId**, and
#' whether your Amazon Web Services account is enabled for [encryption by
#' default](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html#encryption-by-default).
#' For more information, see [Using
#' encryption](https://docs.aws.amazon.com/ebs/latest/userguide/ebsapis-using-encryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' If you specify an encrypted parent snapshot, you must have permission to
#' use the KMS key that was used to encrypt the parent snapshot. For more
#' information, see [Permissions to use Key Management Service
#' keys](https://docs.aws.amazon.com/ebs/latest/userguide/ebsapi-permissions.html#ebsapi-kms-permissions)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param Tags The tags to apply to the snapshot.
#' @param Description A description for the snapshot.
#' @param ClientToken A unique, case-sensitive identifier that you provide to ensure the
#' idempotency of the request. Idempotency ensures that an API request
#' completes only once. With an idempotent request, if the original request
#' completes successfully. The subsequent retries with the same client
#' token return the result from the original successful request and they
#' have no additional effect.
#' 
#' If you do not specify a client token, one is automatically generated by
#' the Amazon Web Services SDK.
#' 
#' For more information, see [Idempotency for StartSnapshot
#' API](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-direct-api-idempotency.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param Encrypted Indicates whether to encrypt the snapshot.
#' 
#' You can't specify **Encrypted** and **ParentSnapshotId** in the same
#' request. If you specify both parameters, the request fails with
#' `ValidationException`.
#' 
#' The encryption status of the snapshot depends on the values that you
#' specify for **Encrypted**, **KmsKeyArn**, and **ParentSnapshotId**, and
#' whether your Amazon Web Services account is enabled for [encryption by
#' default](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html#encryption-by-default).
#' For more information, see [Using
#' encryption](https://docs.aws.amazon.com/ebs/latest/userguide/ebsapis-using-encryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' To create an encrypted snapshot, you must have permission to use the KMS
#' key. For more information, see [Permissions to use Key Management
#' Service
#' keys](https://docs.aws.amazon.com/ebs/latest/userguide/ebsapi-permissions.html#ebsapi-kms-permissions)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param KmsKeyArn The Amazon Resource Name (ARN) of the Key Management Service (KMS) key
#' to be used to encrypt the snapshot.
#' 
#' The encryption status of the snapshot depends on the values that you
#' specify for **Encrypted**, **KmsKeyArn**, and **ParentSnapshotId**, and
#' whether your Amazon Web Services account is enabled for [encryption by
#' default](https://docs.aws.amazon.com/ebs/latest/userguide/ebs-encryption.html#encryption-by-default).
#' For more information, see [Using
#' encryption](https://docs.aws.amazon.com/ebs/latest/userguide/ebsapis-using-encryption.html)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' 
#' To create an encrypted snapshot, you must have permission to use the KMS
#' key. For more information, see [Permissions to use Key Management
#' Service
#' keys](https://docs.aws.amazon.com/ebs/latest/userguide/ebsapi-permissions.html#ebsapi-kms-permissions)
#' in the *Amazon Elastic Compute Cloud User Guide*.
#' @param Timeout The amount of time (in minutes) after which the snapshot is
#' automatically cancelled if:
#' 
#' -   No blocks are written to the snapshot.
#' 
#' -   The snapshot is not completed after writing the last block of data.
#' 
#' If no value is specified, the timeout defaults to `60` minutes.
#'
#' @keywords internal
#'
#' @rdname ebs_start_snapshot
ebs_start_snapshot <- function(VolumeSize, ParentSnapshotId = NULL, Tags = NULL, Description = NULL, ClientToken = NULL, Encrypted = NULL, KmsKeyArn = NULL, Timeout = NULL) {
  op <- new_operation(
    name = "StartSnapshot",
    http_method = "POST",
    http_path = "/snapshots",
    host_prefix = "",
    paginator = list()
  )
  input <- .ebs$start_snapshot_input(VolumeSize = VolumeSize, ParentSnapshotId = ParentSnapshotId, Tags = Tags, Description = Description, ClientToken = ClientToken, Encrypted = Encrypted, KmsKeyArn = KmsKeyArn, Timeout = Timeout)
  output <- .ebs$start_snapshot_output()
  config <- get_config()
  svc <- .ebs$service(config, op)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.ebs$operations$start_snapshot <- ebs_start_snapshot
