% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_head_object}
\alias{s3_head_object}
\title{The HEAD action retrieves metadata from an object without returning the
object itself}
\usage{
s3_head_object(
  Bucket,
  IfMatch = NULL,
  IfModifiedSince = NULL,
  IfNoneMatch = NULL,
  IfUnmodifiedSince = NULL,
  Key,
  Range = NULL,
  VersionId = NULL,
  SSECustomerAlgorithm = NULL,
  SSECustomerKey = NULL,
  SSECustomerKeyMD5 = NULL,
  RequestPayer = NULL,
  PartNumber = NULL,
  ExpectedBucketOwner = NULL,
  ChecksumMode = NULL
)
}
\arguments{
\item{Bucket}{[required] The name of the bucket containing the object.

When using this action with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this action with an access point through the Amazon Web
Services SDKs, you provide the access point ARN in place of the bucket
name. For more information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using access points}
in the \emph{Amazon S3 User Guide}.

When using this action with Amazon S3 on Outposts, you must direct
requests to the S3 on Outposts hostname. The S3 on Outposts hostname
takes the form
\code{ AccessPointName-AccountId.outpostID.s3-outposts.Region.amazonaws.com}.
When using this action with S3 on Outposts through the Amazon Web
Services SDKs, you provide the Outposts bucket ARN in place of the
bucket name. For more information about S3 on Outposts ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html}{Using Amazon S3 on Outposts}
in the \emph{Amazon S3 User Guide}.}

\item{IfMatch}{Return the object only if its entity tag (ETag) is the same as the one
specified; otherwise, return a 412 (precondition failed) error.}

\item{IfModifiedSince}{Return the object only if it has been modified since the specified time;
otherwise, return a 304 (not modified) error.}

\item{IfNoneMatch}{Return the object only if its entity tag (ETag) is different from the
one specified; otherwise, return a 304 (not modified) error.}

\item{IfUnmodifiedSince}{Return the object only if it has not been modified since the specified
time; otherwise, return a 412 (precondition failed) error.}

\item{Key}{[required] The object key.}

\item{Range}{Because \code{\link[=s3_head_object]{head_object}} returns only the metadata for an
object, this parameter has no effect.}

\item{VersionId}{VersionId used to reference a specific version of the object.}

\item{SSECustomerAlgorithm}{Specifies the algorithm to use to when encrypting the object (for
example, AES256).}

\item{SSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use in
encrypting data. This value is used to store the object and then it is
discarded; Amazon S3 does not store the encryption key. The key must be
appropriate for use with the algorithm specified in the
\code{x-amz-server-side-encryption-customer-algorithm} header.}

\item{SSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
that the encryption key was transmitted without error.}

\item{RequestPayer}{}

\item{PartNumber}{Part number of the object being read. This is a positive integer between
1 and 10,000. Effectively performs a 'ranged' HEAD request for the part
specified. Useful querying about the size of the part and the number of
parts in this object.}

\item{ExpectedBucketOwner}{The account ID of the expected bucket owner. If the bucket is owned by a
different account, the request fails with the HTTP status code
\verb{403 Forbidden} (access denied).}

\item{ChecksumMode}{To retrieve the checksum, this parameter must be enabled.

In addition, if you enable \code{ChecksumMode} and the object is encrypted
with Amazon Web Services Key Management Service (Amazon Web Services
KMS), you must have permission to use the \code{kms:Decrypt} action for the
request to succeed.}
}
\description{
The HEAD action retrieves metadata from an object without returning the object itself. This action is useful if you're only interested in an object's metadata. To use HEAD, you must have READ access to the object.

See \url{https://paws-r.github.io/docs/s3/head_object.html} for full documentation.
}
\keyword{internal}
