% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_custom.R
\name{s3_download_file}
\alias{s3_download_file}
\title{Download a file from S3 and store it at a specified file location}
\usage{
s3_download_file(Bucket, Key, Filename, IfMatch, IfModifiedSince,
IfNoneMatch, IfUnmodifiedSince, Range, ResponseCacheControl,
ResponseContentDisposition, ResponseContentEncoding, ResponseContentLanguage,
ResponseContentType, ResponseExpires, VersionId, SSECustomerAlgorithm,
SSECustomerKey, SSECustomerKeyMD5, RequestPayer, PartNumber,
ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The bucket name containing the object.

When using this API with an access point, you must direct requests to
the access point hostname. The access point hostname takes the form
\emph{AccessPointName}-\emph{AccountId}.s3-accesspoint.\emph{Region}.amazonaws.com.
When using this operation with an access point through the AWS SDKs, you
provide the access point ARN in place of the bucket name. For more
information about access point ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/using-access-points.html}{Using Access Points}
in the \emph{Amazon Simple Storage Service Developer Guide}.

When using this API with Amazon S3 on Outposts, you must direct requests
to the S3 on Outposts hostname. The S3 on Outposts hostname takes the
form
\emph{AccessPointName}-\emph{AccountId}.\emph{outpostID}.s3-outposts.\emph{Region}.amazonaws.com.
When using this operation using S3 on Outposts through the AWS SDKs, you
provide the Outposts bucket ARN in place of the bucket name. For more
information about S3 on Outposts ARNs, see \href{https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html}{Using S3 on Outposts}
in the \emph{Amazon Simple Storage Service Developer Guide}.}

\item{Key}{[required] Key of the object to get.}

\item{Filename}{[required] A local file location where the downloaded
object will be saved.}

\item{IfMatch}{Return the object only if its entity tag (ETag) is the same as the one
specified, otherwise return a 412 (precondition failed).}

\item{IfModifiedSince}{Return the object only if it has been modified since the specified time,
otherwise return a 304 (not modified).}

\item{IfNoneMatch}{Return the object only if its entity tag (ETag) is different from the
one specified, otherwise return a 304 (not modified).}

\item{IfUnmodifiedSince}{Return the object only if it has not been modified since the specified
time, otherwise return a 412 (precondition failed).}

\item{Range}{Downloads the specified range bytes of an object. For more information
about the HTTP Range header, see
\url{https://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html#sec14.35}.

Amazon S3 doesn't support retrieving multiple ranges of data per \code{GET}
request.}

\item{ResponseCacheControl}{Sets the \code{Cache-Control} header of the response.}

\item{ResponseContentDisposition}{Sets the \code{Content-Disposition} header of the response}

\item{ResponseContentEncoding}{Sets the \code{Content-Encoding} header of the response.}

\item{ResponseContentLanguage}{Sets the \code{Content-Language} header of the response.}

\item{ResponseContentType}{Sets the \code{Content-Type} header of the response.}

\item{ResponseExpires}{Sets the \code{Expires} header of the response.}

\item{VersionId}{VersionId used to reference a specific version of the object.}

\item{SSECustomerAlgorithm}{Specifies the algorithm to use to when encrypting the object (for
example, AES256).}

\item{SSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use in
encrypting data. This value is used to store the object and then it is
discarded; Amazon S3 does not store the encryption key. The key must be
appropriate for use with the algorithm specified in the
\code{x-amz-server-side-encryption-customer-algorithm} header.}

\item{SSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
that the encryption key was transmitted without error.}

\item{RequestPayer}{Confirms that the requester knows that they will be
charged for the request. Bucket owners need not specify this parameter in their requests}

\item{PartNumber}{Part number of the object being read. This is a positive integer between
1 and 10,000. Effectively performs a 'ranged' GET request for the part
specified. Useful for downloading just a part of an object.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\description{
Download a file from S3 and store it at a specified file location.
}
\details{
This is a wrapper function for \code{\link[=s3_get_object]{get_object}} that will
write the downloaded object to the file location specified.
}
\section{Request syntax}{


\if{html}{\out{<div class="sourceCode">}}\preformatted{svc$download_file(
  Bucket = "string",
  Key = "string",
  Filename = "string"
)
}\if{html}{\out{</div>}}
}

\examples{
\dontrun{
# The following example retrieves an object from an S3 bucket. The request
# specifies the range header to retrieve a specific byte range. The text file
# is saved in a local output folder.
svc$download_file(
  Bucket = "examplebucket",
  Key = "SampleFile.txt",
  Range = "bytes=0-9",
  Filename = "./output/SampleFile.txt"
)

# The following example retrieves an object from an S3 bucket. The object is
# stored in the current directory as "HappyFace.jpg".
svc$download_file(
  Bucket = "examplebucket",
  Key = "HappyFace.jpg",
  Filename = "HappyFace.jpg"
)
}

}
\keyword{internal}
