% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/finspacedata_operations.R
\name{finspacedata_update_changeset}
\alias{finspacedata_update_changeset}
\title{Updates a FinSpace Changeset}
\usage{
finspacedata_update_changeset(
  clientToken = NULL,
  datasetId,
  changesetId,
  sourceParams,
  formatParams
)
}
\arguments{
\item{clientToken}{A token that ensures idempotency. This token expires in 10 minutes.}

\item{datasetId}{[required] The unique identifier for the FinSpace Dataset in which the Changeset is
created.}

\item{changesetId}{[required] The unique identifier for the Changeset to update.}

\item{sourceParams}{[required] Options that define the location of the data being ingested
(\code{s3SourcePath}) and the source of the changeset (\code{sourceType}).

Both \code{s3SourcePath} and \code{sourceType} are required attributes.

Here is an example of how you could specify the \code{sourceParams}:

\verb{"sourceParams": \{ "s3SourcePath": "s3://finspace-landing-us-east-2-bk7gcfvitndqa6ebnvys4d/scratch/wr5hh8pwkpqqkxa4sxrmcw/ingestion/equity.csv", "sourceType": "S3" \}}

The S3 path that you specify must allow the FinSpace role access. To do
that, you first need to configure the IAM policy on S3 bucket. For more
information, see \href{https://docs.aws.amazon.com/finspace/latest/data-api/fs-using-the-finspace-api.html#access-s3-buckets}{Loading data from an Amazon S3 Bucket using the FinSpace API}section.}

\item{formatParams}{[required] Options that define the structure of the source file(s) including the
format type (\code{formatType}), header row (\code{withHeader}), data separation
character (\code{separator}) and the type of compression (\code{compression}).

\code{formatType} is a required attribute and can have the following values:
\itemize{
\item \code{PARQUET} – Parquet source file format.
\item \code{CSV} – CSV source file format.
\item \code{JSON} – JSON source file format.
\item \code{XML} – XML source file format.
}

Here is an example of how you could specify the \code{formatParams}:

\verb{"formatParams": \{ "formatType": "CSV", "withHeader": "true", "separator": ",", "compression":"None" \}}

Note that if you only provide \code{formatType} as \code{CSV}, the rest of the
attributes will automatically default to CSV values as following:

\verb{\{ "withHeader": "true", "separator": "," \}}

For more information about supported file formats, see \href{https://docs.aws.amazon.com/finspace/latest/userguide/supported-data-types.html}{Supported Data Types and File Formats}
in the FinSpace User Guide.}
}
\description{
Updates a FinSpace Changeset.

See \url{https://paws-r.github.io/docs/finspacedata/update_changeset.html} for full documentation.
}
\keyword{internal}
