# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include s3control_service.R
NULL

#' Creates an access point and associates it with the specified bucket
#'
#' @description
#' Creates an access point and associates it with the specified bucket. For more information, see [Managing Data Access with Amazon S3 Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/create_access_point.html](https://paws-r.github.io/docs/s3control/create_access_point.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the bucket for which
#' you want to create an access point.
#' @param Name &#91;required&#93; The name you want to assign to this access point.
#' @param Bucket &#91;required&#93; The name of the bucket that you want to associate this access point
#' with.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#' @param VpcConfiguration If you include this field, Amazon S3 restricts access to this access
#' point to requests from the specified virtual private cloud (VPC).
#' 
#' This is required for creating an access point for Amazon S3 on Outposts
#' buckets.
#' @param PublicAccessBlockConfiguration The `PublicAccessBlock` configuration that you want to apply to the
#' access point.
#'
#' @keywords internal
#'
#' @rdname s3control_create_access_point
s3control_create_access_point <- function(AccountId, Name, Bucket, VpcConfiguration = NULL, PublicAccessBlockConfiguration = NULL) {
  op <- new_operation(
    name = "CreateAccessPoint",
    http_method = "PUT",
    http_path = "/v20180820/accesspoint/{name}",
    paginator = list()
  )
  input <- .s3control$create_access_point_input(AccountId = AccountId, Name = Name, Bucket = Bucket, VpcConfiguration = VpcConfiguration, PublicAccessBlockConfiguration = PublicAccessBlockConfiguration)
  output <- .s3control$create_access_point_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_access_point <- s3control_create_access_point

#' Creates an Object Lambda Access Point
#'
#' @description
#' Creates an Object Lambda Access Point. For more information, see [Transforming objects with Object Lambda Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/transforming-objects.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/create_access_point_for_object_lambda.html](https://paws-r.github.io/docs/s3control/create_access_point_for_object_lambda.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for owner of the specified Object
#' Lambda Access Point.
#' @param Name &#91;required&#93; The name you want to assign to this Object Lambda Access Point.
#' @param Configuration &#91;required&#93; Object Lambda Access Point configuration as a JSON document.
#'
#' @keywords internal
#'
#' @rdname s3control_create_access_point_for_object_lambda
s3control_create_access_point_for_object_lambda <- function(AccountId, Name, Configuration) {
  op <- new_operation(
    name = "CreateAccessPointForObjectLambda",
    http_method = "PUT",
    http_path = "/v20180820/accesspointforobjectlambda/{name}",
    paginator = list()
  )
  input <- .s3control$create_access_point_for_object_lambda_input(AccountId = AccountId, Name = Name, Configuration = Configuration)
  output <- .s3control$create_access_point_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_access_point_for_object_lambda <- s3control_create_access_point_for_object_lambda

#' This action creates an Amazon S3 on Outposts bucket
#'
#' @description
#' This action creates an Amazon S3 on Outposts bucket. To create an S3 bucket, see [Create Bucket](https://docs.aws.amazon.com/AmazonS3/latest/API/API_CreateBucket.html) in the *Amazon S3 API Reference*.
#'
#' See [https://paws-r.github.io/docs/s3control/create_bucket.html](https://paws-r.github.io/docs/s3control/create_bucket.html) for full documentation.
#'
#' @param ACL The canned ACL to apply to the bucket.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param Bucket &#91;required&#93; The name of the bucket.
#' @param CreateBucketConfiguration The configuration information for the bucket.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param GrantFullControl Allows grantee the read, write, read ACP, and write ACP permissions on
#' the bucket.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param GrantRead Allows grantee to list the objects in the bucket.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param GrantReadACP Allows grantee to read the bucket ACL.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param GrantWrite Allows grantee to create, overwrite, and delete any object in the
#' bucket.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param GrantWriteACP Allows grantee to write the ACL for the applicable bucket.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param ObjectLockEnabledForBucket Specifies whether you want S3 Object Lock to be enabled for the new
#' bucket.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param OutpostId The ID of the Outposts where the bucket is being created.
#' 
#' This is required by Amazon S3 on Outposts buckets.
#'
#' @keywords internal
#'
#' @rdname s3control_create_bucket
s3control_create_bucket <- function(ACL = NULL, Bucket, CreateBucketConfiguration = NULL, GrantFullControl = NULL, GrantRead = NULL, GrantReadACP = NULL, GrantWrite = NULL, GrantWriteACP = NULL, ObjectLockEnabledForBucket = NULL, OutpostId = NULL) {
  op <- new_operation(
    name = "CreateBucket",
    http_method = "PUT",
    http_path = "/v20180820/bucket/{name}",
    paginator = list()
  )
  input <- .s3control$create_bucket_input(ACL = ACL, Bucket = Bucket, CreateBucketConfiguration = CreateBucketConfiguration, GrantFullControl = GrantFullControl, GrantRead = GrantRead, GrantReadACP = GrantReadACP, GrantWrite = GrantWrite, GrantWriteACP = GrantWriteACP, ObjectLockEnabledForBucket = ObjectLockEnabledForBucket, OutpostId = OutpostId)
  output <- .s3control$create_bucket_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_bucket <- s3control_create_bucket

#' You can use S3 Batch Operations to perform large-scale batch actions on
#' Amazon S3 objects
#'
#' @description
#' You can use S3 Batch Operations to perform large-scale batch actions on Amazon S3 objects. Batch Operations can run a single action on lists of Amazon S3 objects that you specify. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/create_job.html](https://paws-r.github.io/docs/s3control/create_job.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID that creates the job.
#' @param ConfirmationRequired Indicates whether confirmation is required before Amazon S3 runs the
#' job. Confirmation is only required for jobs created through the Amazon
#' S3 console.
#' @param Operation &#91;required&#93; The action that you want this job to perform on every object listed in
#' the manifest. For more information about the available actions, see
#' [Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/) in
#' the *Amazon S3 User Guide*.
#' @param Report &#91;required&#93; Configuration parameters for the optional job-completion report.
#' @param ClientRequestToken &#91;required&#93; An idempotency token to ensure that you don't accidentally submit the
#' same request twice. You can use any string up to the maximum length.
#' @param Manifest Configuration parameters for the manifest.
#' @param Description A description for this job. You can use any string within the permitted
#' length. Descriptions don't need to be unique and can be used for
#' multiple jobs.
#' @param Priority &#91;required&#93; The numerical priority for this job. Higher numbers indicate higher
#' priority.
#' @param RoleArn &#91;required&#93; The Amazon Resource Name (ARN) for the Identity and Access Management
#' (IAM) role that Batch Operations will use to run this job's action on
#' every object in the manifest.
#' @param Tags A set of tags to associate with the S3 Batch Operations job. This is an
#' optional parameter.
#' @param ManifestGenerator The attribute container for the ManifestGenerator details. Jobs must be
#' created with either a manifest file or a ManifestGenerator, but not
#' both.
#'
#' @keywords internal
#'
#' @rdname s3control_create_job
s3control_create_job <- function(AccountId, ConfirmationRequired = NULL, Operation, Report, ClientRequestToken, Manifest = NULL, Description = NULL, Priority, RoleArn, Tags = NULL, ManifestGenerator = NULL) {
  op <- new_operation(
    name = "CreateJob",
    http_method = "POST",
    http_path = "/v20180820/jobs",
    paginator = list()
  )
  input <- .s3control$create_job_input(AccountId = AccountId, ConfirmationRequired = ConfirmationRequired, Operation = Operation, Report = Report, ClientRequestToken = ClientRequestToken, Manifest = Manifest, Description = Description, Priority = Priority, RoleArn = RoleArn, Tags = Tags, ManifestGenerator = ManifestGenerator)
  output <- .s3control$create_job_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_job <- s3control_create_job

#' Creates a Multi-Region Access Point and associates it with the specified
#' buckets
#'
#' @description
#' Creates a Multi-Region Access Point and associates it with the specified buckets. For more information about creating Multi-Region Access Points, see [Creating Multi-Region Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/create_multi_region_access_point.html](https://paws-r.github.io/docs/s3control/create_multi_region_access_point.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point. The owner of the Multi-Region Access Point also must own
#' the underlying buckets.
#' @param ClientToken &#91;required&#93; An idempotency token used to identify the request and guarantee that
#' requests are unique.
#' @param Details &#91;required&#93; A container element containing details about the Multi-Region Access
#' Point.
#'
#' @keywords internal
#'
#' @rdname s3control_create_multi_region_access_point
s3control_create_multi_region_access_point <- function(AccountId, ClientToken, Details) {
  op <- new_operation(
    name = "CreateMultiRegionAccessPoint",
    http_method = "POST",
    http_path = "/v20180820/async-requests/mrap/create",
    paginator = list()
  )
  input <- .s3control$create_multi_region_access_point_input(AccountId = AccountId, ClientToken = ClientToken, Details = Details)
  output <- .s3control$create_multi_region_access_point_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$create_multi_region_access_point <- s3control_create_multi_region_access_point

#' Deletes the specified access point
#'
#' @description
#' Deletes the specified access point.
#'
#' See [https://paws-r.github.io/docs/s3control/delete_access_point.html](https://paws-r.github.io/docs/s3control/delete_access_point.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified access point.
#' @param Name &#91;required&#93; The name of the access point you want to delete.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the access point
#' accessed in the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>`.
#' For example, to access the access point `reports-ap` through outpost
#' `my-outpost` owned by account `123456789012` in Region `us-west-2`, use
#' the URL encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_access_point
s3control_delete_access_point <- function(AccountId, Name) {
  op <- new_operation(
    name = "DeleteAccessPoint",
    http_method = "DELETE",
    http_path = "/v20180820/accesspoint/{name}",
    paginator = list()
  )
  input <- .s3control$delete_access_point_input(AccountId = AccountId, Name = Name)
  output <- .s3control$delete_access_point_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_access_point <- s3control_delete_access_point

#' Deletes the specified Object Lambda Access Point
#'
#' @description
#' Deletes the specified Object Lambda Access Point.
#'
#' See [https://paws-r.github.io/docs/s3control/delete_access_point_for_object_lambda.html](https://paws-r.github.io/docs/s3control/delete_access_point_for_object_lambda.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the access point you want to delete.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_access_point_for_object_lambda
s3control_delete_access_point_for_object_lambda <- function(AccountId, Name) {
  op <- new_operation(
    name = "DeleteAccessPointForObjectLambda",
    http_method = "DELETE",
    http_path = "/v20180820/accesspointforobjectlambda/{name}",
    paginator = list()
  )
  input <- .s3control$delete_access_point_for_object_lambda_input(AccountId = AccountId, Name = Name)
  output <- .s3control$delete_access_point_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_access_point_for_object_lambda <- s3control_delete_access_point_for_object_lambda

#' Deletes the access point policy for the specified access point
#'
#' @description
#' Deletes the access point policy for the specified access point.
#'
#' See [https://paws-r.github.io/docs/s3control/delete_access_point_policy.html](https://paws-r.github.io/docs/s3control/delete_access_point_policy.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified access point.
#' @param Name &#91;required&#93; The name of the access point whose policy you want to delete.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the access point
#' accessed in the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>`.
#' For example, to access the access point `reports-ap` through outpost
#' `my-outpost` owned by account `123456789012` in Region `us-west-2`, use
#' the URL encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_access_point_policy
s3control_delete_access_point_policy <- function(AccountId, Name) {
  op <- new_operation(
    name = "DeleteAccessPointPolicy",
    http_method = "DELETE",
    http_path = "/v20180820/accesspoint/{name}/policy",
    paginator = list()
  )
  input <- .s3control$delete_access_point_policy_input(AccountId = AccountId, Name = Name)
  output <- .s3control$delete_access_point_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_access_point_policy <- s3control_delete_access_point_policy

#' Removes the resource policy for an Object Lambda Access Point
#'
#' @description
#' Removes the resource policy for an Object Lambda Access Point.
#'
#' See [https://paws-r.github.io/docs/s3control/delete_access_point_policy_for_object_lambda.html](https://paws-r.github.io/docs/s3control/delete_access_point_policy_for_object_lambda.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the Object Lambda Access Point you want to delete the policy
#' for.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_access_point_policy_for_object_lambda
s3control_delete_access_point_policy_for_object_lambda <- function(AccountId, Name) {
  op <- new_operation(
    name = "DeleteAccessPointPolicyForObjectLambda",
    http_method = "DELETE",
    http_path = "/v20180820/accesspointforobjectlambda/{name}/policy",
    paginator = list()
  )
  input <- .s3control$delete_access_point_policy_for_object_lambda_input(AccountId = AccountId, Name = Name)
  output <- .s3control$delete_access_point_policy_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_access_point_policy_for_object_lambda <- s3control_delete_access_point_policy_for_object_lambda

#' This action deletes an Amazon S3 on Outposts bucket
#'
#' @description
#' This action deletes an Amazon S3 on Outposts bucket. To delete an S3 bucket, see [`delete_bucket`][s3control_delete_bucket] in the *Amazon S3 API Reference*.
#'
#' See [https://paws-r.github.io/docs/s3control/delete_bucket.html](https://paws-r.github.io/docs/s3control/delete_bucket.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID that owns the Outposts bucket.
#' @param Bucket &#91;required&#93; Specifies the bucket being deleted.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_bucket
s3control_delete_bucket <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "DeleteBucket",
    http_method = "DELETE",
    http_path = "/v20180820/bucket/{name}",
    paginator = list()
  )
  input <- .s3control$delete_bucket_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$delete_bucket_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_bucket <- s3control_delete_bucket

#' This action deletes an Amazon S3 on Outposts bucket's lifecycle
#' configuration
#'
#' @description
#' This action deletes an Amazon S3 on Outposts bucket's lifecycle configuration. To delete an S3 bucket's lifecycle configuration, see [DeleteBucketLifecycle](https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketLifecycle.html) in the *Amazon S3 API Reference*.
#'
#' See [https://paws-r.github.io/docs/s3control/delete_bucket_lifecycle_configuration.html](https://paws-r.github.io/docs/s3control/delete_bucket_lifecycle_configuration.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID of the lifecycle configuration to delete.
#' @param Bucket &#91;required&#93; Specifies the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_bucket_lifecycle_configuration
s3control_delete_bucket_lifecycle_configuration <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "DeleteBucketLifecycleConfiguration",
    http_method = "DELETE",
    http_path = "/v20180820/bucket/{name}/lifecycleconfiguration",
    paginator = list()
  )
  input <- .s3control$delete_bucket_lifecycle_configuration_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$delete_bucket_lifecycle_configuration_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_bucket_lifecycle_configuration <- s3control_delete_bucket_lifecycle_configuration

#' This action deletes an Amazon S3 on Outposts bucket policy
#'
#' @description
#' This action deletes an Amazon S3 on Outposts bucket policy. To delete an S3 bucket policy, see [`delete_bucket_policy`][s3control_delete_bucket_policy] in the *Amazon S3 API Reference*.
#'
#' See [https://paws-r.github.io/docs/s3control/delete_bucket_policy.html](https://paws-r.github.io/docs/s3control/delete_bucket_policy.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; Specifies the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_bucket_policy
s3control_delete_bucket_policy <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "DeleteBucketPolicy",
    http_method = "DELETE",
    http_path = "/v20180820/bucket/{name}/policy",
    paginator = list()
  )
  input <- .s3control$delete_bucket_policy_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$delete_bucket_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_bucket_policy <- s3control_delete_bucket_policy

#' This action deletes an Amazon S3 on Outposts bucket's tags
#'
#' @description
#' This action deletes an Amazon S3 on Outposts bucket's tags. To delete an S3 bucket tags, see [`delete_bucket_tagging`][s3control_delete_bucket_tagging] in the *Amazon S3 API Reference*.
#'
#' See [https://paws-r.github.io/docs/s3control/delete_bucket_tagging.html](https://paws-r.github.io/docs/s3control/delete_bucket_tagging.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket tag set to be
#' removed.
#' @param Bucket &#91;required&#93; The bucket ARN that has the tag set to be removed.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_bucket_tagging
s3control_delete_bucket_tagging <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "DeleteBucketTagging",
    http_method = "DELETE",
    http_path = "/v20180820/bucket/{name}/tagging",
    paginator = list()
  )
  input <- .s3control$delete_bucket_tagging_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$delete_bucket_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_bucket_tagging <- s3control_delete_bucket_tagging

#' Removes the entire tag set from the specified S3 Batch Operations job
#'
#' @description
#' Removes the entire tag set from the specified S3 Batch Operations job. To use this operation, you must have permission to perform the `s3:DeleteJobTagging` action. For more information, see [Controlling access and labeling jobs using tags](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops-managing-jobs.html#batch-ops-job-tags) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/delete_job_tagging.html](https://paws-r.github.io/docs/s3control/delete_job_tagging.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID associated with the S3 Batch
#' Operations job.
#' @param JobId &#91;required&#93; The ID for the S3 Batch Operations job whose tags you want to delete.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_job_tagging
s3control_delete_job_tagging <- function(AccountId, JobId) {
  op <- new_operation(
    name = "DeleteJobTagging",
    http_method = "DELETE",
    http_path = "/v20180820/jobs/{id}/tagging",
    paginator = list()
  )
  input <- .s3control$delete_job_tagging_input(AccountId = AccountId, JobId = JobId)
  output <- .s3control$delete_job_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_job_tagging <- s3control_delete_job_tagging

#' Deletes a Multi-Region Access Point
#'
#' @description
#' Deletes a Multi-Region Access Point. This action does not delete the buckets associated with the Multi-Region Access Point, only the Multi-Region Access Point itself.
#'
#' See [https://paws-r.github.io/docs/s3control/delete_multi_region_access_point.html](https://paws-r.github.io/docs/s3control/delete_multi_region_access_point.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param ClientToken &#91;required&#93; An idempotency token used to identify the request and guarantee that
#' requests are unique.
#' @param Details &#91;required&#93; A container element containing details about the Multi-Region Access
#' Point.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_multi_region_access_point
s3control_delete_multi_region_access_point <- function(AccountId, ClientToken, Details) {
  op <- new_operation(
    name = "DeleteMultiRegionAccessPoint",
    http_method = "POST",
    http_path = "/v20180820/async-requests/mrap/delete",
    paginator = list()
  )
  input <- .s3control$delete_multi_region_access_point_input(AccountId = AccountId, ClientToken = ClientToken, Details = Details)
  output <- .s3control$delete_multi_region_access_point_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_multi_region_access_point <- s3control_delete_multi_region_access_point

#' Removes the PublicAccessBlock configuration for an Amazon Web Services
#' account
#'
#' @description
#' Removes the `PublicAccessBlock` configuration for an Amazon Web Services account. For more information, see [Using Amazon S3 block public access](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html).
#'
#' See [https://paws-r.github.io/docs/s3control/delete_public_access_block.html](https://paws-r.github.io/docs/s3control/delete_public_access_block.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the Amazon Web Services account whose
#' `PublicAccessBlock` configuration you want to remove.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_public_access_block
s3control_delete_public_access_block <- function(AccountId) {
  op <- new_operation(
    name = "DeletePublicAccessBlock",
    http_method = "DELETE",
    http_path = "/v20180820/configuration/publicAccessBlock",
    paginator = list()
  )
  input <- .s3control$delete_public_access_block_input(AccountId = AccountId)
  output <- .s3control$delete_public_access_block_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_public_access_block <- s3control_delete_public_access_block

#' Deletes the Amazon S3 Storage Lens configuration
#'
#' @description
#' Deletes the Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see [Assessing your storage activity and usage with Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/delete_storage_lens_configuration.html](https://paws-r.github.io/docs/s3control/delete_storage_lens_configuration.html) for full documentation.
#'
#' @param ConfigId &#91;required&#93; The ID of the S3 Storage Lens configuration.
#' @param AccountId &#91;required&#93; The account ID of the requester.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_storage_lens_configuration
s3control_delete_storage_lens_configuration <- function(ConfigId, AccountId) {
  op <- new_operation(
    name = "DeleteStorageLensConfiguration",
    http_method = "DELETE",
    http_path = "/v20180820/storagelens/{storagelensid}",
    paginator = list()
  )
  input <- .s3control$delete_storage_lens_configuration_input(ConfigId = ConfigId, AccountId = AccountId)
  output <- .s3control$delete_storage_lens_configuration_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_storage_lens_configuration <- s3control_delete_storage_lens_configuration

#' Deletes the Amazon S3 Storage Lens configuration tags
#'
#' @description
#' Deletes the Amazon S3 Storage Lens configuration tags. For more information about S3 Storage Lens, see [Assessing your storage activity and usage with Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/delete_storage_lens_configuration_tagging.html](https://paws-r.github.io/docs/s3control/delete_storage_lens_configuration_tagging.html) for full documentation.
#'
#' @param ConfigId &#91;required&#93; The ID of the S3 Storage Lens configuration.
#' @param AccountId &#91;required&#93; The account ID of the requester.
#'
#' @keywords internal
#'
#' @rdname s3control_delete_storage_lens_configuration_tagging
s3control_delete_storage_lens_configuration_tagging <- function(ConfigId, AccountId) {
  op <- new_operation(
    name = "DeleteStorageLensConfigurationTagging",
    http_method = "DELETE",
    http_path = "/v20180820/storagelens/{storagelensid}/tagging",
    paginator = list()
  )
  input <- .s3control$delete_storage_lens_configuration_tagging_input(ConfigId = ConfigId, AccountId = AccountId)
  output <- .s3control$delete_storage_lens_configuration_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$delete_storage_lens_configuration_tagging <- s3control_delete_storage_lens_configuration_tagging

#' Retrieves the configuration parameters and status for a Batch Operations
#' job
#'
#' @description
#' Retrieves the configuration parameters and status for a Batch Operations job. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/describe_job.html](https://paws-r.github.io/docs/s3control/describe_job.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID associated with the S3 Batch
#' Operations job.
#' @param JobId &#91;required&#93; The ID for the job whose information you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname s3control_describe_job
s3control_describe_job <- function(AccountId, JobId) {
  op <- new_operation(
    name = "DescribeJob",
    http_method = "GET",
    http_path = "/v20180820/jobs/{id}",
    paginator = list()
  )
  input <- .s3control$describe_job_input(AccountId = AccountId, JobId = JobId)
  output <- .s3control$describe_job_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$describe_job <- s3control_describe_job

#' Retrieves the status of an asynchronous request to manage a Multi-Region
#' Access Point
#'
#' @description
#' Retrieves the status of an asynchronous request to manage a Multi-Region Access Point. For more information about managing Multi-Region Access Points and how asynchronous requests work, see [Managing Multi-Region Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/ManagingMultiRegionAccessPoints.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/describe_multi_region_access_point_operation.html](https://paws-r.github.io/docs/s3control/describe_multi_region_access_point_operation.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param RequestTokenARN &#91;required&#93; The request token associated with the request you want to know about.
#' This request token is returned as part of the response when you make an
#' asynchronous request. You provide this token to query about the status
#' of the asynchronous action.
#'
#' @keywords internal
#'
#' @rdname s3control_describe_multi_region_access_point_operation
s3control_describe_multi_region_access_point_operation <- function(AccountId, RequestTokenARN) {
  op <- new_operation(
    name = "DescribeMultiRegionAccessPointOperation",
    http_method = "GET",
    http_path = "/v20180820/async-requests/mrap/{request_token+}",
    paginator = list()
  )
  input <- .s3control$describe_multi_region_access_point_operation_input(AccountId = AccountId, RequestTokenARN = RequestTokenARN)
  output <- .s3control$describe_multi_region_access_point_operation_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$describe_multi_region_access_point_operation <- s3control_describe_multi_region_access_point_operation

#' Returns configuration information about the specified access point
#'
#' @description
#' Returns configuration information about the specified access point.
#'
#' See [https://paws-r.github.io/docs/s3control/get_access_point.html](https://paws-r.github.io/docs/s3control/get_access_point.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified access point.
#' @param Name &#91;required&#93; The name of the access point whose configuration information you want to
#' retrieve.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the access point
#' accessed in the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>`.
#' For example, to access the access point `reports-ap` through outpost
#' `my-outpost` owned by account `123456789012` in Region `us-west-2`, use
#' the URL encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point
s3control_get_access_point <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPoint",
    http_method = "GET",
    http_path = "/v20180820/accesspoint/{name}",
    paginator = list()
  )
  input <- .s3control$get_access_point_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point <- s3control_get_access_point

#' Returns configuration for an Object Lambda Access Point
#'
#' @description
#' Returns configuration for an Object Lambda Access Point.
#'
#' See [https://paws-r.github.io/docs/s3control/get_access_point_configuration_for_object_lambda.html](https://paws-r.github.io/docs/s3control/get_access_point_configuration_for_object_lambda.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the Object Lambda Access Point you want to return the
#' configuration for.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point_configuration_for_object_lambda
s3control_get_access_point_configuration_for_object_lambda <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPointConfigurationForObjectLambda",
    http_method = "GET",
    http_path = "/v20180820/accesspointforobjectlambda/{name}/configuration",
    paginator = list()
  )
  input <- .s3control$get_access_point_configuration_for_object_lambda_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_configuration_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point_configuration_for_object_lambda <- s3control_get_access_point_configuration_for_object_lambda

#' Returns configuration information about the specified Object Lambda
#' Access Point
#'
#' @description
#' Returns configuration information about the specified Object Lambda Access Point
#'
#' See [https://paws-r.github.io/docs/s3control/get_access_point_for_object_lambda.html](https://paws-r.github.io/docs/s3control/get_access_point_for_object_lambda.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the Object Lambda Access Point.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point_for_object_lambda
s3control_get_access_point_for_object_lambda <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPointForObjectLambda",
    http_method = "GET",
    http_path = "/v20180820/accesspointforobjectlambda/{name}",
    paginator = list()
  )
  input <- .s3control$get_access_point_for_object_lambda_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point_for_object_lambda <- s3control_get_access_point_for_object_lambda

#' Returns the access point policy associated with the specified access
#' point
#'
#' @description
#' Returns the access point policy associated with the specified access point.
#'
#' See [https://paws-r.github.io/docs/s3control/get_access_point_policy.html](https://paws-r.github.io/docs/s3control/get_access_point_policy.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified access point.
#' @param Name &#91;required&#93; The name of the access point whose policy you want to retrieve.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the access point
#' accessed in the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>`.
#' For example, to access the access point `reports-ap` through outpost
#' `my-outpost` owned by account `123456789012` in Region `us-west-2`, use
#' the URL encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point_policy
s3control_get_access_point_policy <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPointPolicy",
    http_method = "GET",
    http_path = "/v20180820/accesspoint/{name}/policy",
    paginator = list()
  )
  input <- .s3control$get_access_point_policy_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point_policy <- s3control_get_access_point_policy

#' Returns the resource policy for an Object Lambda Access Point
#'
#' @description
#' Returns the resource policy for an Object Lambda Access Point.
#'
#' See [https://paws-r.github.io/docs/s3control/get_access_point_policy_for_object_lambda.html](https://paws-r.github.io/docs/s3control/get_access_point_policy_for_object_lambda.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the Object Lambda Access Point.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point_policy_for_object_lambda
s3control_get_access_point_policy_for_object_lambda <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPointPolicyForObjectLambda",
    http_method = "GET",
    http_path = "/v20180820/accesspointforobjectlambda/{name}/policy",
    paginator = list()
  )
  input <- .s3control$get_access_point_policy_for_object_lambda_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_policy_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point_policy_for_object_lambda <- s3control_get_access_point_policy_for_object_lambda

#' Indicates whether the specified access point currently has a policy that
#' allows public access
#'
#' @description
#' Indicates whether the specified access point currently has a policy that allows public access. For more information about public access through access points, see [Managing Data Access with Amazon S3 access points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/get_access_point_policy_status.html](https://paws-r.github.io/docs/s3control/get_access_point_policy_status.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified access point.
#' @param Name &#91;required&#93; The name of the access point whose policy status you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point_policy_status
s3control_get_access_point_policy_status <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPointPolicyStatus",
    http_method = "GET",
    http_path = "/v20180820/accesspoint/{name}/policyStatus",
    paginator = list()
  )
  input <- .s3control$get_access_point_policy_status_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_policy_status_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point_policy_status <- s3control_get_access_point_policy_status

#' Returns the status of the resource policy associated with an Object
#' Lambda Access Point
#'
#' @description
#' Returns the status of the resource policy associated with an Object Lambda Access Point.
#'
#' See [https://paws-r.github.io/docs/s3control/get_access_point_policy_status_for_object_lambda.html](https://paws-r.github.io/docs/s3control/get_access_point_policy_status_for_object_lambda.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the Object Lambda Access Point.
#'
#' @keywords internal
#'
#' @rdname s3control_get_access_point_policy_status_for_object_lambda
s3control_get_access_point_policy_status_for_object_lambda <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetAccessPointPolicyStatusForObjectLambda",
    http_method = "GET",
    http_path = "/v20180820/accesspointforobjectlambda/{name}/policyStatus",
    paginator = list()
  )
  input <- .s3control$get_access_point_policy_status_for_object_lambda_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_access_point_policy_status_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_access_point_policy_status_for_object_lambda <- s3control_get_access_point_policy_status_for_object_lambda

#' Gets an Amazon S3 on Outposts bucket
#'
#' @description
#' Gets an Amazon S3 on Outposts bucket. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/get_bucket.html](https://paws-r.github.io/docs/s3control/get_bucket.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; Specifies the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_get_bucket
s3control_get_bucket <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "GetBucket",
    http_method = "GET",
    http_path = "/v20180820/bucket/{name}",
    paginator = list()
  )
  input <- .s3control$get_bucket_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$get_bucket_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_bucket <- s3control_get_bucket

#' This action gets an Amazon S3 on Outposts bucket's lifecycle
#' configuration
#'
#' @description
#' This action gets an Amazon S3 on Outposts bucket's lifecycle configuration. To get an S3 bucket's lifecycle configuration, see [`get_bucket_lifecycle_configuration`][s3control_get_bucket_lifecycle_configuration] in the *Amazon S3 API Reference*.
#'
#' See [https://paws-r.github.io/docs/s3control/get_bucket_lifecycle_configuration.html](https://paws-r.github.io/docs/s3control/get_bucket_lifecycle_configuration.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; The Amazon Resource Name (ARN) of the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_get_bucket_lifecycle_configuration
s3control_get_bucket_lifecycle_configuration <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "GetBucketLifecycleConfiguration",
    http_method = "GET",
    http_path = "/v20180820/bucket/{name}/lifecycleconfiguration",
    paginator = list()
  )
  input <- .s3control$get_bucket_lifecycle_configuration_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$get_bucket_lifecycle_configuration_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_bucket_lifecycle_configuration <- s3control_get_bucket_lifecycle_configuration

#' This action gets a bucket policy for an Amazon S3 on Outposts bucket
#'
#' @description
#' This action gets a bucket policy for an Amazon S3 on Outposts bucket. To get a policy for an S3 bucket, see [`get_bucket_policy`][s3control_get_bucket_policy] in the *Amazon S3 API Reference*.
#'
#' See [https://paws-r.github.io/docs/s3control/get_bucket_policy.html](https://paws-r.github.io/docs/s3control/get_bucket_policy.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; Specifies the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_get_bucket_policy
s3control_get_bucket_policy <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "GetBucketPolicy",
    http_method = "GET",
    http_path = "/v20180820/bucket/{name}/policy",
    paginator = list()
  )
  input <- .s3control$get_bucket_policy_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$get_bucket_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_bucket_policy <- s3control_get_bucket_policy

#' This action gets an Amazon S3 on Outposts bucket's tags
#'
#' @description
#' This action gets an Amazon S3 on Outposts bucket's tags. To get an S3 bucket tags, see [`get_bucket_tagging`][s3control_get_bucket_tagging] in the *Amazon S3 API Reference*.
#'
#' See [https://paws-r.github.io/docs/s3control/get_bucket_tagging.html](https://paws-r.github.io/docs/s3control/get_bucket_tagging.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; Specifies the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#'
#' @keywords internal
#'
#' @rdname s3control_get_bucket_tagging
s3control_get_bucket_tagging <- function(AccountId, Bucket) {
  op <- new_operation(
    name = "GetBucketTagging",
    http_method = "GET",
    http_path = "/v20180820/bucket/{name}/tagging",
    paginator = list()
  )
  input <- .s3control$get_bucket_tagging_input(AccountId = AccountId, Bucket = Bucket)
  output <- .s3control$get_bucket_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_bucket_tagging <- s3control_get_bucket_tagging

#' Returns the tags on an S3 Batch Operations job
#'
#' @description
#' Returns the tags on an S3 Batch Operations job. To use this operation, you must have permission to perform the `s3:GetJobTagging` action. For more information, see [Controlling access and labeling jobs using tags](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops-managing-jobs.html#batch-ops-job-tags) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/get_job_tagging.html](https://paws-r.github.io/docs/s3control/get_job_tagging.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID associated with the S3 Batch
#' Operations job.
#' @param JobId &#91;required&#93; The ID for the S3 Batch Operations job whose tags you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname s3control_get_job_tagging
s3control_get_job_tagging <- function(AccountId, JobId) {
  op <- new_operation(
    name = "GetJobTagging",
    http_method = "GET",
    http_path = "/v20180820/jobs/{id}/tagging",
    paginator = list()
  )
  input <- .s3control$get_job_tagging_input(AccountId = AccountId, JobId = JobId)
  output <- .s3control$get_job_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_job_tagging <- s3control_get_job_tagging

#' Returns configuration information about the specified Multi-Region
#' Access Point
#'
#' @description
#' Returns configuration information about the specified Multi-Region Access Point.
#'
#' See [https://paws-r.github.io/docs/s3control/get_multi_region_access_point.html](https://paws-r.github.io/docs/s3control/get_multi_region_access_point.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param Name &#91;required&#93; The name of the Multi-Region Access Point whose configuration
#' information you want to receive. The name of the Multi-Region Access
#' Point is different from the alias. For more information about the
#' distinction between the name and the alias of an Multi-Region Access
#' Point, see [Managing Multi-Region Access
#' Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming)
#' in the *Amazon S3 User Guide*.
#'
#' @keywords internal
#'
#' @rdname s3control_get_multi_region_access_point
s3control_get_multi_region_access_point <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetMultiRegionAccessPoint",
    http_method = "GET",
    http_path = "/v20180820/mrap/instances/{name}",
    paginator = list()
  )
  input <- .s3control$get_multi_region_access_point_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_multi_region_access_point_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_multi_region_access_point <- s3control_get_multi_region_access_point

#' Returns the access control policy of the specified Multi-Region Access
#' Point
#'
#' @description
#' Returns the access control policy of the specified Multi-Region Access Point.
#'
#' See [https://paws-r.github.io/docs/s3control/get_multi_region_access_point_policy.html](https://paws-r.github.io/docs/s3control/get_multi_region_access_point_policy.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param Name &#91;required&#93; Specifies the Multi-Region Access Point. The name of the Multi-Region
#' Access Point is different from the alias. For more information about the
#' distinction between the name and the alias of an Multi-Region Access
#' Point, see [Managing Multi-Region Access
#' Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming)
#' in the *Amazon S3 User Guide*.
#'
#' @keywords internal
#'
#' @rdname s3control_get_multi_region_access_point_policy
s3control_get_multi_region_access_point_policy <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetMultiRegionAccessPointPolicy",
    http_method = "GET",
    http_path = "/v20180820/mrap/instances/{name}/policy",
    paginator = list()
  )
  input <- .s3control$get_multi_region_access_point_policy_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_multi_region_access_point_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_multi_region_access_point_policy <- s3control_get_multi_region_access_point_policy

#' Indicates whether the specified Multi-Region Access Point has an access
#' control policy that allows public access
#'
#' @description
#' Indicates whether the specified Multi-Region Access Point has an access control policy that allows public access.
#'
#' See [https://paws-r.github.io/docs/s3control/get_multi_region_access_point_policy_status.html](https://paws-r.github.io/docs/s3control/get_multi_region_access_point_policy_status.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param Name &#91;required&#93; Specifies the Multi-Region Access Point. The name of the Multi-Region
#' Access Point is different from the alias. For more information about the
#' distinction between the name and the alias of an Multi-Region Access
#' Point, see [Managing Multi-Region Access
#' Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/CreatingMultiRegionAccessPoints.html#multi-region-access-point-naming)
#' in the *Amazon S3 User Guide*.
#'
#' @keywords internal
#'
#' @rdname s3control_get_multi_region_access_point_policy_status
s3control_get_multi_region_access_point_policy_status <- function(AccountId, Name) {
  op <- new_operation(
    name = "GetMultiRegionAccessPointPolicyStatus",
    http_method = "GET",
    http_path = "/v20180820/mrap/instances/{name}/policystatus",
    paginator = list()
  )
  input <- .s3control$get_multi_region_access_point_policy_status_input(AccountId = AccountId, Name = Name)
  output <- .s3control$get_multi_region_access_point_policy_status_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_multi_region_access_point_policy_status <- s3control_get_multi_region_access_point_policy_status

#' Retrieves the PublicAccessBlock configuration for an Amazon Web Services
#' account
#'
#' @description
#' Retrieves the `PublicAccessBlock` configuration for an Amazon Web Services account. For more information, see [Using Amazon S3 block public access](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html).
#'
#' See [https://paws-r.github.io/docs/s3control/get_public_access_block.html](https://paws-r.github.io/docs/s3control/get_public_access_block.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the Amazon Web Services account whose
#' `PublicAccessBlock` configuration you want to retrieve.
#'
#' @keywords internal
#'
#' @rdname s3control_get_public_access_block
s3control_get_public_access_block <- function(AccountId) {
  op <- new_operation(
    name = "GetPublicAccessBlock",
    http_method = "GET",
    http_path = "/v20180820/configuration/publicAccessBlock",
    paginator = list()
  )
  input <- .s3control$get_public_access_block_input(AccountId = AccountId)
  output <- .s3control$get_public_access_block_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_public_access_block <- s3control_get_public_access_block

#' Gets the Amazon S3 Storage Lens configuration
#'
#' @description
#' Gets the Amazon S3 Storage Lens configuration. For more information, see [Assessing your storage activity and usage with Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/get_storage_lens_configuration.html](https://paws-r.github.io/docs/s3control/get_storage_lens_configuration.html) for full documentation.
#'
#' @param ConfigId &#91;required&#93; The ID of the Amazon S3 Storage Lens configuration.
#' @param AccountId &#91;required&#93; The account ID of the requester.
#'
#' @keywords internal
#'
#' @rdname s3control_get_storage_lens_configuration
s3control_get_storage_lens_configuration <- function(ConfigId, AccountId) {
  op <- new_operation(
    name = "GetStorageLensConfiguration",
    http_method = "GET",
    http_path = "/v20180820/storagelens/{storagelensid}",
    paginator = list()
  )
  input <- .s3control$get_storage_lens_configuration_input(ConfigId = ConfigId, AccountId = AccountId)
  output <- .s3control$get_storage_lens_configuration_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_storage_lens_configuration <- s3control_get_storage_lens_configuration

#' Gets the tags of Amazon S3 Storage Lens configuration
#'
#' @description
#' Gets the tags of Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see [Assessing your storage activity and usage with Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/get_storage_lens_configuration_tagging.html](https://paws-r.github.io/docs/s3control/get_storage_lens_configuration_tagging.html) for full documentation.
#'
#' @param ConfigId &#91;required&#93; The ID of the Amazon S3 Storage Lens configuration.
#' @param AccountId &#91;required&#93; The account ID of the requester.
#'
#' @keywords internal
#'
#' @rdname s3control_get_storage_lens_configuration_tagging
s3control_get_storage_lens_configuration_tagging <- function(ConfigId, AccountId) {
  op <- new_operation(
    name = "GetStorageLensConfigurationTagging",
    http_method = "GET",
    http_path = "/v20180820/storagelens/{storagelensid}/tagging",
    paginator = list()
  )
  input <- .s3control$get_storage_lens_configuration_tagging_input(ConfigId = ConfigId, AccountId = AccountId)
  output <- .s3control$get_storage_lens_configuration_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$get_storage_lens_configuration_tagging <- s3control_get_storage_lens_configuration_tagging

#' Returns a list of the access points currently associated with the
#' specified bucket
#'
#' @description
#' Returns a list of the access points currently associated with the specified bucket. You can retrieve up to 1000 access points per call. If the specified bucket has more than 1,000 access points (or the number specified in `maxResults`, whichever is less), the response will include a continuation token that you can use to list the additional access points.
#'
#' See [https://paws-r.github.io/docs/s3control/list_access_points.html](https://paws-r.github.io/docs/s3control/list_access_points.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for owner of the bucket whose access
#' points you want to list.
#' @param Bucket The name of the bucket whose associated access points you want to list.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#' @param NextToken A continuation token. If a previous call to
#' [`list_access_points`][s3control_list_access_points] returned a
#' continuation token in the `NextToken` field, then providing that value
#' here causes Amazon S3 to retrieve the next page of results.
#' @param MaxResults The maximum number of access points that you want to include in the
#' list. If the specified bucket has more than this number of access
#' points, then the response will include a continuation token in the
#' `NextToken` field that you can use to retrieve the next page of access
#' points.
#'
#' @keywords internal
#'
#' @rdname s3control_list_access_points
s3control_list_access_points <- function(AccountId, Bucket = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAccessPoints",
    http_method = "GET",
    http_path = "/v20180820/accesspoint",
    paginator = list()
  )
  input <- .s3control$list_access_points_input(AccountId = AccountId, Bucket = Bucket, NextToken = NextToken, MaxResults = MaxResults)
  output <- .s3control$list_access_points_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_access_points <- s3control_list_access_points

#' Returns some or all (up to 1,000) access points associated with the
#' Object Lambda Access Point per call
#'
#' @description
#' Returns some or all (up to 1,000) access points associated with the Object Lambda Access Point per call. If there are more access points than what can be returned in one call, the response will include a continuation token that you can use to list the additional access points.
#'
#' See [https://paws-r.github.io/docs/s3control/list_access_points_for_object_lambda.html](https://paws-r.github.io/docs/s3control/list_access_points_for_object_lambda.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param NextToken If the list has more access points than can be returned in one call to
#' this API, this field contains a continuation token that you can provide
#' in subsequent calls to this API to retrieve additional access points.
#' @param MaxResults The maximum number of access points that you want to include in the
#' list. The response may contain fewer access points but will never
#' contain more. If there are more than this number of access points, then
#' the response will include a continuation token in the `NextToken` field
#' that you can use to retrieve the next page of access points.
#'
#' @keywords internal
#'
#' @rdname s3control_list_access_points_for_object_lambda
s3control_list_access_points_for_object_lambda <- function(AccountId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListAccessPointsForObjectLambda",
    http_method = "GET",
    http_path = "/v20180820/accesspointforobjectlambda",
    paginator = list()
  )
  input <- .s3control$list_access_points_for_object_lambda_input(AccountId = AccountId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .s3control$list_access_points_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_access_points_for_object_lambda <- s3control_list_access_points_for_object_lambda

#' Lists current S3 Batch Operations jobs and jobs that have ended within
#' the last 30 days for the Amazon Web Services account making the request
#'
#' @description
#' Lists current S3 Batch Operations jobs and jobs that have ended within the last 30 days for the Amazon Web Services account making the request. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/list_jobs.html](https://paws-r.github.io/docs/s3control/list_jobs.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID associated with the S3 Batch
#' Operations job.
#' @param JobStatuses The `List Jobs` request returns jobs that match the statuses listed in
#' this element.
#' @param NextToken A pagination token to request the next page of results. Use the token
#' that Amazon S3 returned in the `NextToken` element of the
#' `ListJobsResult` from the previous `List Jobs` request.
#' @param MaxResults The maximum number of jobs that Amazon S3 will include in the
#' `List Jobs` response. If there are more jobs than this number, the
#' response will include a pagination token in the `NextToken` field to
#' enable you to retrieve the next page of results.
#'
#' @keywords internal
#'
#' @rdname s3control_list_jobs
s3control_list_jobs <- function(AccountId, JobStatuses = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListJobs",
    http_method = "GET",
    http_path = "/v20180820/jobs",
    paginator = list()
  )
  input <- .s3control$list_jobs_input(AccountId = AccountId, JobStatuses = JobStatuses, NextToken = NextToken, MaxResults = MaxResults)
  output <- .s3control$list_jobs_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_jobs <- s3control_list_jobs

#' Returns a list of the Multi-Region Access Points currently associated
#' with the specified Amazon Web Services account
#'
#' @description
#' Returns a list of the Multi-Region Access Points currently associated with the specified Amazon Web Services account. Each call can return up to 100 Multi-Region Access Points, the maximum number of Multi-Region Access Points that can be associated with a single account.
#'
#' See [https://paws-r.github.io/docs/s3control/list_multi_region_access_points.html](https://paws-r.github.io/docs/s3control/list_multi_region_access_points.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param NextToken Not currently used. Do not use this parameter.
#' @param MaxResults Not currently used. Do not use this parameter.
#'
#' @keywords internal
#'
#' @rdname s3control_list_multi_region_access_points
s3control_list_multi_region_access_points <- function(AccountId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMultiRegionAccessPoints",
    http_method = "GET",
    http_path = "/v20180820/mrap/instances",
    paginator = list()
  )
  input <- .s3control$list_multi_region_access_points_input(AccountId = AccountId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .s3control$list_multi_region_access_points_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_multi_region_access_points <- s3control_list_multi_region_access_points

#' Returns a list of all Outposts buckets in an Outpost that are owned by
#' the authenticated sender of the request
#'
#' @description
#' Returns a list of all Outposts buckets in an Outpost that are owned by the authenticated sender of the request. For more information, see [Using Amazon S3 on Outposts](https://docs.aws.amazon.com/AmazonS3/latest/userguide/S3onOutposts.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/list_regional_buckets.html](https://paws-r.github.io/docs/s3control/list_regional_buckets.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param NextToken 
#' @param MaxResults 
#' @param OutpostId The ID of the Outposts.
#' 
#' This is required by Amazon S3 on Outposts buckets.
#'
#' @keywords internal
#'
#' @rdname s3control_list_regional_buckets
s3control_list_regional_buckets <- function(AccountId, NextToken = NULL, MaxResults = NULL, OutpostId = NULL) {
  op <- new_operation(
    name = "ListRegionalBuckets",
    http_method = "GET",
    http_path = "/v20180820/bucket",
    paginator = list()
  )
  input <- .s3control$list_regional_buckets_input(AccountId = AccountId, NextToken = NextToken, MaxResults = MaxResults, OutpostId = OutpostId)
  output <- .s3control$list_regional_buckets_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_regional_buckets <- s3control_list_regional_buckets

#' Gets a list of Amazon S3 Storage Lens configurations
#'
#' @description
#' Gets a list of Amazon S3 Storage Lens configurations. For more information about S3 Storage Lens, see [Assessing your storage activity and usage with Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/list_storage_lens_configurations.html](https://paws-r.github.io/docs/s3control/list_storage_lens_configurations.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID of the requester.
#' @param NextToken A pagination token to request the next page of results.
#'
#' @keywords internal
#'
#' @rdname s3control_list_storage_lens_configurations
s3control_list_storage_lens_configurations <- function(AccountId, NextToken = NULL) {
  op <- new_operation(
    name = "ListStorageLensConfigurations",
    http_method = "GET",
    http_path = "/v20180820/storagelens",
    paginator = list()
  )
  input <- .s3control$list_storage_lens_configurations_input(AccountId = AccountId, NextToken = NextToken)
  output <- .s3control$list_storage_lens_configurations_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$list_storage_lens_configurations <- s3control_list_storage_lens_configurations

#' Replaces configuration for an Object Lambda Access Point
#'
#' @description
#' Replaces configuration for an Object Lambda Access Point.
#'
#' See [https://paws-r.github.io/docs/s3control/put_access_point_configuration_for_object_lambda.html](https://paws-r.github.io/docs/s3control/put_access_point_configuration_for_object_lambda.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the Object Lambda Access Point.
#' @param Configuration &#91;required&#93; Object Lambda Access Point configuration document.
#'
#' @keywords internal
#'
#' @rdname s3control_put_access_point_configuration_for_object_lambda
s3control_put_access_point_configuration_for_object_lambda <- function(AccountId, Name, Configuration) {
  op <- new_operation(
    name = "PutAccessPointConfigurationForObjectLambda",
    http_method = "PUT",
    http_path = "/v20180820/accesspointforobjectlambda/{name}/configuration",
    paginator = list()
  )
  input <- .s3control$put_access_point_configuration_for_object_lambda_input(AccountId = AccountId, Name = Name, Configuration = Configuration)
  output <- .s3control$put_access_point_configuration_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_access_point_configuration_for_object_lambda <- s3control_put_access_point_configuration_for_object_lambda

#' Associates an access policy with the specified access point
#'
#' @description
#' Associates an access policy with the specified access point. Each access point can have only one policy, so a request made to this API replaces any existing policy associated with the specified access point.
#'
#' See [https://paws-r.github.io/docs/s3control/put_access_point_policy.html](https://paws-r.github.io/docs/s3control/put_access_point_policy.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for owner of the bucket associated
#' with the specified access point.
#' @param Name &#91;required&#93; The name of the access point that you want to associate with the
#' specified policy.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the access point
#' accessed in the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/accesspoint/<my-accesspoint-name>`.
#' For example, to access the access point `reports-ap` through outpost
#' `my-outpost` owned by account `123456789012` in Region `us-west-2`, use
#' the URL encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/accesspoint/reports-ap`.
#' The value must be URL encoded.
#' @param Policy &#91;required&#93; The policy that you want to apply to the specified access point. For
#' more information about access point policies, see [Managing data access
#' with Amazon S3 access
#' points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-points.html)
#' in the *Amazon S3 User Guide*.
#'
#' @keywords internal
#'
#' @rdname s3control_put_access_point_policy
s3control_put_access_point_policy <- function(AccountId, Name, Policy) {
  op <- new_operation(
    name = "PutAccessPointPolicy",
    http_method = "PUT",
    http_path = "/v20180820/accesspoint/{name}/policy",
    paginator = list()
  )
  input <- .s3control$put_access_point_policy_input(AccountId = AccountId, Name = Name, Policy = Policy)
  output <- .s3control$put_access_point_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_access_point_policy <- s3control_put_access_point_policy

#' Creates or replaces resource policy for an Object Lambda Access Point
#'
#' @description
#' Creates or replaces resource policy for an Object Lambda Access Point. For an example policy, see [Creating Object Lambda Access Points](https://docs.aws.amazon.com/AmazonS3/latest/userguide/olap-create.html#olap-create-cli) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/put_access_point_policy_for_object_lambda.html](https://paws-r.github.io/docs/s3control/put_access_point_policy_for_object_lambda.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The account ID for the account that owns the specified Object Lambda
#' Access Point.
#' @param Name &#91;required&#93; The name of the Object Lambda Access Point.
#' @param Policy &#91;required&#93; Object Lambda Access Point resource policy document.
#'
#' @keywords internal
#'
#' @rdname s3control_put_access_point_policy_for_object_lambda
s3control_put_access_point_policy_for_object_lambda <- function(AccountId, Name, Policy) {
  op <- new_operation(
    name = "PutAccessPointPolicyForObjectLambda",
    http_method = "PUT",
    http_path = "/v20180820/accesspointforobjectlambda/{name}/policy",
    paginator = list()
  )
  input <- .s3control$put_access_point_policy_for_object_lambda_input(AccountId = AccountId, Name = Name, Policy = Policy)
  output <- .s3control$put_access_point_policy_for_object_lambda_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_access_point_policy_for_object_lambda <- s3control_put_access_point_policy_for_object_lambda

#' This action puts a lifecycle configuration to an Amazon S3 on Outposts
#' bucket
#'
#' @description
#' This action puts a lifecycle configuration to an Amazon S3 on Outposts bucket. To put a lifecycle configuration to an S3 bucket, see [`put_bucket_lifecycle_configuration`][s3control_put_bucket_lifecycle_configuration] in the *Amazon S3 API Reference*.
#'
#' See [https://paws-r.github.io/docs/s3control/put_bucket_lifecycle_configuration.html](https://paws-r.github.io/docs/s3control/put_bucket_lifecycle_configuration.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; The name of the bucket for which to set the configuration.
#' @param LifecycleConfiguration Container for lifecycle rules. You can add as many as 1,000 rules.
#'
#' @keywords internal
#'
#' @rdname s3control_put_bucket_lifecycle_configuration
s3control_put_bucket_lifecycle_configuration <- function(AccountId, Bucket, LifecycleConfiguration = NULL) {
  op <- new_operation(
    name = "PutBucketLifecycleConfiguration",
    http_method = "PUT",
    http_path = "/v20180820/bucket/{name}/lifecycleconfiguration",
    paginator = list()
  )
  input <- .s3control$put_bucket_lifecycle_configuration_input(AccountId = AccountId, Bucket = Bucket, LifecycleConfiguration = LifecycleConfiguration)
  output <- .s3control$put_bucket_lifecycle_configuration_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_bucket_lifecycle_configuration <- s3control_put_bucket_lifecycle_configuration

#' This action puts a bucket policy to an Amazon S3 on Outposts bucket
#'
#' @description
#' This action puts a bucket policy to an Amazon S3 on Outposts bucket. To put a policy on an S3 bucket, see [`put_bucket_policy`][s3control_put_bucket_policy] in the *Amazon S3 API Reference*.
#'
#' See [https://paws-r.github.io/docs/s3control/put_bucket_policy.html](https://paws-r.github.io/docs/s3control/put_bucket_policy.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; Specifies the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#' @param ConfirmRemoveSelfBucketAccess Set this parameter to true to confirm that you want to remove your
#' permissions to change this bucket policy in the future.
#' 
#' This is not supported by Amazon S3 on Outposts buckets.
#' @param Policy &#91;required&#93; The bucket policy as a JSON document.
#'
#' @keywords internal
#'
#' @rdname s3control_put_bucket_policy
s3control_put_bucket_policy <- function(AccountId, Bucket, ConfirmRemoveSelfBucketAccess = NULL, Policy) {
  op <- new_operation(
    name = "PutBucketPolicy",
    http_method = "PUT",
    http_path = "/v20180820/bucket/{name}/policy",
    paginator = list()
  )
  input <- .s3control$put_bucket_policy_input(AccountId = AccountId, Bucket = Bucket, ConfirmRemoveSelfBucketAccess = ConfirmRemoveSelfBucketAccess, Policy = Policy)
  output <- .s3control$put_bucket_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_bucket_policy <- s3control_put_bucket_policy

#' This action puts tags on an Amazon S3 on Outposts bucket
#'
#' @description
#' This action puts tags on an Amazon S3 on Outposts bucket. To put tags on an S3 bucket, see [`put_bucket_tagging`][s3control_put_bucket_tagging] in the *Amazon S3 API Reference*.
#'
#' See [https://paws-r.github.io/docs/s3control/put_bucket_tagging.html](https://paws-r.github.io/docs/s3control/put_bucket_tagging.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID of the Outposts bucket.
#' @param Bucket &#91;required&#93; The Amazon Resource Name (ARN) of the bucket.
#' 
#' For using this parameter with Amazon S3 on Outposts with the REST API,
#' you must specify the name and the x-amz-outpost-id as well.
#' 
#' For using this parameter with S3 on Outposts with the Amazon Web
#' Services SDK and CLI, you must specify the ARN of the bucket accessed in
#' the format
#' `arn:aws:s3-outposts:<Region>:<account-id>:outpost/<outpost-id>/bucket/<my-bucket-name>`.
#' For example, to access the bucket `reports` through outpost `my-outpost`
#' owned by account `123456789012` in Region `us-west-2`, use the URL
#' encoding of
#' `arn:aws:s3-outposts:us-west-2:123456789012:outpost/my-outpost/bucket/reports`.
#' The value must be URL encoded.
#' @param Tagging &#91;required&#93; 
#'
#' @keywords internal
#'
#' @rdname s3control_put_bucket_tagging
s3control_put_bucket_tagging <- function(AccountId, Bucket, Tagging) {
  op <- new_operation(
    name = "PutBucketTagging",
    http_method = "PUT",
    http_path = "/v20180820/bucket/{name}/tagging",
    paginator = list()
  )
  input <- .s3control$put_bucket_tagging_input(AccountId = AccountId, Bucket = Bucket, Tagging = Tagging)
  output <- .s3control$put_bucket_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_bucket_tagging <- s3control_put_bucket_tagging

#' Sets the supplied tag-set on an S3 Batch Operations job
#'
#' @description
#' Sets the supplied tag-set on an S3 Batch Operations job.
#'
#' See [https://paws-r.github.io/docs/s3control/put_job_tagging.html](https://paws-r.github.io/docs/s3control/put_job_tagging.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID associated with the S3 Batch
#' Operations job.
#' @param JobId &#91;required&#93; The ID for the S3 Batch Operations job whose tags you want to replace.
#' @param Tags &#91;required&#93; The set of tags to associate with the S3 Batch Operations job.
#'
#' @keywords internal
#'
#' @rdname s3control_put_job_tagging
s3control_put_job_tagging <- function(AccountId, JobId, Tags) {
  op <- new_operation(
    name = "PutJobTagging",
    http_method = "PUT",
    http_path = "/v20180820/jobs/{id}/tagging",
    paginator = list()
  )
  input <- .s3control$put_job_tagging_input(AccountId = AccountId, JobId = JobId, Tags = Tags)
  output <- .s3control$put_job_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_job_tagging <- s3control_put_job_tagging

#' Associates an access control policy with the specified Multi-Region
#' Access Point
#'
#' @description
#' Associates an access control policy with the specified Multi-Region Access Point. Each Multi-Region Access Point can have only one policy, so a request made to this action replaces any existing policy that is associated with the specified Multi-Region Access Point.
#'
#' See [https://paws-r.github.io/docs/s3control/put_multi_region_access_point_policy.html](https://paws-r.github.io/docs/s3control/put_multi_region_access_point_policy.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID for the owner of the Multi-Region
#' Access Point.
#' @param ClientToken &#91;required&#93; An idempotency token used to identify the request and guarantee that
#' requests are unique.
#' @param Details &#91;required&#93; A container element containing the details of the policy for the
#' Multi-Region Access Point.
#'
#' @keywords internal
#'
#' @rdname s3control_put_multi_region_access_point_policy
s3control_put_multi_region_access_point_policy <- function(AccountId, ClientToken, Details) {
  op <- new_operation(
    name = "PutMultiRegionAccessPointPolicy",
    http_method = "POST",
    http_path = "/v20180820/async-requests/mrap/put-policy",
    paginator = list()
  )
  input <- .s3control$put_multi_region_access_point_policy_input(AccountId = AccountId, ClientToken = ClientToken, Details = Details)
  output <- .s3control$put_multi_region_access_point_policy_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_multi_region_access_point_policy <- s3control_put_multi_region_access_point_policy

#' Creates or modifies the PublicAccessBlock configuration for an Amazon
#' Web Services account
#'
#' @description
#' Creates or modifies the `PublicAccessBlock` configuration for an Amazon Web Services account. For this operation, users must have the `s3:PutBucketPublicAccessBlock` permission. For more information, see [Using Amazon S3 block public access](https://docs.aws.amazon.com/AmazonS3/latest/userguide/access-control-block-public-access.html).
#'
#' See [https://paws-r.github.io/docs/s3control/put_public_access_block.html](https://paws-r.github.io/docs/s3control/put_public_access_block.html) for full documentation.
#'
#' @param PublicAccessBlockConfiguration &#91;required&#93; The `PublicAccessBlock` configuration that you want to apply to the
#' specified Amazon Web Services account.
#' @param AccountId &#91;required&#93; The account ID for the Amazon Web Services account whose
#' `PublicAccessBlock` configuration you want to set.
#'
#' @keywords internal
#'
#' @rdname s3control_put_public_access_block
s3control_put_public_access_block <- function(PublicAccessBlockConfiguration, AccountId) {
  op <- new_operation(
    name = "PutPublicAccessBlock",
    http_method = "PUT",
    http_path = "/v20180820/configuration/publicAccessBlock",
    paginator = list()
  )
  input <- .s3control$put_public_access_block_input(PublicAccessBlockConfiguration = PublicAccessBlockConfiguration, AccountId = AccountId)
  output <- .s3control$put_public_access_block_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_public_access_block <- s3control_put_public_access_block

#' Puts an Amazon S3 Storage Lens configuration
#'
#' @description
#' Puts an Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see [Working with Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/put_storage_lens_configuration.html](https://paws-r.github.io/docs/s3control/put_storage_lens_configuration.html) for full documentation.
#'
#' @param ConfigId &#91;required&#93; The ID of the S3 Storage Lens configuration.
#' @param AccountId &#91;required&#93; The account ID of the requester.
#' @param StorageLensConfiguration &#91;required&#93; The S3 Storage Lens configuration.
#' @param Tags The tag set of the S3 Storage Lens configuration.
#' 
#' You can set up to a maximum of 50 tags.
#'
#' @keywords internal
#'
#' @rdname s3control_put_storage_lens_configuration
s3control_put_storage_lens_configuration <- function(ConfigId, AccountId, StorageLensConfiguration, Tags = NULL) {
  op <- new_operation(
    name = "PutStorageLensConfiguration",
    http_method = "PUT",
    http_path = "/v20180820/storagelens/{storagelensid}",
    paginator = list()
  )
  input <- .s3control$put_storage_lens_configuration_input(ConfigId = ConfigId, AccountId = AccountId, StorageLensConfiguration = StorageLensConfiguration, Tags = Tags)
  output <- .s3control$put_storage_lens_configuration_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_storage_lens_configuration <- s3control_put_storage_lens_configuration

#' Put or replace tags on an existing Amazon S3 Storage Lens configuration
#'
#' @description
#' Put or replace tags on an existing Amazon S3 Storage Lens configuration. For more information about S3 Storage Lens, see [Assessing your storage activity and usage with Amazon S3 Storage Lens](https://docs.aws.amazon.com/AmazonS3/latest/userguide/storage_lens.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/put_storage_lens_configuration_tagging.html](https://paws-r.github.io/docs/s3control/put_storage_lens_configuration_tagging.html) for full documentation.
#'
#' @param ConfigId &#91;required&#93; The ID of the S3 Storage Lens configuration.
#' @param AccountId &#91;required&#93; The account ID of the requester.
#' @param Tags &#91;required&#93; The tag set of the S3 Storage Lens configuration.
#' 
#' You can set up to a maximum of 50 tags.
#'
#' @keywords internal
#'
#' @rdname s3control_put_storage_lens_configuration_tagging
s3control_put_storage_lens_configuration_tagging <- function(ConfigId, AccountId, Tags) {
  op <- new_operation(
    name = "PutStorageLensConfigurationTagging",
    http_method = "PUT",
    http_path = "/v20180820/storagelens/{storagelensid}/tagging",
    paginator = list()
  )
  input <- .s3control$put_storage_lens_configuration_tagging_input(ConfigId = ConfigId, AccountId = AccountId, Tags = Tags)
  output <- .s3control$put_storage_lens_configuration_tagging_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$put_storage_lens_configuration_tagging <- s3control_put_storage_lens_configuration_tagging

#' Updates an existing S3 Batch Operations job's priority
#'
#' @description
#' Updates an existing S3 Batch Operations job's priority. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/update_job_priority.html](https://paws-r.github.io/docs/s3control/update_job_priority.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID associated with the S3 Batch
#' Operations job.
#' @param JobId &#91;required&#93; The ID for the job whose priority you want to update.
#' @param Priority &#91;required&#93; The priority you want to assign to this job.
#'
#' @keywords internal
#'
#' @rdname s3control_update_job_priority
s3control_update_job_priority <- function(AccountId, JobId, Priority) {
  op <- new_operation(
    name = "UpdateJobPriority",
    http_method = "POST",
    http_path = "/v20180820/jobs/{id}/priority",
    paginator = list()
  )
  input <- .s3control$update_job_priority_input(AccountId = AccountId, JobId = JobId, Priority = Priority)
  output <- .s3control$update_job_priority_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$update_job_priority <- s3control_update_job_priority

#' Updates the status for the specified job
#'
#' @description
#' Updates the status for the specified job. Use this action to confirm that you want to run a job or to cancel an existing job. For more information, see [S3 Batch Operations](https://docs.aws.amazon.com/AmazonS3/latest/userguide/batch-ops.html) in the *Amazon S3 User Guide*.
#'
#' See [https://paws-r.github.io/docs/s3control/update_job_status.html](https://paws-r.github.io/docs/s3control/update_job_status.html) for full documentation.
#'
#' @param AccountId &#91;required&#93; The Amazon Web Services account ID associated with the S3 Batch
#' Operations job.
#' @param JobId &#91;required&#93; The ID of the job whose status you want to update.
#' @param RequestedJobStatus &#91;required&#93; The status that you want to move the specified job to.
#' @param StatusUpdateReason A description of the reason why you want to change the specified job's
#' status. This field can be any string up to the maximum length.
#'
#' @keywords internal
#'
#' @rdname s3control_update_job_status
s3control_update_job_status <- function(AccountId, JobId, RequestedJobStatus, StatusUpdateReason = NULL) {
  op <- new_operation(
    name = "UpdateJobStatus",
    http_method = "POST",
    http_path = "/v20180820/jobs/{id}/status",
    paginator = list()
  )
  input <- .s3control$update_job_status_input(AccountId = AccountId, JobId = JobId, RequestedJobStatus = RequestedJobStatus, StatusUpdateReason = StatusUpdateReason)
  output <- .s3control$update_job_status_output()
  config <- get_config()
  svc <- .s3control$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.s3control$operations$update_job_status <- s3control_update_job_status
