# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config
NULL

#' AWS S3 Control
#'
#' @description
#' AWS S3 Control provides access to Amazon S3 control plane operations.
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#'
#' @section Service syntax:
#' ```
#' svc <- s3control(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string"
#'     ),
#'     endpoint = "string",
#'     region = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' \donttest{svc <- s3control()
#' svc$create_job(
#'   Foo = 123
#' )}
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=s3control_create_job]{create_job} \tab Creates an Amazon S3 batch operations job \cr
#'  \link[=s3control_delete_public_access_block]{delete_public_access_block} \tab Deletes the block public access configuration for the specified account \cr
#'  \link[=s3control_describe_job]{describe_job} \tab Retrieves the configuration parameters and status for a batch operations job \cr
#'  \link[=s3control_get_public_access_block]{get_public_access_block} \tab Get public access block \cr
#'  \link[=s3control_list_jobs]{list_jobs} \tab Lists current jobs and jobs that have ended within the last 30 days for the AWS account making the request\cr
#'  \link[=s3control_put_public_access_block]{put_public_access_block} \tab Put public access block \cr
#'  \link[=s3control_update_job_priority]{update_job_priority} \tab Updates an existing job's priority \cr
#'  \link[=s3control_update_job_status]{update_job_status} \tab Updates the status for the specified job 
#' }
#'
#' @rdname s3control
#' @export
s3control <- function(config = list()) {
  svc <- .s3control$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.s3control <- list()

.s3control$operations <- list()

.s3control$metadata <- list(
  service_name = "s3control",
  endpoints = list("*" = list(endpoint = "s3control.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "s3control.{region}.amazonaws.com.cn", global = FALSE)),
  service_id = "S3 Control",
  api_version = "2018-08-20",
  signing_name = "s3",
  json_version = "",
  target_prefix = ""
)

.s3control$handlers <- new_handlers("restxml", "s3v4")

.s3control$service <- function(config = list()) {
  new_service(.s3control$metadata, .s3control$handlers, config)
}
