# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include fsx_service.R
NULL

#' Creates a backup of an existing Amazon FSx for Windows File Server file
#' system
#'
#' Creates a backup of an existing Amazon FSx for Windows File Server file
#' system. Creating regular backups for your file system is a best practice
#' that complements the replication that Amazon FSx for Windows File Server
#' performs for your file system. It also enables you to restore from user
#' modification of data.
#' 
#' If a backup with the specified client request token exists, and the
#' parameters match, this operation returns the description of the existing
#' backup. If a backup specified client request token exists, and the
#' parameters don\'t match, this operation returns
#' `IncompatibleParameterError`. If a backup with the specified client
#' request token doesn\'t exist, `CreateBackup` does the following:
#' 
#' -   Creates a new Amazon FSx backup with an assigned ID, and an initial
#'     lifecycle state of `CREATING`.
#' 
#' -   Returns the description of the backup.
#' 
#' By using the idempotent operation, you can retry a `CreateBackup`
#' operation without the risk of creating an extra backup. This approach
#' can be useful when an initial call fails in a way that makes it unclear
#' whether a backup was created. If you use the same client request token
#' and the initial call created a backup, the operation returns a
#' successful result because all the parameters are the same.
#' 
#' The `CreateFileSystem` operation returns while the backup\'s lifecycle
#' state is still `CREATING`. You can check the file system creation status
#' by calling the DescribeBackups operation, which returns the backup state
#' along with other information.
#'
#' @usage
#' fsx_create_backup(FileSystemId, ClientRequestToken, Tags)
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system to back up.
#' @param ClientRequestToken (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
#' ensure idempotent creation. This string is automatically filled on your
#' behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS
#' SDK.
#' @param Tags The tags to apply to the backup at backup creation. The key value of the
#' `Name` tag appears in the console as the backup name.
#'
#' @section Request syntax:
#' ```
#' svc$create_backup(
#'   FileSystemId = "string",
#'   ClientRequestToken = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation creates a new backup.
#' \donttest{svc$create_backup(
#'   FileSystemId = "fs-0498eed5fe91001ec",
#'   Tags = list(
#'     list(
#'       Key = "Name",
#'       Value = "MyBackup"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname fsx_create_backup
fsx_create_backup <- function(FileSystemId, ClientRequestToken = NULL, Tags = NULL) {
  op <- new_operation(
    name = "CreateBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$create_backup_input(FileSystemId = FileSystemId, ClientRequestToken = ClientRequestToken, Tags = Tags)
  output <- .fsx$create_backup_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$create_backup <- fsx_create_backup

#' Creates a new, empty Amazon FSx file system
#'
#' Creates a new, empty Amazon FSx file system.
#' 
#' If a file system with the specified client request token exists and the
#' parameters match, `CreateFileSystem` returns the description of the
#' existing file system. If a file system specified client request token
#' exists and the parameters don\'t match, this call returns
#' `IncompatibleParameterError`. If a file system with the specified client
#' request token doesn\'t exist, `CreateFileSystem` does the following:
#' 
#' -   Creates a new, empty Amazon FSx file system with an assigned ID, and
#'     an initial lifecycle state of `CREATING`.
#' 
#' -   Returns the description of the file system.
#' 
#' This operation requires a client request token in the request that
#' Amazon FSx uses to ensure idempotent creation. This means that calling
#' the operation multiple times with the same client request token has no
#' effect. By using the idempotent operation, you can retry a
#' `CreateFileSystem` operation without the risk of creating an extra file
#' system. This approach can be useful when an initial call fails in a way
#' that makes it unclear whether a file system was created. Examples are if
#' a transport level timeout occurred, or your connection was reset. If you
#' use the same client request token and the initial call created a file
#' system, the client receives success as long as the parameters are the
#' same.
#' 
#' The `CreateFileSystem` call returns while the file system\'s lifecycle
#' state is still `CREATING`. You can check the file-system creation status
#' by calling the DescribeFileSystems operation, which returns the file
#' system state along with other information.
#'
#' @usage
#' fsx_create_file_system(ClientRequestToken, FileSystemType,
#'   StorageCapacity, SubnetIds, SecurityGroupIds, Tags, KmsKeyId,
#'   WindowsConfiguration, LustreConfiguration)
#'
#' @param ClientRequestToken (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
#' ensure idempotent creation. This string is automatically filled on your
#' behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS
#' SDK.
#' @param FileSystemType &#91;required&#93; The type of Amazon FSx file system to create.
#' @param StorageCapacity &#91;required&#93; The storage capacity of the file system being created.
#' 
#' For Windows file systems, the storage capacity has a minimum of 300 GiB,
#' and a maximum of 65,536 GiB.
#' 
#' For Lustre file systems, the storage capacity has a minimum of 3,600
#' GiB. Storage capacity is provisioned in increments of 3,600 GiB.
#' @param SubnetIds &#91;required&#93; The IDs of the subnets that the file system will be accessible from.
#' File systems support only one subnet. The file server is also launched
#' in that subnet\'s Availability Zone.
#' @param SecurityGroupIds A list of IDs specifying the security groups to apply to all network
#' interfaces created for file system access. This list isn\'t returned in
#' later requests to describe the file system.
#' @param Tags The tags to apply to the file system being created. The key value of the
#' `Name` tag appears in the console as the file system name.
#' @param KmsKeyId 
#' @param WindowsConfiguration The Microsoft Windows configuration for the file system being created.
#' This value is required if `FileSystemType` is set to `WINDOWS`.
#' @param LustreConfiguration 
#'
#' @section Request syntax:
#' ```
#' svc$create_file_system(
#'   ClientRequestToken = "string",
#'   FileSystemType = "WINDOWS"|"LUSTRE",
#'   StorageCapacity = 123,
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   KmsKeyId = "string",
#'   WindowsConfiguration = list(
#'     ActiveDirectoryId = "string",
#'     SelfManagedActiveDirectoryConfiguration = list(
#'       DomainName = "string",
#'       OrganizationalUnitDistinguishedName = "string",
#'       FileSystemAdministratorsGroup = "string",
#'       UserName = "string",
#'       Password = "string",
#'       DnsIps = list(
#'         "string"
#'       )
#'     ),
#'     ThroughputCapacity = 123,
#'     WeeklyMaintenanceStartTime = "string",
#'     DailyAutomaticBackupStartTime = "string",
#'     AutomaticBackupRetentionDays = 123,
#'     CopyTagsToBackups = TRUE|FALSE
#'   ),
#'   LustreConfiguration = list(
#'     WeeklyMaintenanceStartTime = "string",
#'     ImportPath = "string",
#'     ExportPath = "string",
#'     ImportedFileChunkSize = 123
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation creates a new file system.
#' \donttest{svc$create_file_system(
#'   ClientRequestToken = "a8ca07e4-61ec-4399-99f4-19853801bcd5",
#'   FileSystemType = "WINDOWS",
#'   KmsKeyId = "arn:aws:kms:us-east-1:012345678912:key/0ff3ea8d-130e-4133-877f-93908b6fdbd6",
#'   SecurityGroupIds = list(
#'     "sg-edcd9784"
#'   ),
#'   StorageCapacity = 300L,
#'   SubnetIds = list(
#'     "subnet-1234abcd"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "Name",
#'       Value = "MyFileSystem"
#'     )
#'   ),
#'   WindowsConfiguration = list(
#'     ActiveDirectoryId = "d-1234abcd12",
#'     AutomaticBackupRetentionDays = 30L,
#'     DailyAutomaticBackupStartTime = "05:00",
#'     ThroughputCapacity = 8L,
#'     WeeklyMaintenanceStartTime = "1:05:00"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname fsx_create_file_system
fsx_create_file_system <- function(ClientRequestToken = NULL, FileSystemType, StorageCapacity, SubnetIds, SecurityGroupIds = NULL, Tags = NULL, KmsKeyId = NULL, WindowsConfiguration = NULL, LustreConfiguration = NULL) {
  op <- new_operation(
    name = "CreateFileSystem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$create_file_system_input(ClientRequestToken = ClientRequestToken, FileSystemType = FileSystemType, StorageCapacity = StorageCapacity, SubnetIds = SubnetIds, SecurityGroupIds = SecurityGroupIds, Tags = Tags, KmsKeyId = KmsKeyId, WindowsConfiguration = WindowsConfiguration, LustreConfiguration = LustreConfiguration)
  output <- .fsx$create_file_system_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$create_file_system <- fsx_create_file_system

#' Creates a new Amazon FSx file system from an existing Amazon FSx for
#' Windows File Server backup
#'
#' Creates a new Amazon FSx file system from an existing Amazon FSx for
#' Windows File Server backup.
#' 
#' If a file system with the specified client request token exists and the
#' parameters match, this operation returns the description of the file
#' system. If a client request token specified by the file system exists
#' and the parameters don\'t match, this call returns
#' `IncompatibleParameterError`. If a file system with the specified client
#' request token doesn\'t exist, this operation does the following:
#' 
#' -   Creates a new Amazon FSx file system from backup with an assigned
#'     ID, and an initial lifecycle state of `CREATING`.
#' 
#' -   Returns the description of the file system.
#' 
#' Parameters like Active Directory, default share name, automatic backup,
#' and backup settings default to the parameters of the file system that
#' was backed up, unless overridden. You can explicitly supply other
#' settings.
#' 
#' By using the idempotent operation, you can retry a
#' `CreateFileSystemFromBackup` call without the risk of creating an extra
#' file system. This approach can be useful when an initial call fails in a
#' way that makes it unclear whether a file system was created. Examples
#' are if a transport level timeout occurred, or your connection was reset.
#' If you use the same client request token and the initial call created a
#' file system, the client receives success as long as the parameters are
#' the same.
#' 
#' The `CreateFileSystemFromBackup` call returns while the file system\'s
#' lifecycle state is still `CREATING`. You can check the file-system
#' creation status by calling the DescribeFileSystems operation, which
#' returns the file system state along with other information.
#'
#' @usage
#' fsx_create_file_system_from_backup(BackupId, ClientRequestToken,
#'   SubnetIds, SecurityGroupIds, Tags, WindowsConfiguration)
#'
#' @param BackupId &#91;required&#93; 
#' @param ClientRequestToken (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
#' ensure idempotent creation. This string is automatically filled on your
#' behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS
#' SDK.
#' @param SubnetIds &#91;required&#93; A list of IDs for the subnets that the file system will be accessible
#' from. Currently, you can specify only one subnet. The file server is
#' also launched in that subnet\'s Availability Zone.
#' @param SecurityGroupIds A list of IDs for the security groups that apply to the specified
#' network interfaces created for file system access. These security groups
#' apply to all network interfaces. This value isn\'t returned in later
#' describe requests.
#' @param Tags The tags to be applied to the file system at file system creation. The
#' key value of the `Name` tag appears in the console as the file system
#' name.
#' @param WindowsConfiguration The configuration for this Microsoft Windows file system.
#'
#' @section Request syntax:
#' ```
#' svc$create_file_system_from_backup(
#'   BackupId = "string",
#'   ClientRequestToken = "string",
#'   SubnetIds = list(
#'     "string"
#'   ),
#'   SecurityGroupIds = list(
#'     "string"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   ),
#'   WindowsConfiguration = list(
#'     ActiveDirectoryId = "string",
#'     SelfManagedActiveDirectoryConfiguration = list(
#'       DomainName = "string",
#'       OrganizationalUnitDistinguishedName = "string",
#'       FileSystemAdministratorsGroup = "string",
#'       UserName = "string",
#'       Password = "string",
#'       DnsIps = list(
#'         "string"
#'       )
#'     ),
#'     ThroughputCapacity = 123,
#'     WeeklyMaintenanceStartTime = "string",
#'     DailyAutomaticBackupStartTime = "string",
#'     AutomaticBackupRetentionDays = 123,
#'     CopyTagsToBackups = TRUE|FALSE
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation creates a new file system from backup.
#' \donttest{svc$create_file_system_from_backup(
#'   BackupId = "backup-03e3c82e0183b7b6b",
#'   ClientRequestToken = "f4c94ed7-238d-4c46-93db-48cd62ec33b7",
#'   SecurityGroupIds = list(
#'     "sg-edcd9784"
#'   ),
#'   SubnetIds = list(
#'     "subnet-1234abcd"
#'   ),
#'   Tags = list(
#'     list(
#'       Key = "Name",
#'       Value = "MyFileSystem"
#'     )
#'   ),
#'   WindowsConfiguration = list(
#'     ThroughputCapacity = 8L
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname fsx_create_file_system_from_backup
fsx_create_file_system_from_backup <- function(BackupId, ClientRequestToken = NULL, SubnetIds, SecurityGroupIds = NULL, Tags = NULL, WindowsConfiguration = NULL) {
  op <- new_operation(
    name = "CreateFileSystemFromBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$create_file_system_from_backup_input(BackupId = BackupId, ClientRequestToken = ClientRequestToken, SubnetIds = SubnetIds, SecurityGroupIds = SecurityGroupIds, Tags = Tags, WindowsConfiguration = WindowsConfiguration)
  output <- .fsx$create_file_system_from_backup_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$create_file_system_from_backup <- fsx_create_file_system_from_backup

#' Deletes an Amazon FSx for Windows File Server backup, deleting its
#' contents
#'
#' Deletes an Amazon FSx for Windows File Server backup, deleting its
#' contents. After deletion, the backup no longer exists, and its data is
#' gone.
#' 
#' The `DeleteBackup` call returns instantly. The backup will not show up
#' in later `DescribeBackups` calls.
#' 
#' The data in a deleted backup is also deleted and can\'t be recovered by
#' any means.
#'
#' @usage
#' fsx_delete_backup(BackupId, ClientRequestToken)
#'
#' @param BackupId &#91;required&#93; The ID of the backup you want to delete.
#' @param ClientRequestToken (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
#' ensure idempotent deletion. This is automatically filled on your behalf
#' when using the AWS CLI or SDK.
#'
#' @section Request syntax:
#' ```
#' svc$delete_backup(
#'   BackupId = "string",
#'   ClientRequestToken = "string"
#' )
#' ```
#'
#' @examples
#' # This operation deletes an Amazon FSx file system backup.
#' \donttest{svc$delete_backup(
#'   BackupId = "backup-03e3c82e0183b7b6b"
#' )}
#'
#' @keywords internal
#'
#' @rdname fsx_delete_backup
fsx_delete_backup <- function(BackupId, ClientRequestToken = NULL) {
  op <- new_operation(
    name = "DeleteBackup",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$delete_backup_input(BackupId = BackupId, ClientRequestToken = ClientRequestToken)
  output <- .fsx$delete_backup_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$delete_backup <- fsx_delete_backup

#' Deletes a file system, deleting its contents
#'
#' Deletes a file system, deleting its contents. After deletion, the file
#' system no longer exists, and its data is gone. Any existing automatic
#' backups will also be deleted.
#' 
#' By default, when you delete an Amazon FSx for Windows File Server file
#' system, a final backup is created upon deletion. This final backup is
#' not subject to the file system\'s retention policy, and must be manually
#' deleted.
#' 
#' The `DeleteFileSystem` action returns while the file system has the
#' `DELETING` status. You can check the file system deletion status by
#' calling the DescribeFileSystems action, which returns a list of file
#' systems in your account. If you pass the file system ID for a deleted
#' file system, the DescribeFileSystems returns a `FileSystemNotFound`
#' error.
#' 
#' The data in a deleted file system is also deleted and can\'t be
#' recovered by any means.
#'
#' @usage
#' fsx_delete_file_system(FileSystemId, ClientRequestToken,
#'   WindowsConfiguration)
#'
#' @param FileSystemId &#91;required&#93; The ID of the file system you want to delete.
#' @param ClientRequestToken (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
#' ensure idempotent deletion. This is automatically filled on your behalf
#' when using the AWS CLI or SDK.
#' @param WindowsConfiguration 
#'
#' @section Request syntax:
#' ```
#' svc$delete_file_system(
#'   FileSystemId = "string",
#'   ClientRequestToken = "string",
#'   WindowsConfiguration = list(
#'     SkipFinalBackup = TRUE|FALSE,
#'     FinalBackupTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation deletes an Amazon FSx file system.
#' \donttest{svc$delete_file_system(
#'   FileSystemId = "fs-0498eed5fe91001ec"
#' )}
#'
#' @keywords internal
#'
#' @rdname fsx_delete_file_system
fsx_delete_file_system <- function(FileSystemId, ClientRequestToken = NULL, WindowsConfiguration = NULL) {
  op <- new_operation(
    name = "DeleteFileSystem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$delete_file_system_input(FileSystemId = FileSystemId, ClientRequestToken = ClientRequestToken, WindowsConfiguration = WindowsConfiguration)
  output <- .fsx$delete_file_system_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$delete_file_system <- fsx_delete_file_system

#' Returns the description of specific Amazon FSx for Windows File Server
#' backups, if a BackupIds value is provided for that backup
#'
#' Returns the description of specific Amazon FSx for Windows File Server
#' backups, if a `BackupIds` value is provided for that backup. Otherwise,
#' it returns all backups owned by your AWS account in the AWS Region of
#' the endpoint that you\'re calling.
#' 
#' When retrieving all backups, you can optionally specify the `MaxResults`
#' parameter to limit the number of backups in a response. If more backups
#' remain, Amazon FSx returns a `NextToken` value in the response. In this
#' case, send a later request with the `NextToken` request parameter set to
#' the value of `NextToken` from the last response.
#' 
#' This action is used in an iterative process to retrieve a list of your
#' backups. `DescribeBackups` is called first without a `NextToken`value.
#' Then the action continues to be called with the `NextToken` parameter
#' set to the value of the last `NextToken` value until a response has no
#' `NextToken`.
#' 
#' When using this action, keep the following in mind:
#' 
#' -   The implementation might return fewer than `MaxResults` file system
#'     descriptions while still including a `NextToken` value.
#' 
#' -   The order of backups returned in the response of one
#'     `DescribeBackups` call and the order of backups returned across the
#'     responses of a multi-call iteration is unspecified.
#'
#' @usage
#' fsx_describe_backups(BackupIds, Filters, MaxResults, NextToken)
#'
#' @param BackupIds (Optional) IDs of the backups you want to retrieve (String). This
#' overrides any filters. If any IDs are not found, BackupNotFound will be
#' thrown.
#' @param Filters (Optional) Filters structure. Supported names are file-system-id and
#' backup-type.
#' @param MaxResults (Optional) Maximum number of backups to return in the response
#' (integer). This parameter value must be greater than 0. The number of
#' items that Amazon FSx returns is the minimum of the `MaxResults`
#' parameter specified in the request and the service\'s internal maximum
#' number of items per page.
#' @param NextToken (Optional) Opaque pagination token returned from a previous
#' `DescribeBackups` operation (String). If a token present, the action
#' continues the list from where the returning call left off.
#'
#' @section Request syntax:
#' ```
#' svc$describe_backups(
#'   BackupIds = list(
#'     "string"
#'   ),
#'   Filters = list(
#'     list(
#'       Name = "file-system-id"|"backup-type",
#'       Values = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # This operation describes all of the Amazon FSx backups in an account.
#' \donttest{svc$describe_backups()}
#'
#' @keywords internal
#'
#' @rdname fsx_describe_backups
fsx_describe_backups <- function(BackupIds = NULL, Filters = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeBackups",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$describe_backups_input(BackupIds = BackupIds, Filters = Filters, MaxResults = MaxResults, NextToken = NextToken)
  output <- .fsx$describe_backups_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$describe_backups <- fsx_describe_backups

#' Returns the description of specific Amazon FSx file systems, if a
#' FileSystemIds value is provided for that file system
#'
#' Returns the description of specific Amazon FSx file systems, if a
#' `FileSystemIds` value is provided for that file system. Otherwise, it
#' returns descriptions of all file systems owned by your AWS account in
#' the AWS Region of the endpoint that you\'re calling.
#' 
#' When retrieving all file system descriptions, you can optionally specify
#' the `MaxResults` parameter to limit the number of descriptions in a
#' response. If more file system descriptions remain, Amazon FSx returns a
#' `NextToken` value in the response. In this case, send a later request
#' with the `NextToken` request parameter set to the value of `NextToken`
#' from the last response.
#' 
#' This action is used in an iterative process to retrieve a list of your
#' file system descriptions. `DescribeFileSystems` is called first without
#' a `NextToken`value. Then the action continues to be called with the
#' `NextToken` parameter set to the value of the last `NextToken` value
#' until a response has no `NextToken`.
#' 
#' When using this action, keep the following in mind:
#' 
#' -   The implementation might return fewer than `MaxResults` file system
#'     descriptions while still including a `NextToken` value.
#' 
#' -   The order of file systems returned in the response of one
#'     `DescribeFileSystems` call and the order of file systems returned
#'     across the responses of a multicall iteration is unspecified.
#'
#' @usage
#' fsx_describe_file_systems(FileSystemIds, MaxResults, NextToken)
#'
#' @param FileSystemIds (Optional) IDs of the file systems whose descriptions you want to
#' retrieve (String).
#' @param MaxResults (Optional) Maximum number of file systems to return in the response
#' (integer). This parameter value must be greater than 0. The number of
#' items that Amazon FSx returns is the minimum of the `MaxResults`
#' parameter specified in the request and the service\'s internal maximum
#' number of items per page.
#' @param NextToken (Optional) Opaque pagination token returned from a previous
#' `DescribeFileSystems` operation (String). If a token present, the action
#' continues the list from where the returning call left off.
#'
#' @section Request syntax:
#' ```
#' svc$describe_file_systems(
#'   FileSystemIds = list(
#'     "string"
#'   ),
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # This operation describes all of the Amazon FSx file systems in an
#' # account.
#' \donttest{svc$describe_file_systems()}
#'
#' @keywords internal
#'
#' @rdname fsx_describe_file_systems
fsx_describe_file_systems <- function(FileSystemIds = NULL, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "DescribeFileSystems",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$describe_file_systems_input(FileSystemIds = FileSystemIds, MaxResults = MaxResults, NextToken = NextToken)
  output <- .fsx$describe_file_systems_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$describe_file_systems <- fsx_describe_file_systems

#' Lists tags for an Amazon FSx file systems and backups in the case of
#' Amazon FSx for Windows File Server
#'
#' Lists tags for an Amazon FSx file systems and backups in the case of
#' Amazon FSx for Windows File Server.
#' 
#' When retrieving all tags, you can optionally specify the `MaxResults`
#' parameter to limit the number of tags in a response. If more tags
#' remain, Amazon FSx returns a `NextToken` value in the response. In this
#' case, send a later request with the `NextToken` request parameter set to
#' the value of `NextToken` from the last response.
#' 
#' This action is used in an iterative process to retrieve a list of your
#' tags. `ListTagsForResource` is called first without a `NextToken`value.
#' Then the action continues to be called with the `NextToken` parameter
#' set to the value of the last `NextToken` value until a response has no
#' `NextToken`.
#' 
#' When using this action, keep the following in mind:
#' 
#' -   The implementation might return fewer than `MaxResults` file system
#'     descriptions while still including a `NextToken` value.
#' 
#' -   The order of tags returned in the response of one
#'     `ListTagsForResource` call and the order of tags returned across the
#'     responses of a multi-call iteration is unspecified.
#'
#' @usage
#' fsx_list_tags_for_resource(ResourceARN, MaxResults, NextToken)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the Amazon FSx resource that will have its tags listed.
#' @param MaxResults (Optional) Maximum number of tags to return in the response (integer).
#' This parameter value must be greater than 0. The number of items that
#' Amazon FSx returns is the minimum of the `MaxResults` parameter
#' specified in the request and the service\'s internal maximum number of
#' items per page.
#' @param NextToken (Optional) Opaque pagination token returned from a previous
#' `ListTagsForResource` operation (String). If a token present, the action
#' continues the list from where the returning call left off.
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceARN = "string",
#'   MaxResults = 123,
#'   NextToken = "string"
#' )
#' ```
#'
#' @examples
#' # This operation lists tags for an Amazon FSx resource.
#' \donttest{svc$list_tags_for_resource(
#'   ResourceARN = "arn:aws:fsx:us-east-1:012345678912:file-system/fs-0498eed5fe91001ec"
#' )}
#'
#' @keywords internal
#'
#' @rdname fsx_list_tags_for_resource
fsx_list_tags_for_resource <- function(ResourceARN, MaxResults = NULL, NextToken = NULL) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$list_tags_for_resource_input(ResourceARN = ResourceARN, MaxResults = MaxResults, NextToken = NextToken)
  output <- .fsx$list_tags_for_resource_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$list_tags_for_resource <- fsx_list_tags_for_resource

#' Tags an Amazon FSx resource
#'
#' Tags an Amazon FSx resource.
#'
#' @usage
#' fsx_tag_resource(ResourceARN, Tags)
#'
#' @param ResourceARN &#91;required&#93; The Amazon Resource Name (ARN) of the Amazon FSx resource that you want
#' to tag.
#' @param Tags &#91;required&#93; A list of tags for the resource. If a tag with a given key already
#' exists, the value is replaced by the one specified in this parameter.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceARN = "string",
#'   Tags = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation tags an Amazon FSx resource.
#' \donttest{svc$tag_resource(
#'   ResourceARN = "arn:aws:fsx:us-east-1:012345678912:file-system/fs-0498eed5fe91001ec",
#'   Tags = list(
#'     list(
#'       Key = "Name",
#'       Value = "MyFileSystem"
#'     )
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname fsx_tag_resource
fsx_tag_resource <- function(ResourceARN, Tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$tag_resource_input(ResourceARN = ResourceARN, Tags = Tags)
  output <- .fsx$tag_resource_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$tag_resource <- fsx_tag_resource

#' This action removes a tag from an Amazon FSx resource
#'
#' This action removes a tag from an Amazon FSx resource.
#'
#' @usage
#' fsx_untag_resource(ResourceARN, TagKeys)
#'
#' @param ResourceARN &#91;required&#93; The ARN of the Amazon FSx resource to untag.
#' @param TagKeys &#91;required&#93; A list of keys of tags on the resource to untag. In case the tag key
#' doesn\'t exist, the call will still succeed to be idempotent.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceARN = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation untags an Amazon FSx resource.
#' \donttest{svc$untag_resource(
#'   ResourceARN = "arn:aws:fsx:us-east-1:012345678912:file-system/fs-0498eed5fe91001ec",
#'   TagKeys = list(
#'     "Name"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname fsx_untag_resource
fsx_untag_resource <- function(ResourceARN, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$untag_resource_input(ResourceARN = ResourceARN, TagKeys = TagKeys)
  output <- .fsx$untag_resource_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$untag_resource <- fsx_untag_resource

#' Updates a file system configuration
#'
#' Updates a file system configuration.
#'
#' @usage
#' fsx_update_file_system(FileSystemId, ClientRequestToken,
#'   WindowsConfiguration, LustreConfiguration)
#'
#' @param FileSystemId &#91;required&#93; 
#' @param ClientRequestToken (Optional) A string of up to 64 ASCII characters that Amazon FSx uses to
#' ensure idempotent updates. This string is automatically filled on your
#' behalf when you use the AWS Command Line Interface (AWS CLI) or an AWS
#' SDK.
#' @param WindowsConfiguration The configuration update for this Microsoft Windows file system. The
#' only supported options are for backup and maintenance and for
#' self-managed Active Directory configuration.
#' @param LustreConfiguration 
#'
#' @section Request syntax:
#' ```
#' svc$update_file_system(
#'   FileSystemId = "string",
#'   ClientRequestToken = "string",
#'   WindowsConfiguration = list(
#'     WeeklyMaintenanceStartTime = "string",
#'     DailyAutomaticBackupStartTime = "string",
#'     AutomaticBackupRetentionDays = 123,
#'     SelfManagedActiveDirectoryConfiguration = list(
#'       UserName = "string",
#'       Password = "string",
#'       DnsIps = list(
#'         "string"
#'       )
#'     )
#'   ),
#'   LustreConfiguration = list(
#'     WeeklyMaintenanceStartTime = "string"
#'   )
#' )
#' ```
#'
#' @examples
#' # This operation updates an existing file system.
#' \donttest{svc$update_file_system(
#'   FileSystemId = "fs-0498eed5fe91001ec",
#'   WindowsConfiguration = list(
#'     AutomaticBackupRetentionDays = 10L,
#'     DailyAutomaticBackupStartTime = "06:00",
#'     WeeklyMaintenanceStartTime = "3:06:00"
#'   )
#' )}
#'
#' @keywords internal
#'
#' @rdname fsx_update_file_system
fsx_update_file_system <- function(FileSystemId, ClientRequestToken = NULL, WindowsConfiguration = NULL, LustreConfiguration = NULL) {
  op <- new_operation(
    name = "UpdateFileSystem",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fsx$update_file_system_input(FileSystemId = FileSystemId, ClientRequestToken = ClientRequestToken, WindowsConfiguration = WindowsConfiguration, LustreConfiguration = LustreConfiguration)
  output <- .fsx$update_file_system_output()
  config <- get_config()
  svc <- .fsx$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fsx$operations$update_file_system <- fsx_update_file_system
