% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_bucket_website}
\alias{s3_put_bucket_website}
\title{Set the website configuration for a bucket}
\usage{
s3_put_bucket_website(Bucket, ContentMD5, WebsiteConfiguration)
}
\arguments{
\item{Bucket}{[required]}

\item{ContentMD5}{}

\item{WebsiteConfiguration}{[required]}
}
\description{
Set the website configuration for a bucket.
}
\section{Request syntax}{
\preformatted{svc$put_bucket_website(
  Bucket = "string",
  ContentMD5 = "string",
  WebsiteConfiguration = list(
    ErrorDocument = list(
      Key = "string"
    ),
    IndexDocument = list(
      Suffix = "string"
    ),
    RedirectAllRequestsTo = list(
      HostName = "string",
      Protocol = "http"|"https"
    ),
    RoutingRules = list(
      list(
        Condition = list(
          HttpErrorCodeReturnedEquals = "string",
          KeyPrefixEquals = "string"
        ),
        Redirect = list(
          HostName = "string",
          HttpRedirectCode = "string",
          Protocol = "http"|"https",
          ReplaceKeyPrefixWith = "string",
          ReplaceKeyWith = "string"
        )
      )
    )
  )
)
}
}

\examples{
# The following example adds website configuration to a bucket.
\donttest{svc$put_bucket_website(
  Bucket = "examplebucket",
  ContentMD5 = "",
  WebsiteConfiguration = list(
    ErrorDocument = list(
      Key = "error.html"
    ),
    IndexDocument = list(
      Suffix = "index.html"
    )
  )
)}

}
\keyword{internal}
