% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_object}
\alias{s3_get_object}
\title{Retrieves objects from Amazon S3}
\usage{
s3_get_object(Bucket, IfMatch, IfModifiedSince, IfNoneMatch,
  IfUnmodifiedSince, Key, Range, ResponseCacheControl,
  ResponseContentDisposition, ResponseContentEncoding,
  ResponseContentLanguage, ResponseContentType, ResponseExpires,
  VersionId, SSECustomerAlgorithm, SSECustomerKey, SSECustomerKeyMD5,
  RequestPayer, PartNumber)
}
\arguments{
\item{Bucket}{[required]}

\item{IfMatch}{Return the object only if its entity tag (ETag) is the same as the one
specified, otherwise return a 412 (precondition failed).}

\item{IfModifiedSince}{Return the object only if it has been modified since the specified time,
otherwise return a 304 (not modified).}

\item{IfNoneMatch}{Return the object only if its entity tag (ETag) is different from the
one specified, otherwise return a 304 (not modified).}

\item{IfUnmodifiedSince}{Return the object only if it has not been modified since the specified
time, otherwise return a 412 (precondition failed).}

\item{Key}{[required]}

\item{Range}{Downloads the specified range bytes of an object. For more information
about the HTTP Range header, go to
http://www.w3.org/Protocols/rfc2616/rfc2616-sec14.html\#sec14.35.}

\item{ResponseCacheControl}{Sets the Cache-Control header of the response.}

\item{ResponseContentDisposition}{Sets the Content-Disposition header of the response}

\item{ResponseContentEncoding}{Sets the Content-Encoding header of the response.}

\item{ResponseContentLanguage}{Sets the Content-Language header of the response.}

\item{ResponseContentType}{Sets the Content-Type header of the response.}

\item{ResponseExpires}{Sets the Expires header of the response.}

\item{VersionId}{VersionId used to reference a specific version of the object.}

\item{SSECustomerAlgorithm}{Specifies the algorithm to use to when encrypting the object (e.g.,
AES256).}

\item{SSECustomerKey}{Specifies the customer-provided encryption key for Amazon S3 to use in
encrypting data. This value is used to store the object and then it is
discarded; Amazon does not store the encryption key. The key must be
appropriate for use with the algorithm specified in the
x-amz-server-sideâ€‹-encryptionâ€‹-customer-algorithm header.}

\item{SSECustomerKeyMD5}{Specifies the 128-bit MD5 digest of the encryption key according to RFC
1321. Amazon S3 uses this header for a message integrity check to ensure
the encryption key was transmitted without error.}

\item{RequestPayer}{}

\item{PartNumber}{Part number of the object being read. This is a positive integer between
1 and 10,000. Effectively performs a 'ranged' GET request for the part
specified. Useful for downloading just a part of an object.}
}
\description{
Retrieves objects from Amazon S3.
}
\section{Request syntax}{
\preformatted{svc$get_object(
  Bucket = "string",
  IfMatch = "string",
  IfModifiedSince = as.POSIXct(
    "2015-01-01"
  ),
  IfNoneMatch = "string",
  IfUnmodifiedSince = as.POSIXct(
    "2015-01-01"
  ),
  Key = "string",
  Range = "string",
  ResponseCacheControl = "string",
  ResponseContentDisposition = "string",
  ResponseContentEncoding = "string",
  ResponseContentLanguage = "string",
  ResponseContentType = "string",
  ResponseExpires = as.POSIXct(
    "2015-01-01"
  ),
  VersionId = "string",
  SSECustomerAlgorithm = "string",
  SSECustomerKey = raw,
  SSECustomerKeyMD5 = "string",
  RequestPayer = "requester",
  PartNumber = 123
)
}
}

\examples{
# The following example retrieves an object for an S3 bucket.
\donttest{svc$get_object(
  Bucket = "examplebucket",
  Key = "HappyFace.jpg"
)}

# The following example retrieves an object for an S3 bucket. The request
# specifies the range header to retrieve a specific byte range.
\donttest{svc$get_object(
  Bucket = "examplebucket",
  Key = "SampleFile.txt",
  Range = "bytes=0-9"
)}

}
\keyword{internal}
