% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_put_object_acl}
\alias{s3_put_object_acl}
\title{uses the acl subresource to set the access control list (ACL)
permissions for an object that already exists in a bucket}
\usage{
s3_put_object_acl(ACL, AccessControlPolicy, Bucket, ContentMD5,
  GrantFullControl, GrantRead, GrantReadACP, GrantWrite, GrantWriteACP,
  Key, RequestPayer, VersionId)
}
\arguments{
\item{ACL}{The canned ACL to apply to the object.}

\item{AccessControlPolicy}{Contains the elements that set the ACL permissions for an object per
grantee.}

\item{Bucket}{[required]}

\item{ContentMD5}{}

\item{GrantFullControl}{Allows grantee the read, write, read ACP, and write ACP permissions on
the bucket.}

\item{GrantRead}{Allows grantee to list the objects in the bucket.}

\item{GrantReadACP}{Allows grantee to read the bucket ACL.}

\item{GrantWrite}{Allows grantee to create, overwrite, and delete any object in the
bucket.}

\item{GrantWriteACP}{Allows grantee to write the ACL for the applicable bucket.}

\item{Key}{[required]}

\item{RequestPayer}{}

\item{VersionId}{VersionId used to reference a specific version of the object.}
}
\description{
uses the acl subresource to set the access control list (ACL)
permissions for an object that already exists in a bucket
}
\section{Request syntax}{
\preformatted{svc$put_object_acl(
  ACL = "private"|"public-read"|"public-read-write"|"authenticated-read"|"aws-exec-read"|"bucket-owner-read"|"bucket-owner-full-control",
  AccessControlPolicy = list(
    Grants = list(
      list(
        Grantee = list(
          DisplayName = "string",
          EmailAddress = "string",
          ID = "string",
          Type = "CanonicalUser"|"AmazonCustomerByEmail"|"Group",
          URI = "string"
        ),
        Permission = "FULL_CONTROL"|"WRITE"|"WRITE_ACP"|"READ"|"READ_ACP"
      )
    ),
    Owner = list(
      DisplayName = "string",
      ID = "string"
    )
  ),
  Bucket = "string",
  ContentMD5 = "string",
  GrantFullControl = "string",
  GrantRead = "string",
  GrantReadACP = "string",
  GrantWrite = "string",
  GrantWriteACP = "string",
  Key = "string",
  RequestPayer = "requester",
  VersionId = "string"
)
}
}

\examples{
# The following example adds grants to an object ACL. The first permission
# grants user1 and user2 FULL_CONTROL and the AllUsers group READ
# permission.
\donttest{svc$put_object_acl(
  AccessControlPolicy = structure(
    list(),
    .Names = character(
      0
    )
  ),
  Bucket = "examplebucket",
  GrantFullControl = "emailaddress=user1@example.com,emailaddress=user2@example.com",
  GrantRead = "uri=http://acs.amazonaws.com/groups/global/AllUsers",
  Key = "HappyFace.jpg"
)}

}
\keyword{internal}
