% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_list_multipart_uploads}
\alias{s3_list_multipart_uploads}
\title{This operation lists in-progress multipart uploads}
\usage{
s3_list_multipart_uploads(Bucket, Delimiter, EncodingType, KeyMarker,
  MaxUploads, Prefix, UploadIdMarker)
}
\arguments{
\item{Bucket}{[required]}

\item{Delimiter}{Character you use to group keys.}

\item{EncodingType}{}

\item{KeyMarker}{Together with upload-id-marker, this parameter specifies the multipart
upload after which listing should begin.}

\item{MaxUploads}{Sets the maximum number of multipart uploads, from 1 to 1,000, to return
in the response body. 1,000 is the maximum number of uploads that can be
returned in a response.}

\item{Prefix}{Lists in-progress uploads only for those keys that begin with the
specified prefix.}

\item{UploadIdMarker}{Together with key-marker, specifies the multipart upload after which
listing should begin. If key-marker is not specified, the
upload-id-marker parameter is ignored.}
}
\description{
This operation lists in-progress multipart uploads.
}
\section{Request syntax}{
\preformatted{svc$list_multipart_uploads(
  Bucket = "string",
  Delimiter = "string",
  EncodingType = "url",
  KeyMarker = "string",
  MaxUploads = 123,
  Prefix = "string",
  UploadIdMarker = "string"
)
}
}

\examples{
# The following example specifies the upload-id-marker and key-marker from
# previous truncated response to retrieve next setup of multipart uploads.
\donttest{svc$list_multipart_uploads(
  Bucket = "examplebucket",
  KeyMarker = "nextkeyfrompreviousresponse",
  MaxUploads = "2",
  UploadIdMarker = "valuefrompreviousresponse"
)}

# The following example lists in-progress multipart uploads on a specific
# bucket.
\donttest{svc$list_multipart_uploads(
  Bucket = "examplebucket"
)}

}
\keyword{internal}
