% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/s3_operations.R
\name{s3_get_bucket_replication}
\alias{s3_get_bucket_replication}
\title{Returns the replication configuration of a bucket}
\usage{
s3_get_bucket_replication(Bucket, ExpectedBucketOwner)
}
\arguments{
\item{Bucket}{[required] The bucket name for which to get the replication information.}

\item{ExpectedBucketOwner}{The account id of the expected bucket owner. If the bucket is owned by a
different account, the request will fail with an HTTP
\verb{403 (Access Denied)} error.}
}
\description{
Returns the replication configuration of a bucket.

It can take a while to propagate the put or delete a replication
configuration to all Amazon S3 systems. Therefore, a get request soon
after put or delete can return a wrong result.

For information about replication configuration, see
\href{https://docs.aws.amazon.com/AmazonS3/latest/dev/replication.html}{Replication}
in the \emph{Amazon Simple Storage Service Developer Guide}.

This operation requires permissions for the
\code{s3:GetReplicationConfiguration} action. For more information about
permissions, see \href{https://docs.aws.amazon.com/AmazonS3/latest/dev/using-iam-policies.html}{Using Bucket Policies and User Policies}.

If you include the \code{Filter} element in a replication configuration, you
must also include the \code{DeleteMarkerReplication} and \code{Priority} elements.
The response also returns those elements.

For information about \code{GetBucketReplication} errors, see \href{https://docs.aws.amazon.com/AmazonS3/latest/API/ErrorResponses.html#ReplicationErrorCodeList}{List of replication-related error codes}

The following operations are related to \code{GetBucketReplication}:
\itemize{
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_PutBucketReplication.html}{PutBucketReplication}
\item \href{https://docs.aws.amazon.com/AmazonS3/latest/API/API_DeleteBucketReplication.html}{DeleteBucketReplication}
}
}
\section{Request syntax}{
\preformatted{svc$get_bucket_replication(
  Bucket = "string",
  ExpectedBucketOwner = "string"
)
}
}

\examples{
\dontrun{
# The following example returns replication configuration set on a bucket.
svc$get_bucket_replication(
  Bucket = "examplebucket"
)
}

}
\keyword{internal}
