% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fsx_operations.R
\name{fsx_describe_file_systems}
\alias{fsx_describe_file_systems}
\title{Returns the description of specific Amazon FSx file systems, if a
FileSystemIds value is provided for that file system}
\usage{
fsx_describe_file_systems(FileSystemIds, MaxResults, NextToken)
}
\arguments{
\item{FileSystemIds}{IDs of the file systems whose descriptions you want to retrieve
(String).}

\item{MaxResults}{Maximum number of file systems to return in the response (integer). This
parameter value must be greater than 0. The number of items that Amazon
FSx returns is the minimum of the \code{MaxResults} parameter specified in
the request and the service's internal maximum number of items per page.}

\item{NextToken}{Opaque pagination token returned from a previous \code{DescribeFileSystems}
operation (String). If a token present, the action continues the list
from where the returning call left off.}
}
\description{
Returns the description of specific Amazon FSx file systems, if a
\code{FileSystemIds} value is provided for that file system. Otherwise, it
returns descriptions of all file systems owned by your AWS account in
the AWS Region of the endpoint that you're calling.

When retrieving all file system descriptions, you can optionally specify
the \code{MaxResults} parameter to limit the number of descriptions in a
response. If more file system descriptions remain, Amazon FSx returns a
\code{NextToken} value in the response. In this case, send a later request
with the \code{NextToken} request parameter set to the value of \code{NextToken}
from the last response.

This action is used in an iterative process to retrieve a list of your
file system descriptions. \code{DescribeFileSystems} is called first without
a \code{NextToken}value. Then the action continues to be called with the
\code{NextToken} parameter set to the value of the last \code{NextToken} value
until a response has no \code{NextToken}.

When using this action, keep the following in mind:
\itemize{
\item The implementation might return fewer than \code{MaxResults} file system
descriptions while still including a \code{NextToken} value.
\item The order of file systems returned in the response of one
\code{DescribeFileSystems} call and the order of file systems returned
across the responses of a multicall iteration is unspecified.
}
}
\section{Request syntax}{
\preformatted{svc$describe_file_systems(
  FileSystemIds = list(
    "string"
  ),
  MaxResults = 123,
  NextToken = "string"
)
}
}

\examples{
\dontrun{
# This operation describes all of the Amazon FSx file systems in an
# account.
svc$describe_file_systems()
}

}
\keyword{internal}
