% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/macie2_operations.R
\name{macie2_test_custom_data_identifier}
\alias{macie2_test_custom_data_identifier}
\title{Tests criteria for a custom data identifier}
\usage{
macie2_test_custom_data_identifier(
  ignoreWords = NULL,
  keywords = NULL,
  maximumMatchDistance = NULL,
  regex,
  sampleText
)
}
\arguments{
\item{ignoreWords}{An array that lists specific character sequences (\emph{ignore words}) to
exclude from the results. If the text matched by the regular expression
contains any string in this array, Amazon Macie ignores it. The array
can contain as many as 10 ignore words. Each ignore word can contain
4-90 UTF-8 characters. Ignore words are case sensitive.}

\item{keywords}{An array that lists specific character sequences (\emph{keywords}), one of
which must precede and be within proximity (maximumMatchDistance) of the
regular expression to match. The array can contain as many as 50
keywords. Each keyword can contain 3-90 UTF-8 characters. Keywords
aren't case sensitive.}

\item{maximumMatchDistance}{The maximum number of characters that can exist between the end of at
least one complete character sequence specified by the keywords array
and the end of the text that matches the regex pattern. If a complete
keyword precedes all the text that matches the pattern and the keyword
is within the specified distance, Amazon Macie includes the result. The
distance can be 1-300 characters. The default value is 50.}

\item{regex}{[required] The regular expression (\emph{regex}) that defines the pattern to match. The
expression can contain as many as 512 characters.}

\item{sampleText}{[required] The sample text to inspect by using the custom data identifier. The text
can contain as many as 1,000 characters.}
}
\description{
Tests criteria for a custom data identifier.

See \url{https://www.paws-r-sdk.com/docs/macie2_test_custom_data_identifier/} for full documentation.
}
\keyword{internal}
