% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wafv2_operations.R
\name{wafv2_create_ip_set}
\alias{wafv2_create_ip_set}
\title{Creates an IPSet, which you use to identify web requests that originate
from specific IP addresses or ranges of IP addresses}
\usage{
wafv2_create_ip_set(
  Name,
  Scope,
  Description = NULL,
  IPAddressVersion,
  Addresses,
  Tags = NULL
)
}
\arguments{
\item{Name}{[required] The name of the IP set. You cannot change the name of an \code{IPSet} after
you create it.}

\item{Scope}{[required] Specifies whether this is for an Amazon CloudFront distribution or for a
regional application. A regional application can be an Application Load
Balancer (ALB), an Amazon API Gateway REST API, an AppSync GraphQL API,
an Amazon Cognito user pool, an App Runner service, or an Amazon Web
Services Verified Access instance.

To work with CloudFront, you must also specify the Region US East (N.
Virginia) as follows:
\itemize{
\item CLI - Specify the Region when you use the CloudFront scope:
\code{--scope=CLOUDFRONT --region=us-east-1}.
\item API and SDKs - For all calls, use the Region endpoint us-east-1.
}}

\item{Description}{A description of the IP set that helps with identification.}

\item{IPAddressVersion}{[required] The version of the IP addresses, either \code{IPV4} or \code{IPV6}.}

\item{Addresses}{[required] Contains an array of strings that specifies zero or more IP addresses or
blocks of IP addresses that you want WAF to inspect for in incoming
requests. All addresses must be specified using Classless Inter-Domain
Routing (CIDR) notation. WAF supports all IPv4 and IPv6 CIDR ranges
except for \verb{/0}.

Example address strings:
\itemize{
\item For requests that originated from the IP address 192.0.2.44, specify
\verb{192.0.2.44/32}.
\item For requests that originated from IP addresses from 192.0.2.0 to
192.0.2.255, specify \verb{192.0.2.0/24}.
\item For requests that originated from the IP address
1111:0000:0000:0000:0000:0000:0000:0111, specify
\code{1111:0000:0000:0000:0000:0000:0000:0111/128}.
\item For requests that originated from IP addresses
1111:0000:0000:0000:0000:0000:0000:0000 to
1111:0000:0000:0000:ffff:ffff:ffff:ffff, specify
\code{1111:0000:0000:0000:0000:0000:0000:0000/64}.
}

For more information about CIDR notation, see the Wikipedia entry
\href{https://en.wikipedia.org/wiki/Classless_Inter-Domain_Routing}{Classless Inter-Domain Routing}.

Example JSON \code{Addresses} specifications:
\itemize{
\item Empty array: \verb{"Addresses": []}
\item Array with one address: \verb{"Addresses": ["192.0.2.44/32"]}
\item Array with three addresses:
\verb{"Addresses": ["192.0.2.44/32", "192.0.2.0/24", "192.0.0.0/16"]}
\item INVALID specification: \verb{"Addresses": [""]} INVALID
}}

\item{Tags}{An array of key:value pairs to associate with the resource.}
}
\description{
Creates an IPSet, which you use to identify web requests that originate from specific IP addresses or ranges of IP addresses. For example, if you're receiving a lot of requests from a ranges of IP addresses, you can configure WAF to block them using an IPSet that lists those IP addresses.

See \url{https://www.paws-r-sdk.com/docs/wafv2_create_ip_set/} for full documentation.
}
\keyword{internal}
