% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pcaconnectorad_operations.R
\name{pcaconnectorad_create_template_group_access_control_entry}
\alias{pcaconnectorad_create_template_group_access_control_entry}
\title{Create a group access control entry}
\usage{
pcaconnectorad_create_template_group_access_control_entry(
  AccessRights,
  ClientToken = NULL,
  GroupDisplayName,
  GroupSecurityIdentifier,
  TemplateArn
)
}
\arguments{
\item{AccessRights}{[required] Allow or deny permissions for an Active Directory group to enroll or
autoenroll certificates for a template.}

\item{ClientToken}{Idempotency token.}

\item{GroupDisplayName}{[required] Name of the Active Directory group. This name does not need to match the
group name in Active Directory.}

\item{GroupSecurityIdentifier}{[required] Security identifier (SID) of the group object from Active Directory. The
SID starts with "S-".}

\item{TemplateArn}{[required] The Amazon Resource Name (ARN) that was returned when you called
\code{\link[=pcaconnectorad_create_template]{create_template}}.}
}
\description{
Create a group access control entry. Allow or deny Active Directory groups from enrolling and/or autoenrolling with the template based on the group security identifiers (SIDs).

See \url{https://www.paws-r-sdk.com/docs/pcaconnectorad_create_template_group_access_control_entry/} for full documentation.
}
\keyword{internal}
