% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fms_operations.R
\name{fms_list_third_party_firewall_firewall_policies}
\alias{fms_list_third_party_firewall_firewall_policies}
\title{Retrieves a list of all of the third-party firewall policies that are
associated with the third-party firewall administrator's account}
\usage{
fms_list_third_party_firewall_firewall_policies(
  ThirdPartyFirewall,
  NextToken = NULL,
  MaxResults
)
}
\arguments{
\item{ThirdPartyFirewall}{[required] The name of the third-party firewall vendor.}

\item{NextToken}{If the previous response included a \code{NextToken} element, the specified
third-party firewall vendor is associated with more third-party firewall
policies. To get more third-party firewall policies, submit another
\code{ListThirdPartyFirewallFirewallPoliciesRequest} request.

For the value of \code{NextToken}, specify the value of \code{NextToken} from the
previous response. If the previous response didn't include a \code{NextToken}
element, there are no more third-party firewall policies to get.}

\item{MaxResults}{[required] The maximum number of third-party firewall policies that you want
Firewall Manager to return. If the specified third-party firewall vendor
is associated with more than \code{MaxResults} firewall policies, the
response includes a \code{NextToken} element. \code{NextToken} contains an
encrypted token that identifies the first third-party firewall policies
that Firewall Manager will return if you submit another request.}
}
\description{
Retrieves a list of all of the third-party firewall policies that are associated with the third-party firewall administrator's account.

See \url{https://paws-r.github.io/docs/fms/list_third_party_firewall_firewall_policies.html} for full documentation.
}
\keyword{internal}
