% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentityprovider_operations.R
\name{cognitoidentityprovider_admin_link_provider_for_user}
\alias{cognitoidentityprovider_admin_link_provider_for_user}
\title{Links an existing user account in a user pool (DestinationUser) to an
identity from an external IdP (SourceUser) based on a specified
attribute name and value from the external IdP}
\usage{
cognitoidentityprovider_admin_link_provider_for_user(
  UserPoolId,
  DestinationUser,
  SourceUser
)
}
\arguments{
\item{UserPoolId}{[required] The user pool ID for the user pool.}

\item{DestinationUser}{[required] The existing user in the user pool that you want to assign to the
external IdP user account. This user can be a native (Username +
Password) Amazon Cognito user pools user or a federated user (for
example, a SAML or Facebook user). If the user doesn't exist, Amazon
Cognito generates an exception. Amazon Cognito returns this user when
the new user (with the linked IdP attribute) signs in.

For a native username + password user, the \code{ProviderAttributeValue} for
the \code{DestinationUser} should be the username in the user pool. For a
federated user, it should be the provider-specific \code{user_id}.

The \code{ProviderAttributeName} of the \code{DestinationUser} is ignored.

The \code{ProviderName} should be set to \code{Cognito} for users in Cognito user
pools.

All attributes in the DestinationUser profile must be mutable. If you
have assigned the user any immutable custom attributes, the operation
won't succeed.}

\item{SourceUser}{[required] An external IdP account for a user who doesn't exist yet in the user
pool. This user must be a federated user (for example, a SAML or
Facebook user), not another native user.

If the \code{SourceUser} is using a federated social IdP, such as Facebook,
Google, or Login with Amazon, you must set the \code{ProviderAttributeName}
to \code{Cognito_Subject}. For social IdPs, the \code{ProviderName} will be
\code{Facebook}, \code{Google}, or \code{LoginWithAmazon}, and Amazon Cognito will
automatically parse the Facebook, Google, and Login with Amazon tokens
for \code{id}, \code{sub}, and \code{user_id}, respectively. The
\code{ProviderAttributeValue} for the user must be the same value as the
\code{id}, \code{sub}, or \code{user_id} value found in the social IdP token.

For SAML, the \code{ProviderAttributeName} can be any value that matches a
claim in the SAML assertion. If you want to link SAML users based on the
subject of the SAML assertion, you should map the subject to a claim
through the SAML IdP and submit that claim name as the
\code{ProviderAttributeName}. If you set \code{ProviderAttributeName} to
\code{Cognito_Subject}, Amazon Cognito will automatically parse the default
unique identifier found in the subject from the SAML token.}
}
\description{
Links an existing user account in a user pool (\code{DestinationUser}) to an identity from an external IdP (\code{SourceUser}) based on a specified attribute name and value from the external IdP. This allows you to create a link from the existing user account to an external federated user identity that has not yet been used to sign in. You can then use the federated user identity to sign in as the existing user account.

See \url{https://paws-r.github.io/docs/cognitoidentityprovider/admin_link_provider_for_user.html} for full documentation.
}
\keyword{internal}
