# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include iamrolesanywhere_service.R
NULL

#' Creates a profile
#'
#' @description
#' Creates a profile. A profile is configuration resource to list the roles that RolesAnywhere service is trusted to assume. In addition, by applying a profile you can intersect permissions with IAM managed policies.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/create_profile.html](https://paws-r.github.io/docs/iamrolesanywhere/create_profile.html) for full documentation.
#'
#' @param durationSeconds The number of seconds the vended session credentials are valid for.
#' @param enabled Specifies whether the profile is enabled.
#' @param managedPolicyArns A list of managed policy ARNs that apply to the vended session
#' credentials.
#' @param name &#91;required&#93; The name of the profile.
#' @param requireInstanceProperties Specifies whether instance properties are required in
#' [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/)
#' requests with this profile.
#' @param roleArns &#91;required&#93; A list of IAM roles that this profile can assume in a
#' [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/)
#' operation.
#' @param sessionPolicy A session policy that applies to the trust boundary of the vended
#' session credentials.
#' @param tags The tags to attach to the profile.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_create_profile
iamrolesanywhere_create_profile <- function(durationSeconds = NULL, enabled = NULL, managedPolicyArns = NULL, name, requireInstanceProperties = NULL, roleArns, sessionPolicy = NULL, tags = NULL) {
  op <- new_operation(
    name = "CreateProfile",
    http_method = "POST",
    http_path = "/profiles",
    paginator = list()
  )
  input <- .iamrolesanywhere$create_profile_input(durationSeconds = durationSeconds, enabled = enabled, managedPolicyArns = managedPolicyArns, name = name, requireInstanceProperties = requireInstanceProperties, roleArns = roleArns, sessionPolicy = sessionPolicy, tags = tags)
  output <- .iamrolesanywhere$create_profile_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$create_profile <- iamrolesanywhere_create_profile

#' Creates a trust anchor
#'
#' @description
#' Creates a trust anchor. You establish trust between IAM Roles Anywhere and your certificate authority (CA) by configuring a trust anchor. A Trust Anchor is defined either as a reference to a AWS Certificate Manager Private Certificate Authority (ACM PCA), or by uploading a Certificate Authority (CA) certificate. Your AWS workloads can authenticate with the trust anchor using certificates issued by the trusted Certificate Authority (CA) in exchange for temporary AWS credentials.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/create_trust_anchor.html](https://paws-r.github.io/docs/iamrolesanywhere/create_trust_anchor.html) for full documentation.
#'
#' @param enabled Specifies whether the trust anchor is enabled.
#' @param name &#91;required&#93; The name of the trust anchor.
#' @param source &#91;required&#93; The trust anchor type and its related certificate data.
#' @param tags The tags to attach to the trust anchor.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_create_trust_anchor
iamrolesanywhere_create_trust_anchor <- function(enabled = NULL, name, source, tags = NULL) {
  op <- new_operation(
    name = "CreateTrustAnchor",
    http_method = "POST",
    http_path = "/trustanchors",
    paginator = list()
  )
  input <- .iamrolesanywhere$create_trust_anchor_input(enabled = enabled, name = name, source = source, tags = tags)
  output <- .iamrolesanywhere$create_trust_anchor_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$create_trust_anchor <- iamrolesanywhere_create_trust_anchor

#' Deletes a certificate revocation list (CRL)
#'
#' @description
#' Deletes a certificate revocation list (CRL).
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/delete_crl.html](https://paws-r.github.io/docs/iamrolesanywhere/delete_crl.html) for full documentation.
#'
#' @param crlId &#91;required&#93; The unique identifier of the certificate revocation list (CRL).
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_delete_crl
iamrolesanywhere_delete_crl <- function(crlId) {
  op <- new_operation(
    name = "DeleteCrl",
    http_method = "DELETE",
    http_path = "/crl/{crlId}",
    paginator = list()
  )
  input <- .iamrolesanywhere$delete_crl_input(crlId = crlId)
  output <- .iamrolesanywhere$delete_crl_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$delete_crl <- iamrolesanywhere_delete_crl

#' Deletes a profile
#'
#' @description
#' Deletes a profile.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/delete_profile.html](https://paws-r.github.io/docs/iamrolesanywhere/delete_profile.html) for full documentation.
#'
#' @param profileId &#91;required&#93; The unique identifier of the profile.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_delete_profile
iamrolesanywhere_delete_profile <- function(profileId) {
  op <- new_operation(
    name = "DeleteProfile",
    http_method = "DELETE",
    http_path = "/profile/{profileId}",
    paginator = list()
  )
  input <- .iamrolesanywhere$delete_profile_input(profileId = profileId)
  output <- .iamrolesanywhere$delete_profile_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$delete_profile <- iamrolesanywhere_delete_profile

#' Deletes a trust anchor
#'
#' @description
#' Deletes a trust anchor.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/delete_trust_anchor.html](https://paws-r.github.io/docs/iamrolesanywhere/delete_trust_anchor.html) for full documentation.
#'
#' @param trustAnchorId &#91;required&#93; The unique identifier of the trust anchor.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_delete_trust_anchor
iamrolesanywhere_delete_trust_anchor <- function(trustAnchorId) {
  op <- new_operation(
    name = "DeleteTrustAnchor",
    http_method = "DELETE",
    http_path = "/trustanchor/{trustAnchorId}",
    paginator = list()
  )
  input <- .iamrolesanywhere$delete_trust_anchor_input(trustAnchorId = trustAnchorId)
  output <- .iamrolesanywhere$delete_trust_anchor_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$delete_trust_anchor <- iamrolesanywhere_delete_trust_anchor

#' Disables a certificate revocation list (CRL)
#'
#' @description
#' Disables a certificate revocation list (CRL).
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/disable_crl.html](https://paws-r.github.io/docs/iamrolesanywhere/disable_crl.html) for full documentation.
#'
#' @param crlId &#91;required&#93; The unique identifier of the certificate revocation list (CRL).
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_disable_crl
iamrolesanywhere_disable_crl <- function(crlId) {
  op <- new_operation(
    name = "DisableCrl",
    http_method = "POST",
    http_path = "/crl/{crlId}/disable",
    paginator = list()
  )
  input <- .iamrolesanywhere$disable_crl_input(crlId = crlId)
  output <- .iamrolesanywhere$disable_crl_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$disable_crl <- iamrolesanywhere_disable_crl

#' Disables a profile
#'
#' @description
#' Disables a profile. When disabled, [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/) requests with this profile fail.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/disable_profile.html](https://paws-r.github.io/docs/iamrolesanywhere/disable_profile.html) for full documentation.
#'
#' @param profileId &#91;required&#93; The unique identifier of the profile.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_disable_profile
iamrolesanywhere_disable_profile <- function(profileId) {
  op <- new_operation(
    name = "DisableProfile",
    http_method = "POST",
    http_path = "/profile/{profileId}/disable",
    paginator = list()
  )
  input <- .iamrolesanywhere$disable_profile_input(profileId = profileId)
  output <- .iamrolesanywhere$disable_profile_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$disable_profile <- iamrolesanywhere_disable_profile

#' Disables a trust anchor
#'
#' @description
#' Disables a trust anchor. When disabled, [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/) requests specifying this trust anchor are unauthorized.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/disable_trust_anchor.html](https://paws-r.github.io/docs/iamrolesanywhere/disable_trust_anchor.html) for full documentation.
#'
#' @param trustAnchorId &#91;required&#93; The unique identifier of the trust anchor.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_disable_trust_anchor
iamrolesanywhere_disable_trust_anchor <- function(trustAnchorId) {
  op <- new_operation(
    name = "DisableTrustAnchor",
    http_method = "POST",
    http_path = "/trustanchor/{trustAnchorId}/disable",
    paginator = list()
  )
  input <- .iamrolesanywhere$disable_trust_anchor_input(trustAnchorId = trustAnchorId)
  output <- .iamrolesanywhere$disable_trust_anchor_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$disable_trust_anchor <- iamrolesanywhere_disable_trust_anchor

#' Enables a certificate revocation list (CRL)
#'
#' @description
#' Enables a certificate revocation list (CRL). When enabled, certificates stored in the CRL are unauthorized to receive session credentials.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/enable_crl.html](https://paws-r.github.io/docs/iamrolesanywhere/enable_crl.html) for full documentation.
#'
#' @param crlId &#91;required&#93; The unique identifier of the certificate revocation list (CRL).
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_enable_crl
iamrolesanywhere_enable_crl <- function(crlId) {
  op <- new_operation(
    name = "EnableCrl",
    http_method = "POST",
    http_path = "/crl/{crlId}/enable",
    paginator = list()
  )
  input <- .iamrolesanywhere$enable_crl_input(crlId = crlId)
  output <- .iamrolesanywhere$enable_crl_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$enable_crl <- iamrolesanywhere_enable_crl

#' Enables the roles in a profile to receive session credentials in
#' CreateSession
#'
#' @description
#' Enables the roles in a profile to receive session credentials in [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/).
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/enable_profile.html](https://paws-r.github.io/docs/iamrolesanywhere/enable_profile.html) for full documentation.
#'
#' @param profileId &#91;required&#93; The unique identifier of the profile.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_enable_profile
iamrolesanywhere_enable_profile <- function(profileId) {
  op <- new_operation(
    name = "EnableProfile",
    http_method = "POST",
    http_path = "/profile/{profileId}/enable",
    paginator = list()
  )
  input <- .iamrolesanywhere$enable_profile_input(profileId = profileId)
  output <- .iamrolesanywhere$enable_profile_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$enable_profile <- iamrolesanywhere_enable_profile

#' Enables a trust anchor
#'
#' @description
#' Enables a trust anchor. When enabled, certificates in the trust anchor chain are authorized for trust validation.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/enable_trust_anchor.html](https://paws-r.github.io/docs/iamrolesanywhere/enable_trust_anchor.html) for full documentation.
#'
#' @param trustAnchorId &#91;required&#93; The unique identifier of the trust anchor.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_enable_trust_anchor
iamrolesanywhere_enable_trust_anchor <- function(trustAnchorId) {
  op <- new_operation(
    name = "EnableTrustAnchor",
    http_method = "POST",
    http_path = "/trustanchor/{trustAnchorId}/enable",
    paginator = list()
  )
  input <- .iamrolesanywhere$enable_trust_anchor_input(trustAnchorId = trustAnchorId)
  output <- .iamrolesanywhere$enable_trust_anchor_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$enable_trust_anchor <- iamrolesanywhere_enable_trust_anchor

#' Gets a certificate revocation list (CRL)
#'
#' @description
#' Gets a certificate revocation list (CRL).
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/get_crl.html](https://paws-r.github.io/docs/iamrolesanywhere/get_crl.html) for full documentation.
#'
#' @param crlId &#91;required&#93; The unique identifier of the certificate revocation list (CRL).
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_get_crl
iamrolesanywhere_get_crl <- function(crlId) {
  op <- new_operation(
    name = "GetCrl",
    http_method = "GET",
    http_path = "/crl/{crlId}",
    paginator = list()
  )
  input <- .iamrolesanywhere$get_crl_input(crlId = crlId)
  output <- .iamrolesanywhere$get_crl_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$get_crl <- iamrolesanywhere_get_crl

#' Gets a profile
#'
#' @description
#' Gets a profile.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/get_profile.html](https://paws-r.github.io/docs/iamrolesanywhere/get_profile.html) for full documentation.
#'
#' @param profileId &#91;required&#93; The unique identifier of the profile.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_get_profile
iamrolesanywhere_get_profile <- function(profileId) {
  op <- new_operation(
    name = "GetProfile",
    http_method = "GET",
    http_path = "/profile/{profileId}",
    paginator = list()
  )
  input <- .iamrolesanywhere$get_profile_input(profileId = profileId)
  output <- .iamrolesanywhere$get_profile_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$get_profile <- iamrolesanywhere_get_profile

#' Gets a Subject
#'
#' @description
#' Gets a Subject. A Subject associates a certificate identity with authentication attempts by CreateSession. The Subject resources stores audit information such as status of the last authentication attempt, the certificate data used in the attempt, and the last time the associated identity attempted authentication.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/get_subject.html](https://paws-r.github.io/docs/iamrolesanywhere/get_subject.html) for full documentation.
#'
#' @param subjectId &#91;required&#93; The unique identifier of the subject.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_get_subject
iamrolesanywhere_get_subject <- function(subjectId) {
  op <- new_operation(
    name = "GetSubject",
    http_method = "GET",
    http_path = "/subject/{subjectId}",
    paginator = list()
  )
  input <- .iamrolesanywhere$get_subject_input(subjectId = subjectId)
  output <- .iamrolesanywhere$get_subject_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$get_subject <- iamrolesanywhere_get_subject

#' Gets a trust anchor
#'
#' @description
#' Gets a trust anchor.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/get_trust_anchor.html](https://paws-r.github.io/docs/iamrolesanywhere/get_trust_anchor.html) for full documentation.
#'
#' @param trustAnchorId &#91;required&#93; The unique identifier of the trust anchor.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_get_trust_anchor
iamrolesanywhere_get_trust_anchor <- function(trustAnchorId) {
  op <- new_operation(
    name = "GetTrustAnchor",
    http_method = "GET",
    http_path = "/trustanchor/{trustAnchorId}",
    paginator = list()
  )
  input <- .iamrolesanywhere$get_trust_anchor_input(trustAnchorId = trustAnchorId)
  output <- .iamrolesanywhere$get_trust_anchor_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$get_trust_anchor <- iamrolesanywhere_get_trust_anchor

#' Imports the certificate revocation list (CRL)
#'
#' @description
#' Imports the certificate revocation list (CRL). CRl is a list of certificates that have been revoked by the issuing certificate Authority (CA). IAM Roles Anywhere validates against the crl list before issuing credentials.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/import_crl.html](https://paws-r.github.io/docs/iamrolesanywhere/import_crl.html) for full documentation.
#'
#' @param crlData &#91;required&#93; The x509 v3 specified certificate revocation list
#' @param enabled Specifies whether the certificate revocation list (CRL) is enabled.
#' @param name &#91;required&#93; The name of the certificate revocation list (CRL).
#' @param tags A list of tags to attach to the certificate revocation list (CRL).
#' @param trustAnchorArn &#91;required&#93; The ARN of the TrustAnchor the certificate revocation list (CRL) will
#' provide revocation for.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_import_crl
iamrolesanywhere_import_crl <- function(crlData, enabled = NULL, name, tags = NULL, trustAnchorArn) {
  op <- new_operation(
    name = "ImportCrl",
    http_method = "POST",
    http_path = "/crls",
    paginator = list()
  )
  input <- .iamrolesanywhere$import_crl_input(crlData = crlData, enabled = enabled, name = name, tags = tags, trustAnchorArn = trustAnchorArn)
  output <- .iamrolesanywhere$import_crl_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$import_crl <- iamrolesanywhere_import_crl

#' Lists all Crls in the authenticated account and Amazon Web Services
#' Region
#'
#' @description
#' Lists all Crls in the authenticated account and Amazon Web Services Region.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/list_crls.html](https://paws-r.github.io/docs/iamrolesanywhere/list_crls.html) for full documentation.
#'
#' @param nextToken A token that indicates where the output should continue from, if a
#' previous operation did not show all results. To get the next results,
#' call the operation again with this value.
#' @param pageSize The number of resources in the paginated list.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_list_crls
iamrolesanywhere_list_crls <- function(nextToken = NULL, pageSize = NULL) {
  op <- new_operation(
    name = "ListCrls",
    http_method = "GET",
    http_path = "/crls",
    paginator = list()
  )
  input <- .iamrolesanywhere$list_crls_input(nextToken = nextToken, pageSize = pageSize)
  output <- .iamrolesanywhere$list_crls_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$list_crls <- iamrolesanywhere_list_crls

#' Lists all profiles in the authenticated account and Amazon Web Services
#' Region
#'
#' @description
#' Lists all profiles in the authenticated account and Amazon Web Services Region.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/list_profiles.html](https://paws-r.github.io/docs/iamrolesanywhere/list_profiles.html) for full documentation.
#'
#' @param nextToken A token that indicates where the output should continue from, if a
#' previous operation did not show all results. To get the next results,
#' call the operation again with this value.
#' @param pageSize The number of resources in the paginated list.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_list_profiles
iamrolesanywhere_list_profiles <- function(nextToken = NULL, pageSize = NULL) {
  op <- new_operation(
    name = "ListProfiles",
    http_method = "GET",
    http_path = "/profiles",
    paginator = list()
  )
  input <- .iamrolesanywhere$list_profiles_input(nextToken = nextToken, pageSize = pageSize)
  output <- .iamrolesanywhere$list_profiles_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$list_profiles <- iamrolesanywhere_list_profiles

#' Lists the subjects in the authenticated account and Amazon Web Services
#' Region
#'
#' @description
#' Lists the subjects in the authenticated account and Amazon Web Services Region.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/list_subjects.html](https://paws-r.github.io/docs/iamrolesanywhere/list_subjects.html) for full documentation.
#'
#' @param nextToken A token that indicates where the output should continue from, if a
#' previous operation did not show all results. To get the next results,
#' call the operation again with this value.
#' @param pageSize The number of resources in the paginated list.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_list_subjects
iamrolesanywhere_list_subjects <- function(nextToken = NULL, pageSize = NULL) {
  op <- new_operation(
    name = "ListSubjects",
    http_method = "GET",
    http_path = "/subjects",
    paginator = list()
  )
  input <- .iamrolesanywhere$list_subjects_input(nextToken = nextToken, pageSize = pageSize)
  output <- .iamrolesanywhere$list_subjects_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$list_subjects <- iamrolesanywhere_list_subjects

#' Lists the tags attached to the resource
#'
#' @description
#' Lists the tags attached to the resource.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/list_tags_for_resource.html](https://paws-r.github.io/docs/iamrolesanywhere/list_tags_for_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_list_tags_for_resource
iamrolesanywhere_list_tags_for_resource <- function(resourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "GET",
    http_path = "/ListTagsForResource",
    paginator = list()
  )
  input <- .iamrolesanywhere$list_tags_for_resource_input(resourceArn = resourceArn)
  output <- .iamrolesanywhere$list_tags_for_resource_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$list_tags_for_resource <- iamrolesanywhere_list_tags_for_resource

#' Lists the trust anchors in the authenticated account and Amazon Web
#' Services Region
#'
#' @description
#' Lists the trust anchors in the authenticated account and Amazon Web Services Region.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/list_trust_anchors.html](https://paws-r.github.io/docs/iamrolesanywhere/list_trust_anchors.html) for full documentation.
#'
#' @param nextToken A token that indicates where the output should continue from, if a
#' previous operation did not show all results. To get the next results,
#' call the operation again with this value.
#' @param pageSize The number of resources in the paginated list.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_list_trust_anchors
iamrolesanywhere_list_trust_anchors <- function(nextToken = NULL, pageSize = NULL) {
  op <- new_operation(
    name = "ListTrustAnchors",
    http_method = "GET",
    http_path = "/trustanchors",
    paginator = list()
  )
  input <- .iamrolesanywhere$list_trust_anchors_input(nextToken = nextToken, pageSize = pageSize)
  output <- .iamrolesanywhere$list_trust_anchors_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$list_trust_anchors <- iamrolesanywhere_list_trust_anchors

#' Attaches tags to a resource
#'
#' @description
#' Attaches tags to a resource.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/tag_resource.html](https://paws-r.github.io/docs/iamrolesanywhere/tag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource.
#' @param tags &#91;required&#93; The tags to attach to the resource.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_tag_resource
iamrolesanywhere_tag_resource <- function(resourceArn, tags) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/TagResource",
    paginator = list()
  )
  input <- .iamrolesanywhere$tag_resource_input(resourceArn = resourceArn, tags = tags)
  output <- .iamrolesanywhere$tag_resource_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$tag_resource <- iamrolesanywhere_tag_resource

#' Removes tags from the resource
#'
#' @description
#' Removes tags from the resource.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/untag_resource.html](https://paws-r.github.io/docs/iamrolesanywhere/untag_resource.html) for full documentation.
#'
#' @param resourceArn &#91;required&#93; The ARN of the resource.
#' @param tagKeys &#91;required&#93; A list of keys. Tag keys are the unique identifiers of tags.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_untag_resource
iamrolesanywhere_untag_resource <- function(resourceArn, tagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/UntagResource",
    paginator = list()
  )
  input <- .iamrolesanywhere$untag_resource_input(resourceArn = resourceArn, tagKeys = tagKeys)
  output <- .iamrolesanywhere$untag_resource_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$untag_resource <- iamrolesanywhere_untag_resource

#' Updates the certificate revocation list (CRL)
#'
#' @description
#' Updates the certificate revocation list (CRL). CRl is a list of certificates that have been revoked by the issuing certificate Authority (CA). IAM Roles Anywhere validates against the crl list before issuing credentials.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/update_crl.html](https://paws-r.github.io/docs/iamrolesanywhere/update_crl.html) for full documentation.
#'
#' @param crlData The x509 v3 specified certificate revocation list
#' @param crlId &#91;required&#93; The unique identifier of the certificate revocation list (CRL).
#' @param name The name of the Crl.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_update_crl
iamrolesanywhere_update_crl <- function(crlData = NULL, crlId, name = NULL) {
  op <- new_operation(
    name = "UpdateCrl",
    http_method = "PATCH",
    http_path = "/crl/{crlId}",
    paginator = list()
  )
  input <- .iamrolesanywhere$update_crl_input(crlData = crlData, crlId = crlId, name = name)
  output <- .iamrolesanywhere$update_crl_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$update_crl <- iamrolesanywhere_update_crl

#' Updates the profile
#'
#' @description
#' Updates the profile. A profile is configuration resource to list the roles that RolesAnywhere service is trusted to assume. In addition, by applying a profile you can scope-down permissions with IAM managed policies.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/update_profile.html](https://paws-r.github.io/docs/iamrolesanywhere/update_profile.html) for full documentation.
#'
#' @param durationSeconds The number of seconds the vended session credentials are valid for.
#' @param managedPolicyArns A list of managed policy ARNs that apply to the vended session
#' credentials.
#' @param name The name of the profile.
#' @param profileId &#91;required&#93; The unique identifier of the profile.
#' @param roleArns A list of IAM roles that this profile can assume in a
#' [CreateSession](https://docs.aws.amazon.com/rolesanywhere/latest/APIReference/)
#' operation.
#' @param sessionPolicy A session policy that applies to the trust boundary of the vended
#' session credentials.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_update_profile
iamrolesanywhere_update_profile <- function(durationSeconds = NULL, managedPolicyArns = NULL, name = NULL, profileId, roleArns = NULL, sessionPolicy = NULL) {
  op <- new_operation(
    name = "UpdateProfile",
    http_method = "PATCH",
    http_path = "/profile/{profileId}",
    paginator = list()
  )
  input <- .iamrolesanywhere$update_profile_input(durationSeconds = durationSeconds, managedPolicyArns = managedPolicyArns, name = name, profileId = profileId, roleArns = roleArns, sessionPolicy = sessionPolicy)
  output <- .iamrolesanywhere$update_profile_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$update_profile <- iamrolesanywhere_update_profile

#' Updates the trust anchor
#'
#' @description
#' Updates the trust anchor.You establish trust between IAM Roles Anywhere and your certificate authority (CA) by configuring a trust anchor. A Trust Anchor is defined either as a reference to a AWS Certificate Manager Private Certificate Authority (ACM PCA), or by uploading a Certificate Authority (CA) certificate. Your AWS workloads can authenticate with the trust anchor using certificates issued by the trusted Certificate Authority (CA) in exchange for temporary AWS credentials.
#'
#' See [https://paws-r.github.io/docs/iamrolesanywhere/update_trust_anchor.html](https://paws-r.github.io/docs/iamrolesanywhere/update_trust_anchor.html) for full documentation.
#'
#' @param name The name of the trust anchor.
#' @param source The trust anchor type and its related certificate data.
#' @param trustAnchorId &#91;required&#93; The unique identifier of the trust anchor.
#'
#' @keywords internal
#'
#' @rdname iamrolesanywhere_update_trust_anchor
iamrolesanywhere_update_trust_anchor <- function(name = NULL, source = NULL, trustAnchorId) {
  op <- new_operation(
    name = "UpdateTrustAnchor",
    http_method = "PATCH",
    http_path = "/trustanchor/{trustAnchorId}",
    paginator = list()
  )
  input <- .iamrolesanywhere$update_trust_anchor_input(name = name, source = source, trustAnchorId = trustAnchorId)
  output <- .iamrolesanywhere$update_trust_anchor_output()
  config <- get_config()
  svc <- .iamrolesanywhere$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.iamrolesanywhere$operations$update_trust_anchor <- iamrolesanywhere_update_trust_anchor
