# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common get_config new_operation new_request send_request
#' @include fms_service.R
NULL

#' Sets the AWS Firewall Manager administrator account
#'
#' Sets the AWS Firewall Manager administrator account. AWS Firewall
#' Manager must be associated with the master account of your AWS
#' organization or associated with a member account that has the
#' appropriate permissions. If the account ID that you submit is not an AWS
#' Organizations master account, AWS Firewall Manager will set the
#' appropriate permissions for the given member account.
#' 
#' The account that you associate with AWS Firewall Manager is called the
#' AWS Firewall Manager administrator account.
#'
#' @usage
#' fms_associate_admin_account(AdminAccount)
#'
#' @param AdminAccount &#91;required&#93; The AWS account ID to associate with AWS Firewall Manager as the AWS
#' Firewall Manager administrator account. This can be an AWS Organizations
#' master account or a member account. For more information about AWS
#' Organizations and master accounts, see [Managing the AWS Accounts in
#' Your
#' Organization](https://docs.aws.amazon.com/organizations/latest/userguide/orgs_manage_accounts.html).
#'
#' @section Request syntax:
#' ```
#' svc$associate_admin_account(
#'   AdminAccount = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_associate_admin_account
fms_associate_admin_account <- function(AdminAccount) {
  op <- new_operation(
    name = "AssociateAdminAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$associate_admin_account_input(AdminAccount = AdminAccount)
  output <- .fms$associate_admin_account_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$associate_admin_account <- fms_associate_admin_account

#' Deletes an AWS Firewall Manager association with the IAM role and the
#' Amazon Simple Notification Service (SNS) topic that is used to record
#' AWS Firewall Manager SNS logs
#'
#' Deletes an AWS Firewall Manager association with the IAM role and the
#' Amazon Simple Notification Service (SNS) topic that is used to record
#' AWS Firewall Manager SNS logs.
#'
#' @usage
#' fms_delete_notification_channel()
#'
#' @section Request syntax:
#' ```
#' svc$delete_notification_channel()
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_delete_notification_channel
fms_delete_notification_channel <- function() {
  op <- new_operation(
    name = "DeleteNotificationChannel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$delete_notification_channel_input()
  output <- .fms$delete_notification_channel_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$delete_notification_channel <- fms_delete_notification_channel

#' Permanently deletes an AWS Firewall Manager policy
#'
#' Permanently deletes an AWS Firewall Manager policy.
#'
#' @usage
#' fms_delete_policy(PolicyId, DeleteAllPolicyResources)
#'
#' @param PolicyId &#91;required&#93; The ID of the policy that you want to delete. `PolicyId` is returned by
#' `PutPolicy` and by `ListPolicies`.
#' @param DeleteAllPolicyResources If `True`, the request performs cleanup according to the policy type.
#' 
#' For AWS WAF and Shield Advanced policies, the cleanup does the
#' following:
#' 
#' -   Deletes rule groups created by AWS Firewall Manager
#' 
#' -   Removes web ACLs from in-scope resources
#' 
#' -   Deletes web ACLs that contain no rules or rule groups
#' 
#' For security group policies, the cleanup does the following for each
#' security group in the policy:
#' 
#' -   Disassociates the security group from in-scope resources
#' 
#' -   Deletes the security group if it was created through Firewall
#'     Manager and if it\'s no longer associated with any resources through
#'     another policy
#' 
#' After the cleanup, in-scope resources are no longer protected by web
#' ACLs in this policy. Protection of out-of-scope resources remains
#' unchanged. Scope is determined by tags that you create and accounts that
#' you associate with the policy. When creating the policy, if you specify
#' that only resources in specific accounts or with specific tags are in
#' scope of the policy, those accounts and resources are handled by the
#' policy. All others are out of scope. If you don\'t specify tags or
#' accounts, all resources are in scope.
#'
#' @section Request syntax:
#' ```
#' svc$delete_policy(
#'   PolicyId = "string",
#'   DeleteAllPolicyResources = TRUE|FALSE
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_delete_policy
fms_delete_policy <- function(PolicyId, DeleteAllPolicyResources = NULL) {
  op <- new_operation(
    name = "DeletePolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$delete_policy_input(PolicyId = PolicyId, DeleteAllPolicyResources = DeleteAllPolicyResources)
  output <- .fms$delete_policy_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$delete_policy <- fms_delete_policy

#' Disassociates the account that has been set as the AWS Firewall Manager
#' administrator account
#'
#' Disassociates the account that has been set as the AWS Firewall Manager
#' administrator account. To set a different account as the administrator
#' account, you must submit an `AssociateAdminAccount` request.
#'
#' @usage
#' fms_disassociate_admin_account()
#'
#' @section Request syntax:
#' ```
#' svc$disassociate_admin_account()
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_disassociate_admin_account
fms_disassociate_admin_account <- function() {
  op <- new_operation(
    name = "DisassociateAdminAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$disassociate_admin_account_input()
  output <- .fms$disassociate_admin_account_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$disassociate_admin_account <- fms_disassociate_admin_account

#' Returns the AWS Organizations master account that is associated with AWS
#' Firewall Manager as the AWS Firewall Manager administrator
#'
#' Returns the AWS Organizations master account that is associated with AWS
#' Firewall Manager as the AWS Firewall Manager administrator.
#'
#' @usage
#' fms_get_admin_account()
#'
#' @section Request syntax:
#' ```
#' svc$get_admin_account()
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_get_admin_account
fms_get_admin_account <- function() {
  op <- new_operation(
    name = "GetAdminAccount",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$get_admin_account_input()
  output <- .fms$get_admin_account_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$get_admin_account <- fms_get_admin_account

#' Returns detailed compliance information about the specified member
#' account
#'
#' Returns detailed compliance information about the specified member
#' account. Details include resources that are in and out of compliance
#' with the specified policy. Resources are considered noncompliant for AWS
#' WAF and Shield Advanced policies if the specified policy has not been
#' applied to them. Resources are considered noncompliant for security
#' group policies if they are in scope of the policy, they violate one or
#' more of the policy rules, and remediation is disabled or not possible.
#'
#' @usage
#' fms_get_compliance_detail(PolicyId, MemberAccount)
#'
#' @param PolicyId &#91;required&#93; The ID of the policy that you want to get the details for. `PolicyId` is
#' returned by `PutPolicy` and by `ListPolicies`.
#' @param MemberAccount &#91;required&#93; The AWS account that owns the resources that you want to get the details
#' for.
#'
#' @section Request syntax:
#' ```
#' svc$get_compliance_detail(
#'   PolicyId = "string",
#'   MemberAccount = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_get_compliance_detail
fms_get_compliance_detail <- function(PolicyId, MemberAccount) {
  op <- new_operation(
    name = "GetComplianceDetail",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$get_compliance_detail_input(PolicyId = PolicyId, MemberAccount = MemberAccount)
  output <- .fms$get_compliance_detail_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$get_compliance_detail <- fms_get_compliance_detail

#' Information about the Amazon Simple Notification Service (SNS) topic
#' that is used to record AWS Firewall Manager SNS logs
#'
#' Information about the Amazon Simple Notification Service (SNS) topic
#' that is used to record AWS Firewall Manager SNS logs.
#'
#' @usage
#' fms_get_notification_channel()
#'
#' @section Request syntax:
#' ```
#' svc$get_notification_channel()
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_get_notification_channel
fms_get_notification_channel <- function() {
  op <- new_operation(
    name = "GetNotificationChannel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$get_notification_channel_input()
  output <- .fms$get_notification_channel_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$get_notification_channel <- fms_get_notification_channel

#' Returns information about the specified AWS Firewall Manager policy
#'
#' Returns information about the specified AWS Firewall Manager policy.
#'
#' @usage
#' fms_get_policy(PolicyId)
#'
#' @param PolicyId &#91;required&#93; The ID of the AWS Firewall Manager policy that you want the details for.
#'
#' @section Request syntax:
#' ```
#' svc$get_policy(
#'   PolicyId = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_get_policy
fms_get_policy <- function(PolicyId) {
  op <- new_operation(
    name = "GetPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$get_policy_input(PolicyId = PolicyId)
  output <- .fms$get_policy_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$get_policy <- fms_get_policy

#' If you created a Shield Advanced policy, returns policy-level attack
#' summary information in the event of a potential DDoS attack
#'
#' If you created a Shield Advanced policy, returns policy-level attack
#' summary information in the event of a potential DDoS attack. Other
#' policy types are currently unsupported.
#'
#' @usage
#' fms_get_protection_status(PolicyId, MemberAccountId, StartTime, EndTime,
#'   NextToken, MaxResults)
#'
#' @param PolicyId &#91;required&#93; The ID of the policy for which you want to get the attack information.
#' @param MemberAccountId The AWS account that is in scope of the policy that you want to get the
#' details for.
#' @param StartTime The start of the time period to query for the attacks. This is a
#' `timestamp` type. The request syntax listing indicates a `number` type
#' because the default used by AWS Firewall Manager is Unix time in
#' seconds. However, any valid `timestamp` format is allowed.
#' @param EndTime The end of the time period to query for the attacks. This is a
#' `timestamp` type. The request syntax listing indicates a `number` type
#' because the default used by AWS Firewall Manager is Unix time in
#' seconds. However, any valid `timestamp` format is allowed.
#' @param NextToken If you specify a value for `MaxResults` and you have more objects than
#' the number that you specify for `MaxResults`, AWS Firewall Manager
#' returns a `NextToken` value in the response, which you can use to
#' retrieve another group of objects. For the second and subsequent
#' `GetProtectionStatus` requests, specify the value of `NextToken` from
#' the previous response to get information about another batch of objects.
#' @param MaxResults Specifies the number of objects that you want AWS Firewall Manager to
#' return for this request. If you have more objects than the number that
#' you specify for `MaxResults`, the response includes a `NextToken` value
#' that you can use to get another batch of objects.
#'
#' @section Request syntax:
#' ```
#' svc$get_protection_status(
#'   PolicyId = "string",
#'   MemberAccountId = "string",
#'   StartTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   EndTime = as.POSIXct(
#'     "2015-01-01"
#'   ),
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_get_protection_status
fms_get_protection_status <- function(PolicyId, MemberAccountId = NULL, StartTime = NULL, EndTime = NULL, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "GetProtectionStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$get_protection_status_input(PolicyId = PolicyId, MemberAccountId = MemberAccountId, StartTime = StartTime, EndTime = EndTime, NextToken = NextToken, MaxResults = MaxResults)
  output <- .fms$get_protection_status_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$get_protection_status <- fms_get_protection_status

#' Returns an array of PolicyComplianceStatus objects in the response
#'
#' Returns an array of `PolicyComplianceStatus` objects in the response.
#' Use `PolicyComplianceStatus` to get a summary of which member accounts
#' are protected by the specified policy.
#'
#' @usage
#' fms_list_compliance_status(PolicyId, NextToken, MaxResults)
#'
#' @param PolicyId &#91;required&#93; The ID of the AWS Firewall Manager policy that you want the details for.
#' @param NextToken If you specify a value for `MaxResults` and you have more
#' `PolicyComplianceStatus` objects than the number that you specify for
#' `MaxResults`, AWS Firewall Manager returns a `NextToken` value in the
#' response that allows you to list another group of
#' `PolicyComplianceStatus` objects. For the second and subsequent
#' `ListComplianceStatus` requests, specify the value of `NextToken` from
#' the previous response to get information about another batch of
#' `PolicyComplianceStatus` objects.
#' @param MaxResults Specifies the number of `PolicyComplianceStatus` objects that you want
#' AWS Firewall Manager to return for this request. If you have more
#' `PolicyComplianceStatus` objects than the number that you specify for
#' `MaxResults`, the response includes a `NextToken` value that you can use
#' to get another batch of `PolicyComplianceStatus` objects.
#'
#' @section Request syntax:
#' ```
#' svc$list_compliance_status(
#'   PolicyId = "string",
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_list_compliance_status
fms_list_compliance_status <- function(PolicyId, NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListComplianceStatus",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$list_compliance_status_input(PolicyId = PolicyId, NextToken = NextToken, MaxResults = MaxResults)
  output <- .fms$list_compliance_status_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$list_compliance_status <- fms_list_compliance_status

#' Returns a MemberAccounts object that lists the member accounts in the
#' administrator's AWS organization
#'
#' Returns a `MemberAccounts` object that lists the member accounts in the
#' administrator\'s AWS organization.
#' 
#' The `ListMemberAccounts` must be submitted by the account that is set as
#' the AWS Firewall Manager administrator.
#'
#' @usage
#' fms_list_member_accounts(NextToken, MaxResults)
#'
#' @param NextToken If you specify a value for `MaxResults` and you have more account IDs
#' than the number that you specify for `MaxResults`, AWS Firewall Manager
#' returns a `NextToken` value in the response that allows you to list
#' another group of IDs. For the second and subsequent
#' `ListMemberAccountsRequest` requests, specify the value of `NextToken`
#' from the previous response to get information about another batch of
#' member account IDs.
#' @param MaxResults Specifies the number of member account IDs that you want AWS Firewall
#' Manager to return for this request. If you have more IDs than the number
#' that you specify for `MaxResults`, the response includes a `NextToken`
#' value that you can use to get another batch of member account IDs.
#'
#' @section Request syntax:
#' ```
#' svc$list_member_accounts(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_list_member_accounts
fms_list_member_accounts <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListMemberAccounts",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$list_member_accounts_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .fms$list_member_accounts_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$list_member_accounts <- fms_list_member_accounts

#' Returns an array of PolicySummary objects in the response
#'
#' Returns an array of `PolicySummary` objects in the response.
#'
#' @usage
#' fms_list_policies(NextToken, MaxResults)
#'
#' @param NextToken If you specify a value for `MaxResults` and you have more
#' `PolicySummary` objects than the number that you specify for
#' `MaxResults`, AWS Firewall Manager returns a `NextToken` value in the
#' response that allows you to list another group of `PolicySummary`
#' objects. For the second and subsequent `ListPolicies` requests, specify
#' the value of `NextToken` from the previous response to get information
#' about another batch of `PolicySummary` objects.
#' @param MaxResults Specifies the number of `PolicySummary` objects that you want AWS
#' Firewall Manager to return for this request. If you have more
#' `PolicySummary` objects than the number that you specify for
#' `MaxResults`, the response includes a `NextToken` value that you can use
#' to get another batch of `PolicySummary` objects.
#'
#' @section Request syntax:
#' ```
#' svc$list_policies(
#'   NextToken = "string",
#'   MaxResults = 123
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_list_policies
fms_list_policies <- function(NextToken = NULL, MaxResults = NULL) {
  op <- new_operation(
    name = "ListPolicies",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$list_policies_input(NextToken = NextToken, MaxResults = MaxResults)
  output <- .fms$list_policies_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$list_policies <- fms_list_policies

#' Retrieves the list of tags for the specified AWS resource
#'
#' Retrieves the list of tags for the specified AWS resource.
#'
#' @usage
#' fms_list_tags_for_resource(ResourceArn)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource to return tags for. The
#' Firewall Manager policy is the only AWS resource that supports tagging,
#' so this ARN is a policy ARN..
#'
#' @section Request syntax:
#' ```
#' svc$list_tags_for_resource(
#'   ResourceArn = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_list_tags_for_resource
fms_list_tags_for_resource <- function(ResourceArn) {
  op <- new_operation(
    name = "ListTagsForResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$list_tags_for_resource_input(ResourceArn = ResourceArn)
  output <- .fms$list_tags_for_resource_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$list_tags_for_resource <- fms_list_tags_for_resource

#' Designates the IAM role and Amazon Simple Notification Service (SNS)
#' topic that AWS Firewall Manager uses to record SNS logs
#'
#' Designates the IAM role and Amazon Simple Notification Service (SNS)
#' topic that AWS Firewall Manager uses to record SNS logs.
#'
#' @usage
#' fms_put_notification_channel(SnsTopicArn, SnsRoleName)
#'
#' @param SnsTopicArn &#91;required&#93; The Amazon Resource Name (ARN) of the SNS topic that collects
#' notifications from AWS Firewall Manager.
#' @param SnsRoleName &#91;required&#93; The Amazon Resource Name (ARN) of the IAM role that allows Amazon SNS to
#' record AWS Firewall Manager activity.
#'
#' @section Request syntax:
#' ```
#' svc$put_notification_channel(
#'   SnsTopicArn = "string",
#'   SnsRoleName = "string"
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_put_notification_channel
fms_put_notification_channel <- function(SnsTopicArn, SnsRoleName) {
  op <- new_operation(
    name = "PutNotificationChannel",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$put_notification_channel_input(SnsTopicArn = SnsTopicArn, SnsRoleName = SnsRoleName)
  output <- .fms$put_notification_channel_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$put_notification_channel <- fms_put_notification_channel

#' Creates an AWS Firewall Manager policy
#'
#' Creates an AWS Firewall Manager policy.
#' 
#' Firewall Manager provides the following types of policies:
#' 
#' -   A Shield Advanced policy, which applies Shield Advanced protection
#'     to specified accounts and resources
#' 
#' -   An AWS WAF policy, which contains a rule group and defines which
#'     resources are to be protected by that rule group
#' 
#' -   A security group policy, which manages VPC security groups across
#'     your AWS organization.
#' 
#' Each policy is specific to one of the three types. If you want to
#' enforce more than one policy type across accounts, you can create
#' multiple policies. You can create multiple policies for each type.
#' 
#' You must be subscribed to Shield Advanced to create a Shield Advanced
#' policy. For more information about subscribing to Shield Advanced, see
#' [CreateSubscription](https://docs.aws.amazon.com/waf/latest/DDOSAPIReference/API_CreateSubscription.html).
#'
#' @usage
#' fms_put_policy(Policy, TagList)
#'
#' @param Policy &#91;required&#93; The details of the AWS Firewall Manager policy to be created.
#' @param TagList The tags to add to the AWS resource.
#'
#' @section Request syntax:
#' ```
#' svc$put_policy(
#'   Policy = list(
#'     PolicyId = "string",
#'     PolicyName = "string",
#'     PolicyUpdateToken = "string",
#'     SecurityServicePolicyData = list(
#'       Type = "WAF"|"SHIELD_ADVANCED"|"SECURITY_GROUPS_COMMON"|"SECURITY_GROUPS_CONTENT_AUDIT"|"SECURITY_GROUPS_USAGE_AUDIT",
#'       ManagedServiceData = "string"
#'     ),
#'     ResourceType = "string",
#'     ResourceTypeList = list(
#'       "string"
#'     ),
#'     ResourceTags = list(
#'       list(
#'         Key = "string",
#'         Value = "string"
#'       )
#'     ),
#'     ExcludeResourceTags = TRUE|FALSE,
#'     RemediationEnabled = TRUE|FALSE,
#'     IncludeMap = list(
#'       list(
#'         "string"
#'       )
#'     ),
#'     ExcludeMap = list(
#'       list(
#'         "string"
#'       )
#'     )
#'   ),
#'   TagList = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_put_policy
fms_put_policy <- function(Policy, TagList = NULL) {
  op <- new_operation(
    name = "PutPolicy",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$put_policy_input(Policy = Policy, TagList = TagList)
  output <- .fms$put_policy_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$put_policy <- fms_put_policy

#' Adds one or more tags to an AWS resource
#'
#' Adds one or more tags to an AWS resource.
#'
#' @usage
#' fms_tag_resource(ResourceArn, TagList)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource. The Firewall Manager
#' policy is the only AWS resource that supports tagging, so this ARN is a
#' policy ARN.
#' @param TagList &#91;required&#93; The tags to add to the resource.
#'
#' @section Request syntax:
#' ```
#' svc$tag_resource(
#'   ResourceArn = "string",
#'   TagList = list(
#'     list(
#'       Key = "string",
#'       Value = "string"
#'     )
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_tag_resource
fms_tag_resource <- function(ResourceArn, TagList) {
  op <- new_operation(
    name = "TagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$tag_resource_input(ResourceArn = ResourceArn, TagList = TagList)
  output <- .fms$tag_resource_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$tag_resource <- fms_tag_resource

#' Removes one or more tags from an AWS resource
#'
#' Removes one or more tags from an AWS resource.
#'
#' @usage
#' fms_untag_resource(ResourceArn, TagKeys)
#'
#' @param ResourceArn &#91;required&#93; The Amazon Resource Name (ARN) of the resource. The Firewall Manager
#' policy is the only AWS resource that supports tagging, so this ARN is a
#' policy ARN.
#' @param TagKeys &#91;required&#93; The keys of the tags to remove from the resource.
#'
#' @section Request syntax:
#' ```
#' svc$untag_resource(
#'   ResourceArn = "string",
#'   TagKeys = list(
#'     "string"
#'   )
#' )
#' ```
#'
#' @keywords internal
#'
#' @rdname fms_untag_resource
fms_untag_resource <- function(ResourceArn, TagKeys) {
  op <- new_operation(
    name = "UntagResource",
    http_method = "POST",
    http_path = "/",
    paginator = list()
  )
  input <- .fms$untag_resource_input(ResourceArn = ResourceArn, TagKeys = TagKeys)
  output <- .fms$untag_resource_output()
  config <- get_config()
  svc <- .fms$service(config)
  request <- new_request(svc, op, input, output)
  response <- send_request(request)
  return(response)
}
.fms$operations$untag_resource <- fms_untag_resource
