% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/waf_operations.R
\name{waf_update_xss_match_set}
\alias{waf_update_xss_match_set}
\title{Inserts or deletes XssMatchTuple objects (filters) in an XssMatchSet}
\usage{
waf_update_xss_match_set(XssMatchSetId, ChangeToken, Updates)
}
\arguments{
\item{XssMatchSetId}{[required] The \code{XssMatchSetId} of the \code{XssMatchSet} that you want to update.
\code{XssMatchSetId} is returned by CreateXssMatchSet and by
ListXssMatchSets.}

\item{ChangeToken}{[required] The value returned by the most recent call to GetChangeToken.}

\item{Updates}{[required] An array of \code{XssMatchSetUpdate} objects that you want to insert into or
delete from an XssMatchSet. For more information, see the applicable
data types:
\itemize{
\item XssMatchSetUpdate: Contains \code{Action} and \code{XssMatchTuple}
\item XssMatchTuple: Contains \code{FieldToMatch} and \code{TextTransformation}
\item FieldToMatch: Contains \code{Data} and \code{Type}
}}
}
\description{
Inserts or deletes XssMatchTuple objects (filters) in an XssMatchSet.
For each \code{XssMatchTuple} object, you specify the following values:
}
\details{
\itemize{
\item \code{Action}: Whether to insert the object into or delete the object
from the array. To change an \code{XssMatchTuple}, you delete the
existing object and add a new one.
\item \code{FieldToMatch}: The part of web requests that you want AWS WAF to
inspect and, if you want AWS WAF to inspect a header or custom query
parameter, the name of the header or parameter.
\item \code{TextTransformation}: Which text transformation, if any, to perform
on the web request before inspecting the request for cross-site
scripting attacks.

You can only specify a single type of TextTransformation.
}

You use \code{XssMatchSet} objects to specify which CloudFront requests that
you want to allow, block, or count. For example, if you\'re receiving
requests that contain cross-site scripting attacks in the request body
and you want to block the requests, you can create an \code{XssMatchSet} with
the applicable settings, and then configure AWS WAF to block the
requests.

To create and configure an \code{XssMatchSet}, perform the following steps:
\enumerate{
\item Submit a CreateXssMatchSet request.
\item Use GetChangeToken to get the change token that you provide in the
\code{ChangeToken} parameter of an UpdateIPSet request.
\item Submit an \code{UpdateXssMatchSet} request to specify the parts of web
requests that you want AWS WAF to inspect for cross-site scripting
attacks.
}

For more information about how to use the AWS WAF API to allow or block
HTTP requests, see the \href{https://docs.aws.amazon.com/waf/latest/developerguide/}{AWS WAF Developer Guide}.
}
\section{Request syntax}{
\preformatted{svc$update_xss_match_set(
  XssMatchSetId = "string",
  ChangeToken = "string",
  Updates = list(
    list(
      Action = "INSERT"|"DELETE",
      XssMatchTuple = list(
        FieldToMatch = list(
          Type = "URI"|"QUERY_STRING"|"HEADER"|"METHOD"|"BODY"|"SINGLE_QUERY_ARG"|"ALL_QUERY_ARGS",
          Data = "string"
        ),
        TextTransformation = "NONE"|"COMPRESS_WHITE_SPACE"|"HTML_ENTITY_DECODE"|"LOWERCASE"|"CMD_LINE"|"URL_DECODE"
      )
    )
  )
)
}
}

\examples{
# The following example deletes an XssMatchTuple object (filters) in an
# XssMatchSet with the ID example1ds3t-46da-4fdb-b8d5-abc321j569j5.
\donttest{svc$update_xss_match_set(
  ChangeToken = "abcd12f2-46da-4fdb-b8d5-fbd4c466928f",
  Updates = list(
    list(
      Action = "DELETE",
      XssMatchTuple = list(
        FieldToMatch = list(
          Type = "QUERY_STRING"
        ),
        TextTransformation = "URL_DECODE"
      )
    )
  ),
  XssMatchSetId = "example1ds3t-46da-4fdb-b8d5-abc321j569j5"
)}

}
\keyword{internal}
