% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ram_operations.R
\name{ram_list_principals}
\alias{ram_list_principals}
\title{Lists the principals that you have shared resources with or that have
shared resources with you}
\usage{
ram_list_principals(resourceOwner, resourceArn, principals,
  resourceType, resourceShareArns, nextToken, maxResults)
}
\arguments{
\item{resourceOwner}{[required] The type of owner.}

\item{resourceArn}{The Amazon Resource Name (ARN) of the resource.}

\item{principals}{The principals.}

\item{resourceType}{The resource type.

Valid values: \code{ec2:CapacityReservation} \\| \code{ec2:Subnet} \\|
\code{ec2:TrafficMirrorTarget} \\| \code{ec2:TransitGateway} \\|
\code{license-manager:LicenseConfiguration} \\| \code{rds:Cluster} \\|
\code{route53resolver:ResolverRule} I \code{resource-groups:Group}}

\item{resourceShareArns}{The Amazon Resource Names (ARN) of the resource shares.}

\item{nextToken}{The token for the next page of results.}

\item{maxResults}{The maximum number of results to return with a single call. To retrieve
the remaining results, make another call with the returned \code{nextToken}
value.}
}
\description{
Lists the principals that you have shared resources with or that have
shared resources with you.
}
\section{Request syntax}{
\preformatted{svc$list_principals(
  resourceOwner = "SELF"|"OTHER-ACCOUNTS",
  resourceArn = "string",
  principals = list(
    "string"
  ),
  resourceType = "string",
  resourceShareArns = list(
    "string"
  ),
  nextToken = "string",
  maxResults = 123
)
}
}

\keyword{internal}
