% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cloudhsmv2_operations.R
\name{cloudhsmv2_create_hsm}
\alias{cloudhsmv2_create_hsm}
\title{Creates a new hardware security module (HSM) in the specified AWS
CloudHSM cluster}
\usage{
cloudhsmv2_create_hsm(ClusterId, AvailabilityZone, IpAddress)
}
\arguments{
\item{ClusterId}{[required] The identifier (ID) of the HSM's cluster. To find the cluster ID, use
DescribeClusters.}

\item{AvailabilityZone}{[required] The Availability Zone where you are creating the HSM. To find the
cluster's Availability Zones, use DescribeClusters.}

\item{IpAddress}{The HSM's IP address. If you specify an IP address, use an available
address from the subnet that maps to the Availability Zone where you are
creating the HSM. If you don't specify an IP address, one is chosen for
you from that subnet.}
}
\description{
Creates a new hardware security module (HSM) in the specified AWS
CloudHSM cluster.
}
\section{Request syntax}{
\preformatted{svc$create_hsm(
  ClusterId = "string",
  AvailabilityZone = "string",
  IpAddress = "string"
)
}
}

\keyword{internal}
