% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitosync_service.R
\name{cognitosync}
\alias{cognitosync}
\title{Amazon Cognito Sync}
\usage{
cognitosync(config = list())
}
\arguments{
\item{config}{Optional configuration of credentials, endpoint, and/or region.}
}
\description{
Amazon Cognito Sync provides an AWS service and client library that
enable cross-device syncing of application-related user data. High-level
client libraries are available for both iOS and Android. You can use
these libraries to persist data locally so that it's available even if
the device is offline. Developer credentials don't need to be stored on
the mobile device to access the service. You can use Amazon Cognito to
obtain a normalized user ID and credentials. User data is persisted in a
dataset that can store up to 1 MB of key-value pairs, and you can have
up to 20 datasets per user identity.

With Amazon Cognito Sync, the data stored for each identity is
accessible only to credentials assigned to that identity. In order to
use the Cognito Sync service, you need to make API calls using
credentials retrieved with \href{https://docs.aws.amazon.com/cognitoidentity/latest/APIReference/Welcome.html}{Amazon Cognito Identity service}.

If you want to use Cognito Sync in an Android or iOS application, you
will probably want to make API calls via the AWS Mobile SDK. To learn
more, see the \href{https://docs.aws.amazon.com/aws-mobile/latest/developerguide/}{Developer Guide for Android}
and the \href{https://docs.aws.amazon.com/mobile/sdkforios/developerguide/}{Developer Guide for iOS}.
}
\section{Service syntax}{
\preformatted{svc <- cognitosync(
  config = list(
    credentials = list(
      creds = list(
        access_key_id = "string",
        secret_access_key = "string",
        session_token = "string"
      ),
      profile = "string"
    ),
    endpoint = "string",
    region = "string"
  )
)
}
}

\section{Operations}{

\tabular{ll}{
\link[=cognitosync_bulk_publish]{bulk_publish} \tab Initiates a bulk publish of all existing datasets for an Identity Pool to the configured stream\cr
\link[=cognitosync_delete_dataset]{delete_dataset} \tab Deletes the specific dataset\cr
\link[=cognitosync_describe_dataset]{describe_dataset} \tab Gets meta data about a dataset by identity and dataset name\cr
\link[=cognitosync_describe_identity_pool_usage]{describe_identity_pool_usage} \tab Gets usage details (for example, data storage) about a particular identity pool\cr
\link[=cognitosync_describe_identity_usage]{describe_identity_usage} \tab Gets usage information for an identity, including number of datasets and data usage\cr
\link[=cognitosync_get_bulk_publish_details]{get_bulk_publish_details} \tab Get the status of the last BulkPublish operation for an identity pool\cr
\link[=cognitosync_get_cognito_events]{get_cognito_events} \tab Gets the events and the corresponding Lambda functions associated with an identity pool\cr
\link[=cognitosync_get_identity_pool_configuration]{get_identity_pool_configuration} \tab Gets the configuration settings of an identity pool\cr
\link[=cognitosync_list_datasets]{list_datasets} \tab Lists datasets for an identity\cr
\link[=cognitosync_list_identity_pool_usage]{list_identity_pool_usage} \tab Gets a list of identity pools registered with Cognito\cr
\link[=cognitosync_list_records]{list_records} \tab Gets paginated records, optionally changed after a particular sync count for a dataset and identity\cr
\link[=cognitosync_register_device]{register_device} \tab Registers a device to receive push sync notifications\cr
\link[=cognitosync_set_cognito_events]{set_cognito_events} \tab Sets the AWS Lambda function for a given event type for an identity pool\cr
\link[=cognitosync_set_identity_pool_configuration]{set_identity_pool_configuration} \tab Sets the necessary configuration for push sync\cr
\link[=cognitosync_subscribe_to_dataset]{subscribe_to_dataset} \tab Subscribes to receive notifications when a dataset is modified by another device\cr
\link[=cognitosync_unsubscribe_from_dataset]{unsubscribe_from_dataset} \tab Unsubscribes from receiving notifications when a dataset is modified by another device\cr
\link[=cognitosync_update_records]{update_records} \tab Posts updates to records and adds and deletes records for a dataset and user
}
}

\examples{
\dontrun{
svc <- cognitosync()
svc$bulk_publish(
  Foo = 123
)
}

}
