% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cognitoidentity_operations.R
\name{cognitoidentity_lookup_developer_identity}
\alias{cognitoidentity_lookup_developer_identity}
\title{Retrieves the IdentityID associated with a DeveloperUserIdentifier or
the list of DeveloperUserIdentifier values associated with an IdentityId
for an existing identity}
\usage{
cognitoidentity_lookup_developer_identity(IdentityPoolId, IdentityId,
  DeveloperUserIdentifier, MaxResults, NextToken)
}
\arguments{
\item{IdentityPoolId}{[required] An identity pool ID in the format REGION:GUID.}

\item{IdentityId}{A unique identifier in the format REGION:GUID.}

\item{DeveloperUserIdentifier}{A unique ID used by your backend authentication process to identify a
user. Typically, a developer identity provider would issue many
developer user identifiers, in keeping with the number of users.}

\item{MaxResults}{The maximum number of identities to return.}

\item{NextToken}{A pagination token. The first call you make will have \code{NextToken} set to
null. After that the service will return \code{NextToken} values as needed.
For example, let's say you make a request with \code{MaxResults} set to 10,
and there are 20 matches in the database. The service will return a
pagination token as a part of the response. This token can be used to
call the API again and get results starting from the 11th match.}
}
\description{
Retrieves the \code{IdentityID} associated with a \code{DeveloperUserIdentifier}
or the list of \code{DeveloperUserIdentifier} values associated with an
\code{IdentityId} for an existing identity. Either \code{IdentityID} or
\code{DeveloperUserIdentifier} must not be null. If you supply only one of
these values, the other value will be searched in the database and
returned as a part of the response. If you supply both,
\code{DeveloperUserIdentifier} will be matched against \code{IdentityID}. If the
values are verified against the database, the response returns both
values and is the same as the request. Otherwise a
\code{ResourceConflictException} is thrown.

\code{LookupDeveloperIdentity} is intended for low-throughput control plane
operations: for example, to enable customer service to locate an
identity ID by username. If you are using it for higher-volume
operations such as user authentication, your requests are likely to be
throttled. GetOpenIdTokenForDeveloperIdentity is a better option for
higher-volume operations for user authentication.

You must use AWS Developer credentials to call this API.
}
\section{Request syntax}{
\preformatted{svc$lookup_developer_identity(
  IdentityPoolId = "string",
  IdentityId = "string",
  DeveloperUserIdentifier = "string",
  MaxResults = 123,
  NextToken = "string"
)
}
}

\keyword{internal}
