% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_list_firewall_rule_group_associations}
\alias{route53resolver_list_firewall_rule_group_associations}
\title{Retrieves the firewall rule group associations that you have defined}
\usage{
route53resolver_list_firewall_rule_group_associations(
  FirewallRuleGroupId = NULL,
  VpcId = NULL,
  Priority = NULL,
  Status = NULL,
  MaxResults = NULL,
  NextToken = NULL
)
}
\arguments{
\item{FirewallRuleGroupId}{The unique identifier of the firewall rule group that you want to
retrieve the associations for. Leave this blank to retrieve associations
for any rule group.}

\item{VpcId}{The unique identifier of the VPC that you want to retrieve the
associations for. Leave this blank to retrieve associations for any VPC.}

\item{Priority}{The setting that determines the processing order of the rule group among
the rule groups that are associated with a single VPC. DNS Firewall
filters VPC traffic starting from the rule group with the lowest numeric
priority setting.}

\item{Status}{The association \code{Status} setting that you want DNS Firewall to filter on
for the list. If you don't specify this, then DNS Firewall returns all
associations, regardless of status.}

\item{MaxResults}{The maximum number of objects that you want Resolver to return for this
request. If more objects are available, in the response, Resolver
provides a \code{NextToken} value that you can use in a subsequent call to
get the next batch of objects.

If you don't specify a value for \code{MaxResults}, Resolver returns up to
100 objects.}

\item{NextToken}{For the first call to this list request, omit this value.

When you request a list of objects, Resolver returns at most the number
of objects specified in \code{MaxResults}. If more objects are available for
retrieval, Resolver returns a \code{NextToken} value in the response. To
retrieve the next batch of objects, use the token that was returned for
the prior request in your next request.}
}
\description{
Retrieves the firewall rule group associations that you have defined. Each association enables DNS filtering for a VPC with one rule group.

See \url{https://www.paws-r-sdk.com/docs/route53resolver_list_firewall_rule_group_associations/} for full documentation.
}
\keyword{internal}
