% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53domains_operations.R
\name{route53domains_list_domains}
\alias{route53domains_list_domains}
\title{This operation returns all the domain names registered with Amazon Route
53 for the current Amazon Web Services account if no filtering
conditions are used}
\usage{
route53domains_list_domains(
  FilterConditions = NULL,
  SortCondition = NULL,
  Marker = NULL,
  MaxItems = NULL
)
}
\arguments{
\item{FilterConditions}{A complex type that contains information about the filters applied
during the \code{\link[=route53domains_list_domains]{list_domains}} request. The
filter conditions can include domain name and domain expiration.}

\item{SortCondition}{A complex type that contains information about the requested ordering of
domains in the returned list.}

\item{Marker}{For an initial request for a list of domains, omit this element. If the
number of domains that are associated with the current Amazon Web
Services account is greater than the value that you specified for
\code{MaxItems}, you can use \code{Marker} to return additional domains. Get the
value of \code{NextPageMarker} from the previous response, and submit another
request that includes the value of \code{NextPageMarker} in the \code{Marker}
element.

Constraints: The marker must match the value specified in the previous
request.}

\item{MaxItems}{Number of domains to be returned.

Default: 20}
}
\description{
This operation returns all the domain names registered with Amazon Route 53 for the current Amazon Web Services account if no filtering conditions are used.

See \url{https://www.paws-r-sdk.com/docs/route53domains_list_domains/} for full documentation.
}
\keyword{internal}
