% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53_operations.R
\name{route53_list_query_logging_configs}
\alias{route53_list_query_logging_configs}
\title{Lists the configurations for DNS query logging that are associated with
the current Amazon Web Services account or the configuration that is
associated with a specified hosted zone}
\usage{
route53_list_query_logging_configs(
  HostedZoneId = NULL,
  NextToken = NULL,
  MaxResults = NULL
)
}
\arguments{
\item{HostedZoneId}{(Optional) If you want to list the query logging configuration that is
associated with a hosted zone, specify the ID in \code{HostedZoneId}.

If you don't specify a hosted zone ID,
\code{\link[=route53_list_query_logging_configs]{list_query_logging_configs}}
returns all of the configurations that are associated with the current
Amazon Web Services account.}

\item{NextToken}{(Optional) If the current Amazon Web Services account has more than
\code{MaxResults} query logging configurations, use \code{NextToken} to get the
second and subsequent pages of results.

For the first
\code{\link[=route53_list_query_logging_configs]{list_query_logging_configs}}
request, omit this value.

For the second and subsequent requests, get the value of \code{NextToken}
from the previous response and specify that value for \code{NextToken} in the
request.}

\item{MaxResults}{(Optional) The maximum number of query logging configurations that you
want Amazon Route 53 to return in response to the current request. If
the current Amazon Web Services account has more than \code{MaxResults}
configurations, use the value of
\href{https://docs.aws.amazon.com/Route53/latest/APIReference/API_ListQueryLoggingConfigs.html#API_ListQueryLoggingConfigs_RequestSyntax}{NextToken}
in the response to get the next page of results.

If you don't specify a value for \code{MaxResults}, Route 53 returns up to
100 configurations.}
}
\description{
Lists the configurations for DNS query logging that are associated with the current Amazon Web Services account or the configuration that is associated with a specified hosted zone.

See \url{https://www.paws-r-sdk.com/docs/route53_list_query_logging_configs/} for full documentation.
}
\keyword{internal}
