% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkmanager_operations.R
\name{networkmanager_register_transit_gateway}
\alias{networkmanager_register_transit_gateway}
\title{Registers a transit gateway in your global network}
\usage{
networkmanager_register_transit_gateway(GlobalNetworkId, TransitGatewayArn)
}
\arguments{
\item{GlobalNetworkId}{[required] The ID of the global network.}

\item{TransitGatewayArn}{[required] The Amazon Resource Name (ARN) of the transit gateway.}
}
\description{
Registers a transit gateway in your global network. Not all Regions support transit gateways for global networks. For a list of the supported Regions, see \href{https://docs.aws.amazon.com/network-manager/latest/tgwnm/what-are-global-networks.html#nm-available-regions}{Region Availability} in the \emph{Amazon Web Services Transit Gateways for Global Networks User Guide}. The transit gateway can be in any of the supported Amazon Web Services Regions, but it must be owned by the same Amazon Web Services account that owns the global network. You cannot register a transit gateway in more than one global network.

See \url{https://www.paws-r-sdk.com/docs/networkmanager_register_transit_gateway/} for full documentation.
}
\keyword{internal}
