% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkfirewall_operations.R
\name{networkfirewall_update_tls_inspection_configuration}
\alias{networkfirewall_update_tls_inspection_configuration}
\title{Updates the TLS inspection configuration settings for the specified TLS
inspection configuration}
\usage{
networkfirewall_update_tls_inspection_configuration(
  TLSInspectionConfigurationArn = NULL,
  TLSInspectionConfigurationName = NULL,
  TLSInspectionConfiguration,
  Description = NULL,
  EncryptionConfiguration = NULL,
  UpdateToken
)
}
\arguments{
\item{TLSInspectionConfigurationArn}{The Amazon Resource Name (ARN) of the TLS inspection configuration.}

\item{TLSInspectionConfigurationName}{The descriptive name of the TLS inspection configuration. You can't
change the name of a TLS inspection configuration after you create it.}

\item{TLSInspectionConfiguration}{[required] The object that defines a TLS inspection configuration. This, along with
TLSInspectionConfigurationResponse, define the TLS inspection
configuration. You can retrieve all objects for a TLS inspection
configuration by calling
\code{\link[=networkfirewall_describe_tls_inspection_configuration]{describe_tls_inspection_configuration}}.

Network Firewall uses a TLS inspection configuration to decrypt traffic.
Network Firewall re-encrypts the traffic before sending it to its
destination.

To use a TLS inspection configuration, you add it to a new Network
Firewall firewall policy, then you apply the firewall policy to a
firewall. Network Firewall acts as a proxy service to decrypt and
inspect the traffic traveling through your firewalls. You can reference
a TLS inspection configuration from more than one firewall policy, and
you can use a firewall policy in more than one firewall. For more
information about using TLS inspection configurations, see \href{https://docs.aws.amazon.com/network-firewall/latest/developerguide/}{Inspecting SSL/TLS traffic with TLS inspection configurations}
in the \emph{Network Firewall Developer Guide}.}

\item{Description}{A description of the TLS inspection configuration.}

\item{EncryptionConfiguration}{A complex type that contains the Amazon Web Services KMS encryption
configuration settings for your TLS inspection configuration.}

\item{UpdateToken}{[required] A token used for optimistic locking. Network Firewall returns a token to
your requests that access the TLS inspection configuration. The token
marks the state of the TLS inspection configuration resource at the time
of the request.

To make changes to the TLS inspection configuration, you provide the
token in your request. Network Firewall uses the token to ensure that
the TLS inspection configuration hasn't changed since you last retrieved
it. If it has changed, the operation fails with an
\code{InvalidTokenException}. If this happens, retrieve the TLS inspection
configuration again to get a current copy of it with a current token.
Reapply your changes as needed, then try the operation again using the
new token.}
}
\description{
Updates the TLS inspection configuration settings for the specified TLS inspection configuration. You use a TLS inspection configuration by referencing it in one or more firewall policies. When you modify a TLS inspection configuration, you modify all firewall policies that use the TLS inspection configuration.

See \url{https://www.paws-r-sdk.com/docs/networkfirewall_update_tls_inspection_configuration/} for full documentation.
}
\keyword{internal}
