% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_create_target_group}
\alias{elbv2_create_target_group}
\title{Creates a target group}
\usage{
elbv2_create_target_group(
  Name,
  Protocol = NULL,
  ProtocolVersion = NULL,
  Port = NULL,
  VpcId = NULL,
  HealthCheckProtocol = NULL,
  HealthCheckPort = NULL,
  HealthCheckEnabled = NULL,
  HealthCheckPath = NULL,
  HealthCheckIntervalSeconds = NULL,
  HealthCheckTimeoutSeconds = NULL,
  HealthyThresholdCount = NULL,
  UnhealthyThresholdCount = NULL,
  Matcher = NULL,
  TargetType = NULL,
  Tags = NULL,
  IpAddressType = NULL
)
}
\arguments{
\item{Name}{[required] The name of the target group.

This name must be unique per region per account, can have a maximum of
32 characters, must contain only alphanumeric characters or hyphens, and
must not begin or end with a hyphen.}

\item{Protocol}{The protocol to use for routing traffic to the targets. For Application
Load Balancers, the supported protocols are HTTP and HTTPS. For Network
Load Balancers, the supported protocols are TCP, TLS, UDP, or TCP_UDP.
For Gateway Load Balancers, the supported protocol is GENEVE. A TCP_UDP
listener must be associated with a TCP_UDP target group. If the target
is a Lambda function, this parameter does not apply.}

\item{ProtocolVersion}{[HTTP/HTTPS protocol] The protocol version. Specify \code{GRPC} to send
requests to targets using gRPC. Specify \code{HTTP2} to send requests to
targets using HTTP/2. The default is \code{HTTP1}, which sends requests to
targets using HTTP/1.1.}

\item{Port}{The port on which the targets receive traffic. This port is used unless
you specify a port override when registering the target. If the target
is a Lambda function, this parameter does not apply. If the protocol is
GENEVE, the supported port is 6081.}

\item{VpcId}{The identifier of the virtual private cloud (VPC). If the target is a
Lambda function, this parameter does not apply. Otherwise, this
parameter is required.}

\item{HealthCheckProtocol}{The protocol the load balancer uses when performing health checks on
targets. For Application Load Balancers, the default is HTTP. For
Network Load Balancers and Gateway Load Balancers, the default is TCP.
The TCP protocol is not supported for health checks if the protocol of
the target group is HTTP or HTTPS. The GENEVE, TLS, UDP, and TCP_UDP
protocols are not supported for health checks.}

\item{HealthCheckPort}{The port the load balancer uses when performing health checks on
targets. If the protocol is HTTP, HTTPS, TCP, TLS, UDP, or TCP_UDP, the
default is \code{traffic-port}, which is the port on which each target
receives traffic from the load balancer. If the protocol is GENEVE, the
default is port 80.}

\item{HealthCheckEnabled}{Indicates whether health checks are enabled. If the target type is
\code{lambda}, health checks are disabled by default but can be enabled. If
the target type is \code{instance}, \code{ip}, or \code{alb}, health checks are always
enabled and cannot be disabled.}

\item{HealthCheckPath}{[HTTP/HTTPS health checks] The destination for health checks on the
targets.

[HTTP1 or HTTP2 protocol version] The ping path. The default is /.

[GRPC protocol version] The path of a custom health check method with
the format /package.service/method. The default is /Amazon Web
Services.ALB/healthcheck.}

\item{HealthCheckIntervalSeconds}{The approximate amount of time, in seconds, between health checks of an
individual target. The range is 5-300. If the target group protocol is
TCP, TLS, UDP, TCP_UDP, HTTP or HTTPS, the default is 30 seconds. If the
target group protocol is GENEVE, the default is 10 seconds. If the
target type is \code{lambda}, the default is 35 seconds.}

\item{HealthCheckTimeoutSeconds}{The amount of time, in seconds, during which no response from a target
means a failed health check. The range is 2–120 seconds. For target
groups with a protocol of HTTP, the default is 6 seconds. For target
groups with a protocol of TCP, TLS or HTTPS, the default is 10 seconds.
For target groups with a protocol of GENEVE, the default is 5 seconds.
If the target type is \code{lambda}, the default is 30 seconds.}

\item{HealthyThresholdCount}{The number of consecutive health check successes required before
considering a target healthy. The range is 2-10. If the target group
protocol is TCP, TCP_UDP, UDP, TLS, HTTP or HTTPS, the default is 5. For
target groups with a protocol of GENEVE, the default is 5. If the target
type is \code{lambda}, the default is 5.}

\item{UnhealthyThresholdCount}{The number of consecutive health check failures required before
considering a target unhealthy. The range is 2-10. If the target group
protocol is TCP, TCP_UDP, UDP, TLS, HTTP or HTTPS, the default is 2. For
target groups with a protocol of GENEVE, the default is 2. If the target
type is \code{lambda}, the default is 5.}

\item{Matcher}{[HTTP/HTTPS health checks] The HTTP or gRPC codes to use when checking
for a successful response from a target. For target groups with a
protocol of TCP, TCP_UDP, UDP or TLS the range is 200-599. For target
groups with a protocol of HTTP or HTTPS, the range is 200-499. For
target groups with a protocol of GENEVE, the range is 200-399.}

\item{TargetType}{The type of target that you must specify when registering targets with
this target group. You can't specify targets for a target group using
more than one target type.
\itemize{
\item \code{instance} - Register targets by instance ID. This is the default
value.
\item \code{ip} - Register targets by IP address. You can specify IP addresses
from the subnets of the virtual private cloud (VPC) for the target
group, the RFC 1918 range (10.0.0.0/8, 172.16.0.0/12, and
192.168.0.0/16), and the RFC 6598 range (100.64.0.0/10). You can't
specify publicly routable IP addresses.
\item \code{lambda} - Register a single Lambda function as a target.
\item \code{alb} - Register a single Application Load Balancer as a target.
}}

\item{Tags}{The tags to assign to the target group.}

\item{IpAddressType}{The type of IP address used for this target group. The possible values
are \code{ipv4} and \code{ipv6}. This is an optional parameter. If not specified,
the IP address type defaults to \code{ipv4}.}
}
\description{
Creates a target group.

See \url{https://www.paws-r-sdk.com/docs/elbv2_create_target_group/} for full documentation.
}
\keyword{internal}
