% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/backupgateway_operations.R
\name{backupgateway_put_bandwidth_rate_limit_schedule}
\alias{backupgateway_put_bandwidth_rate_limit_schedule}
\title{This action sets the bandwidth rate limit schedule for a specified
gateway}
\usage{
backupgateway_put_bandwidth_rate_limit_schedule(
  BandwidthRateLimitIntervals,
  GatewayArn
)
}
\arguments{
\item{BandwidthRateLimitIntervals}{[required] An array containing bandwidth rate limit schedule intervals for a
gateway. When no bandwidth rate limit intervals have been scheduled, the
array is empty.}

\item{GatewayArn}{[required] The Amazon Resource Name (ARN) of the gateway. Use the
\href{https://docs.aws.amazon.com/aws-backup/latest/devguide/API_BGW_ListGateways.html}{\code{list_gateways}}
operation to return a list of gateways for your account and Amazon Web
Services Region.}
}
\description{
This action sets the bandwidth rate limit schedule for a specified gateway. By default, gateways do not have a bandwidth rate limit schedule, which means no bandwidth rate limiting is in effect. Use this to initiate a gateway's bandwidth rate limit schedule.

See \url{https://www.paws-r-sdk.com/docs/backupgateway_put_bandwidth_rate_limit_schedule/} for full documentation.
}
\keyword{internal}
