# This file is generated by make.paws. Please do not edit here.
#' @importFrom paws.common new_handlers new_service set_config merge_config
NULL

#' Amazon VPC Lattice
#'
#' @description
#' Amazon VPC Lattice is a fully managed application networking service
#' that you use to connect, secure, and monitor all of your services across
#' multiple accounts and virtual private clouds (VPCs). Amazon VPC Lattice
#' interconnects your microservices and legacy services within a logical
#' boundary, so that you can discover and manage them more efficiently. For
#' more information, see the [Amazon VPC Lattice User
#' Guide](https://docs.aws.amazon.com/vpc-lattice/latest/ug/)
#'
#' @param
#' config
#' Optional configuration of credentials, endpoint, and/or region.
#' \itemize{
#' \item{\strong{credentials}: \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }}
#' \item{\strong{endpoint}: The complete URL to use for the constructed client.}
#' \item{\strong{region}: The AWS Region used in instantiating the client.}
#' \item{\strong{close_connection}: Immediately close all HTTP connections.}
#' \item{\strong{timeout}: The time in seconds till a timeout exception is thrown when attempting to make a connection. The default is 60 seconds.}
#' \item{\strong{s3_force_path_style}: Set this to `true` to force the request to use path-style addressing, i.e. `http://s3.amazonaws.com/BUCKET/KEY`.}
#' \item{\strong{sts_regional_endpoint}: Set sts regional endpoint resolver to regional or legacy \url{https://docs.aws.amazon.com/sdkref/latest/guide/feature-sts-regionalized-endpoints.html}}
#' }
#' @param
#' credentials
#' Optional credentials shorthand for the config parameter
#' \itemize{
#' \item{\strong{creds}: \itemize{
#' \item{\strong{access_key_id}: AWS access key ID}
#' \item{\strong{secret_access_key}: AWS secret access key}
#' \item{\strong{session_token}: AWS temporary session token}
#' }}
#' \item{\strong{profile}: The name of a profile to use. If not given, then the default profile is used.}
#' \item{\strong{anonymous}: Set anonymous credentials.}
#' }
#' @param
#' endpoint
#' Optional shorthand for complete URL to use for the constructed client.
#' @param
#' region
#' Optional shorthand for AWS Region used in instantiating the client.
#'
#' @section Service syntax:
#' ```
#' svc <- vpclattice(
#'   config = list(
#'     credentials = list(
#'       creds = list(
#'         access_key_id = "string",
#'         secret_access_key = "string",
#'         session_token = "string"
#'       ),
#'       profile = "string",
#'       anonymous = "logical"
#'     ),
#'     endpoint = "string",
#'     region = "string",
#'     close_connection = "logical",
#'     timeout = "numeric",
#'     s3_force_path_style = "logical",
#'     sts_regional_endpoint = "string"
#'   ),
#'   credentials = list(
#'     creds = list(
#'       access_key_id = "string",
#'       secret_access_key = "string",
#'       session_token = "string"
#'     ),
#'     profile = "string",
#'     anonymous = "logical"
#'   ),
#'   endpoint = "string",
#'   region = "string"
#' )
#' ```
#'
#' @examples
#' \dontrun{
#' svc <- vpclattice()
#' svc$batch_update_rule(
#'   Foo = 123
#' )
#' }
#'
#' @section Operations:
#' \tabular{ll}{
#'  \link[=vpclattice_batch_update_rule]{batch_update_rule} \tab Updates the listener rules in a batch\cr
#'  \link[=vpclattice_create_access_log_subscription]{create_access_log_subscription} \tab Enables access logs to be sent to Amazon CloudWatch, Amazon S3, and Amazon Kinesis Data Firehose\cr
#'  \link[=vpclattice_create_listener]{create_listener} \tab Creates a listener for a service\cr
#'  \link[=vpclattice_create_rule]{create_rule} \tab Creates a listener rule\cr
#'  \link[=vpclattice_create_service]{create_service} \tab Creates a service\cr
#'  \link[=vpclattice_create_service_network]{create_service_network} \tab Creates a service network\cr
#'  \link[=vpclattice_create_service_network_service_association]{create_service_network_service_association} \tab Associates a service with a service network\cr
#'  \link[=vpclattice_create_service_network_vpc_association]{create_service_network_vpc_association} \tab Associates a VPC with a service network\cr
#'  \link[=vpclattice_create_target_group]{create_target_group} \tab Creates a target group\cr
#'  \link[=vpclattice_delete_access_log_subscription]{delete_access_log_subscription} \tab Deletes the specified access log subscription\cr
#'  \link[=vpclattice_delete_auth_policy]{delete_auth_policy} \tab Deletes the specified auth policy\cr
#'  \link[=vpclattice_delete_listener]{delete_listener} \tab Deletes the specified listener\cr
#'  \link[=vpclattice_delete_resource_policy]{delete_resource_policy} \tab Deletes the specified resource policy\cr
#'  \link[=vpclattice_delete_rule]{delete_rule} \tab Deletes a listener rule\cr
#'  \link[=vpclattice_delete_service]{delete_service} \tab Deletes a service\cr
#'  \link[=vpclattice_delete_service_network]{delete_service_network} \tab Deletes a service network\cr
#'  \link[=vpclattice_delete_service_network_service_association]{delete_service_network_service_association} \tab Deletes the association between a specified service and the specific service network\cr
#'  \link[=vpclattice_delete_service_network_vpc_association]{delete_service_network_vpc_association} \tab Disassociates the VPC from the service network\cr
#'  \link[=vpclattice_delete_target_group]{delete_target_group} \tab Deletes a target group\cr
#'  \link[=vpclattice_deregister_targets]{deregister_targets} \tab Deregisters the specified targets from the specified target group\cr
#'  \link[=vpclattice_get_access_log_subscription]{get_access_log_subscription} \tab Retrieves information about the specified access log subscription\cr
#'  \link[=vpclattice_get_auth_policy]{get_auth_policy} \tab Retrieves information about the auth policy for the specified service or service network\cr
#'  \link[=vpclattice_get_listener]{get_listener} \tab Retrieves information about the specified listener for the specified service\cr
#'  \link[=vpclattice_get_resource_policy]{get_resource_policy} \tab Retrieves information about the resource policy\cr
#'  \link[=vpclattice_get_rule]{get_rule} \tab Retrieves information about listener rules\cr
#'  \link[=vpclattice_get_service]{get_service} \tab Retrieves information about the specified service\cr
#'  \link[=vpclattice_get_service_network]{get_service_network} \tab Retrieves information about the specified service network\cr
#'  \link[=vpclattice_get_service_network_service_association]{get_service_network_service_association} \tab Retrieves information about the specified association between a service network and a service\cr
#'  \link[=vpclattice_get_service_network_vpc_association]{get_service_network_vpc_association} \tab Retrieves information about the association between a service network and a VPC\cr
#'  \link[=vpclattice_get_target_group]{get_target_group} \tab Retrieves information about the specified target group\cr
#'  \link[=vpclattice_list_access_log_subscriptions]{list_access_log_subscriptions} \tab Lists all access log subscriptions for the specified service network or service\cr
#'  \link[=vpclattice_list_listeners]{list_listeners} \tab Lists the listeners for the specified service\cr
#'  \link[=vpclattice_list_rules]{list_rules} \tab Lists the rules for the listener\cr
#'  \link[=vpclattice_list_service_networks]{list_service_networks} \tab Lists the service networks owned by the caller account or shared with the caller account\cr
#'  \link[=vpclattice_list_service_network_service_associations]{list_service_network_service_associations} \tab Lists the associations between the service network and the service\cr
#'  \link[=vpclattice_list_service_network_vpc_associations]{list_service_network_vpc_associations} \tab Lists the service network and VPC associations\cr
#'  \link[=vpclattice_list_services]{list_services} \tab Lists the services owned by the caller account or shared with the caller account\cr
#'  \link[=vpclattice_list_tags_for_resource]{list_tags_for_resource} \tab Lists the tags for the specified resource\cr
#'  \link[=vpclattice_list_target_groups]{list_target_groups} \tab Lists your target groups\cr
#'  \link[=vpclattice_list_targets]{list_targets} \tab Lists the targets for the target group\cr
#'  \link[=vpclattice_put_auth_policy]{put_auth_policy} \tab Creates or updates the auth policy\cr
#'  \link[=vpclattice_put_resource_policy]{put_resource_policy} \tab Attaches a resource-based permission policy to a service or service network\cr
#'  \link[=vpclattice_register_targets]{register_targets} \tab Registers the targets with the target group\cr
#'  \link[=vpclattice_tag_resource]{tag_resource} \tab Adds the specified tags to the specified resource\cr
#'  \link[=vpclattice_untag_resource]{untag_resource} \tab Removes the specified tags from the specified resource\cr
#'  \link[=vpclattice_update_access_log_subscription]{update_access_log_subscription} \tab Updates the specified access log subscription\cr
#'  \link[=vpclattice_update_listener]{update_listener} \tab Updates the specified listener for the specified service\cr
#'  \link[=vpclattice_update_rule]{update_rule} \tab Updates a rule for the listener\cr
#'  \link[=vpclattice_update_service]{update_service} \tab Updates the specified service\cr
#'  \link[=vpclattice_update_service_network]{update_service_network} \tab Updates the specified service network\cr
#'  \link[=vpclattice_update_service_network_vpc_association]{update_service_network_vpc_association} \tab Updates the service network and VPC association\cr
#'  \link[=vpclattice_update_target_group]{update_target_group} \tab Updates the specified target group
#' }
#'
#' @return
#' A client for the service. You can call the service's operations using
#' syntax like `svc$operation(...)`, where `svc` is the name you've assigned
#' to the client. The available operations are listed in the
#' Operations section.
#'
#' @rdname vpclattice
#' @export
vpclattice <- function(config = list(), credentials = list(), endpoint = NULL, region = NULL) {
  config <- merge_config(
    config,
    list(
      credentials = credentials,
      endpoint = endpoint,
      region = region
    )
  )
  svc <- .vpclattice$operations
  svc <- set_config(svc, config)
  return(svc)
}

# Private API objects: metadata, handlers, interfaces, etc.
.vpclattice <- list()

.vpclattice$operations <- list()

.vpclattice$metadata <- list(
  service_name = "vpclattice",
  endpoints = list("*" = list(endpoint = "vpc-lattice.{region}.amazonaws.com", global = FALSE), "cn-*" = list(endpoint = "vpc-lattice.{region}.amazonaws.com.cn", global = FALSE), "eu-isoe-*" = list(endpoint = "vpc-lattice.{region}.cloud.adc-e.uk", global = FALSE), "us-iso-*" = list(endpoint = "vpc-lattice.{region}.c2s.ic.gov", global = FALSE), "us-isob-*" = list(endpoint = "vpc-lattice.{region}.sc2s.sgov.gov", global = FALSE), "us-isof-*" = list(endpoint = "vpc-lattice.{region}.csp.hci.ic.gov", global = FALSE)),
  service_id = "VPC Lattice",
  api_version = "2022-11-30",
  signing_name = "vpc-lattice",
  json_version = "1.1",
  target_prefix = ""
)

.vpclattice$service <- function(config = list(), op = NULL) {
  handlers <- new_handlers("restjson", "v4")
  new_service(.vpclattice$metadata, handlers, config, op)
}
