% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/route53resolver_operations.R
\name{route53resolver_list_firewall_configs}
\alias{route53resolver_list_firewall_configs}
\title{Retrieves the firewall configurations that you have defined}
\usage{
route53resolver_list_firewall_configs(MaxResults = NULL, NextToken = NULL)
}
\arguments{
\item{MaxResults}{The maximum number of objects that you want Resolver to return for this
request. If more objects are available, in the response, Resolver
provides a \code{NextToken} value that you can use in a subsequent call to
get the next batch of objects.

If you don't specify a value for \code{MaxResults}, Resolver returns up to
100 objects.}

\item{NextToken}{For the first call to this list request, omit this value.

When you request a list of objects, Resolver returns at most the number
of objects specified in \code{MaxResults}. If more objects are available for
retrieval, Resolver returns a \code{NextToken} value in the response. To
retrieve the next batch of objects, use the token that was returned for
the prior request in your next request.}
}
\description{
Retrieves the firewall configurations that you have defined. DNS Firewall uses the configurations to manage firewall behavior for your VPCs.

See \url{https://paws-r.github.io/docs/route53resolver/list_firewall_configs.html} for full documentation.
}
\keyword{internal}
