% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/networkmanager_operations.R
\name{networkmanager_update_site}
\alias{networkmanager_update_site}
\title{Updates the information for an existing site}
\usage{
networkmanager_update_site(
  GlobalNetworkId,
  SiteId,
  Description = NULL,
  Location = NULL
)
}
\arguments{
\item{GlobalNetworkId}{[required] The ID of the global network.}

\item{SiteId}{[required] The ID of your site.}

\item{Description}{A description of your site.

Constraints: Maximum length of 256 characters.}

\item{Location}{The site location:
\itemize{
\item \code{Address}: The physical address of the site.
\item \code{Latitude}: The latitude of the site.
\item \code{Longitude}: The longitude of the site.
}}
}
\description{
Updates the information for an existing site. To remove information for any of the parameters, specify an empty string.

See \url{https://paws-r.github.io/docs/networkmanager/update_site.html} for full documentation.
}
\keyword{internal}
