% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/globalaccelerator_operations.R
\name{globalaccelerator_create_custom_routing_accelerator}
\alias{globalaccelerator_create_custom_routing_accelerator}
\title{Create a custom routing accelerator}
\usage{
globalaccelerator_create_custom_routing_accelerator(Name, IpAddressType,
  Enabled, IdempotencyToken, Tags)
}
\arguments{
\item{Name}{[required] The name of a custom routing accelerator. The name can have a maximum of
64 characters, must contain only alphanumeric characters or hyphens (-),
and must not begin or end with a hyphen.}

\item{IpAddressType}{The value for the address type must be IPv4.}

\item{Enabled}{Indicates whether an accelerator is enabled. The value is true or false.
The default value is true.

If the value is set to true, an accelerator cannot be deleted. If set to
false, the accelerator can be deleted.}

\item{IdempotencyToken}{[required] A unique, case-sensitive identifier that you provide to ensure the
idempotency—that is, the uniqueness—of the request.}

\item{Tags}{Create tags for an accelerator.

For more information, see \href{https://docs.aws.amazon.com/global-accelerator/latest/dg/tagging-in-global-accelerator.html}{Tagging in AWS Global Accelerator}
in the \emph{AWS Global Accelerator Developer Guide}.}
}
\value{
A list with the following syntax:\preformatted{list(
  Accelerator = list(
    AcceleratorArn = "string",
    Name = "string",
    IpAddressType = "IPV4",
    Enabled = TRUE|FALSE,
    IpSets = list(
      list(
        IpFamily = "string",
        IpAddresses = list(
          "string"
        )
      )
    ),
    DnsName = "string",
    Status = "DEPLOYED"|"IN_PROGRESS",
    CreatedTime = as.POSIXct(
      "2015-01-01"
    ),
    LastModifiedTime = as.POSIXct(
      "2015-01-01"
    )
  )
)
}
}
\description{
Create a custom routing accelerator. A custom routing accelerator
directs traffic to one of possibly thousands of Amazon EC2 instance
destinations running in a single or multiple virtual private clouds
(VPC) subnet endpoints.

Be aware that, by default, all destination EC2 instances in a VPC subnet
endpoint cannot receive traffic. To enable all destinations to receive
traffic, or to specify individual port mappings that can receive
traffic, see the
\href{https://docs.aws.amazon.com/global-accelerator/latest/api/API_AllowCustomRoutingTraffic.html}{AllowCustomRoutingTraffic}
operation.
}
\section{Request syntax}{
\preformatted{svc$create_custom_routing_accelerator(
  Name = "string",
  IpAddressType = "IPV4",
  Enabled = TRUE|FALSE,
  IdempotencyToken = "string",
  Tags = list(
    list(
      Key = "string",
      Value = "string"
    )
  )
)
}
}

\keyword{internal}
