% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/elbv2_operations.R
\name{elbv2_set_rule_priorities}
\alias{elbv2_set_rule_priorities}
\title{Sets the priorities of the specified rules}
\usage{
elbv2_set_rule_priorities(RulePriorities)
}
\arguments{
\item{RulePriorities}{[required] The rule priorities.}
}
\value{
A list with the following syntax:\preformatted{list(
  Rules = list(
    list(
      RuleArn = "string",
      Priority = "string",
      Conditions = list(
        list(
          Field = "string",
          Values = list(
            "string"
          ),
          HostHeaderConfig = list(
            Values = list(
              "string"
            )
          ),
          PathPatternConfig = list(
            Values = list(
              "string"
            )
          ),
          HttpHeaderConfig = list(
            HttpHeaderName = "string",
            Values = list(
              "string"
            )
          ),
          QueryStringConfig = list(
            Values = list(
              list(
                Key = "string",
                Value = "string"
              )
            )
          ),
          HttpRequestMethodConfig = list(
            Values = list(
              "string"
            )
          ),
          SourceIpConfig = list(
            Values = list(
              "string"
            )
          )
        )
      ),
      Actions = list(
        list(
          Type = "forward"|"authenticate-oidc"|"authenticate-cognito"|"redirect"|"fixed-response",
          TargetGroupArn = "string",
          AuthenticateOidcConfig = list(
            Issuer = "string",
            AuthorizationEndpoint = "string",
            TokenEndpoint = "string",
            UserInfoEndpoint = "string",
            ClientId = "string",
            ClientSecret = "string",
            SessionCookieName = "string",
            Scope = "string",
            SessionTimeout = 123,
            AuthenticationRequestExtraParams = list(
              "string"
            ),
            OnUnauthenticatedRequest = "deny"|"allow"|"authenticate",
            UseExistingClientSecret = TRUE|FALSE
          ),
          AuthenticateCognitoConfig = list(
            UserPoolArn = "string",
            UserPoolClientId = "string",
            UserPoolDomain = "string",
            SessionCookieName = "string",
            Scope = "string",
            SessionTimeout = 123,
            AuthenticationRequestExtraParams = list(
              "string"
            ),
            OnUnauthenticatedRequest = "deny"|"allow"|"authenticate"
          ),
          Order = 123,
          RedirectConfig = list(
            Protocol = "string",
            Port = "string",
            Host = "string",
            Path = "string",
            Query = "string",
            StatusCode = "HTTP_301"|"HTTP_302"
          ),
          FixedResponseConfig = list(
            MessageBody = "string",
            StatusCode = "string",
            ContentType = "string"
          ),
          ForwardConfig = list(
            TargetGroups = list(
              list(
                TargetGroupArn = "string",
                Weight = 123
              )
            ),
            TargetGroupStickinessConfig = list(
              Enabled = TRUE|FALSE,
              DurationSeconds = 123
            )
          )
        )
      ),
      IsDefault = TRUE|FALSE
    )
  )
)
}
}
\description{
Sets the priorities of the specified rules.

You can reorder the rules as long as there are no priority conflicts in
the new order. Any existing rules that you do not specify retain their
current priority.
}
\section{Request syntax}{
\preformatted{svc$set_rule_priorities(
  RulePriorities = list(
    list(
      RuleArn = "string",
      Priority = 123
    )
  )
)
}
}

\examples{
\dontrun{
# This example sets the priority of the specified rule.
svc$set_rule_priorities(
  RulePriorities = list(
    list(
      Priority = 5L,
      RuleArn = "arn:aws:elasticloadbalancing:us-west-2:123456789012:listen..."
    )
  )
)
}

}
\keyword{internal}
