% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/directconnect_operations.R
\name{directconnect_create_connection}
\alias{directconnect_create_connection}
\title{Creates a connection between a customer network and a specific AWS
Direct Connect location}
\usage{
directconnect_create_connection(location, bandwidth, connectionName,
  lagId, tags, providerName)
}
\arguments{
\item{location}{[required] The location of the connection.}

\item{bandwidth}{[required] The bandwidth of the connection.}

\item{connectionName}{[required] The name of the connection.}

\item{lagId}{The ID of the LAG.}

\item{tags}{The tags to associate with the lag.}

\item{providerName}{The name of the service provider associated with the requested
connection.}
}
\value{
A list with the following syntax:\preformatted{list(
  ownerAccount = "string",
  connectionId = "string",
  connectionName = "string",
  connectionState = "ordering"|"requested"|"pending"|"available"|"down"|"deleting"|"deleted"|"rejected"|"unknown",
  region = "string",
  location = "string",
  bandwidth = "string",
  vlan = 123,
  partnerName = "string",
  loaIssueTime = as.POSIXct(
    "2015-01-01"
  ),
  lagId = "string",
  awsDevice = "string",
  jumboFrameCapable = TRUE|FALSE,
  awsDeviceV2 = "string",
  hasLogicalRedundancy = "unknown"|"yes"|"no",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  providerName = "string"
)
}
}
\description{
Creates a connection between a customer network and a specific AWS
Direct Connect location.

A connection links your internal network to an AWS Direct Connect
location over a standard Ethernet fiber-optic cable. One end of the
cable is connected to your router, the other to an AWS Direct Connect
router.

To find the locations for your Region, use
\code{\link[=directconnect_describe_locations]{describe_locations}}.

You can automatically add the new connection to a link aggregation group
(LAG) by specifying a LAG ID in the request. This ensures that the new
connection is allocated on the same AWS Direct Connect endpoint that
hosts the specified LAG. If there are no available ports on the
endpoint, the request fails and no connection is created.
}
\section{Request syntax}{
\preformatted{svc$create_connection(
  location = "string",
  bandwidth = "string",
  connectionName = "string",
  lagId = "string",
  tags = list(
    list(
      key = "string",
      value = "string"
    )
  ),
  providerName = "string"
)
}
}

\keyword{internal}
